package jp.nekoteki.android.demowatcher;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;

public class EventReceiver extends BroadcastReceiver {

	@Override
	public void onReceive(Context context, Intent intent) {
		String act = intent.getAction();
		SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(context);
		if (act.equals(Intent.ACTION_BOOT_COMPLETED) &&
				prefs.getBoolean("handle_boot", true)) {
			new WatchService().schedule(context);
		} else if (act.equals(Intent.ACTION_POWER_CONNECTED) &&
				prefs.getBoolean("handle_power_connected", true)) {
			new WatchService().schedule(context);
		} else if (act.equals(Intent.ACTION_POWER_DISCONNECTED) &&
				prefs.getBoolean("handle_power_disconnected", true)) {
			new WatchService().cancelSchedule(context);
		}

	}
}
