/*
 * File: downloads.hh
 *
 * Copyright (C) 2013 Hiroyuki Nagata <newserver002@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 */

#ifndef DOWNLOADS_HH
#define DOWNLOADS_HH

#include <wx/wx.h>
#include <wx/image.h>

class wxDilloProgressDialog: public wxDialog {

public:
     // default ctor
     wxDilloProgressDialog(wxWindow* parent, int id, const wxString& title, 
			   const wxPoint& pos=wxDefaultPosition, 
			   const wxSize& size=wxDefaultSize, 
			   long style=wxDEFAULT_DIALOG_STYLE);

     void range(double min, double max, double step = 1)  {
	  mMin = min; mMax = max; mStep = step;
     };

     //void      step(double step)         { mPresent += step; redraw(); };
     void      move(double step);        
     double    minimum()                 { return mMin; }
     double    maximum()                 { return mMax; }
     void      minimum(double nm)        { mMin = nm; };
     void      maximum(double nm)        { mMax = nm; };
     double    position()                { return mPresent; }
     double    step()                    { return mStep; }
     //void      position(double pos)      { mPresent = pos; redraw(); }
     void      showtext(bool st)         { mShowPct = st; }
     //void      message(char *msg)        { mShowMsg = true; strncpy(mMsg,msg,63); redraw(); }
     bool      showtext()                { return mShowPct; }
     void      text_color(wxColour* col) { mTextColor = col; }
     wxColour* text_color()              { return mTextColor; }

private:
     void set_properties();
     void do_layout();

protected:
     double    mMin;
     double    mMax;
     double    mPresent;
     double    mStep;
     bool      mShowPct, mShowMsg;
     char      mMsg[64];
     wxColour* mTextColor;

protected:
     wxStaticBox* vbox_staticbox;
     wxStaticBox* vboxTime_staticbox;
     wxStaticBox* vboxMomentum_staticbox;
     wxStaticBox* vboxRate_staticbox;
     wxStaticBox* vboxSize_staticbox;
     wxStaticBox* vboxGot_staticbox;
     wxButton* filenameButton;
     wxButton* doneButton;
     wxPanel* panel_1;
     wxGauge* progressWidgets;
     wxStaticText* labelGot;
     wxStaticText* labelGotVal;
     wxPanel* panelGot;
     wxStaticText* labelSize;
     wxStaticText* labelSizeVal;
     wxPanel* panelSize;
     wxStaticText* labelRate;
     wxStaticText* labelRateVal;
     wxPanel* panelRate;
     wxStaticText* labelMomentum;
     wxStaticText* labelRateVal_copy;
     wxPanel* panelMomentum;
     wxStaticText* labelTime;
     wxStaticText* labelTimeVal;
     wxPanel* panelTime;
     wxPanel* panel_2;
};

#endif // DOWNLOADS_HH
