/*
 * File: downloads.cc
 *
 * Copyright (C) 2005-2007 Jorge Arellano Cid <jcid@dillo.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 */

/*
 * A wxWidgets-based GUI for the downloads dpi (dillo plugin).
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <ctype.h>
#include <math.h>
#include <time.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/un.h>
#include <sys/wait.h>

#include <wx/wx.h>
#include <wx/colour.h>

#include "dpiutil.h"
#include "../dpip/dpip.h"
#include "downloads.hh"

/*
 * Debugging macros
 */
#define _MSG(...)
#define MSG(...)  printf("[downloads dpi]: " __VA_ARGS__)

wxDilloProgressDialog::wxDilloProgressDialog(wxWindow* parent, int id, const wxString& title, 
					     const wxPoint& pos, const wxSize& size, long style):
     wxDialog(parent, id, title, pos, size, wxDEFAULT_DIALOG_STYLE)
{
     panel_2 = new wxPanel(this, wxID_ANY);
     panelTime = new wxPanel(panel_2, wxID_ANY);
     panelMomentum = new wxPanel(panel_2, wxID_ANY);
     panelRate = new wxPanel(panel_2, wxID_ANY);
     panelSize = new wxPanel(panel_2, wxID_ANY);
     panelGot = new wxPanel(panel_2, wxID_ANY);
     vboxGot_staticbox = new wxStaticBox(panelGot, -1, wxEmptyString);
     vboxSize_staticbox = new wxStaticBox(panelSize, -1, wxEmptyString);
     vboxRate_staticbox = new wxStaticBox(panelRate, -1, wxEmptyString);
     vboxMomentum_staticbox = new wxStaticBox(panelMomentum, -1, wxEmptyString);
     vboxTime_staticbox = new wxStaticBox(panelTime, -1, wxEmptyString);
     vbox_staticbox = new wxStaticBox(this, -1, wxEmptyString);
     panel_1 = new wxPanel(this, wxID_ANY);
     filenameButton = new wxButton(panel_1, wxID_ANY, wxT("filename"), wxDefaultPosition, wxDefaultSize, wxBU_LEFT);
     doneButton = new wxButton(panel_1, wxID_ANY, wxT("Done"));
     progressWidgets = new wxGauge(panel_2, wxID_ANY, 100);
     labelGot = new wxStaticText(panelGot, wxID_ANY, wxT("Got"));
     labelGotVal = new wxStaticText(panelGot, wxID_ANY, wxT("2.6MB"));
     labelSize = new wxStaticText(panelSize, wxID_ANY, wxT("Size"));
     labelSizeVal = new wxStaticText(panelSize, wxID_ANY, wxT("2.6MB"));
     labelRate = new wxStaticText(panelRate, wxID_ANY, wxT("Rate"));
     labelRateVal = new wxStaticText(panelRate, wxID_ANY, wxT("1014K/s"));
     labelMomentum = new wxStaticText(panelMomentum, wxID_ANY, wxT("~Rate"));
     labelRateVal_copy = new wxStaticText(panelMomentum, wxID_ANY, wxT("895K/s"));
     labelTime = new wxStaticText(panelTime, wxID_ANY, wxT("~Rate"));
     labelTimeVal = new wxStaticText(panelTime, wxID_ANY, wxT("3s"));

     set_properties();
     do_layout();
}


void wxDilloProgressDialog::set_properties()
{
     SetTitle(wxT("Downloads:"));
     progressWidgets->SetMinSize(wxSize(200, 50));
     labelGot->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_GRAYTEXT));
     labelSize->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_GRAYTEXT));
     labelRate->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_GRAYTEXT));
     labelMomentum->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_GRAYTEXT));
     labelTime->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_GRAYTEXT));
}


void wxDilloProgressDialog::do_layout()
{
     wxStaticBoxSizer* vbox = new wxStaticBoxSizer(vbox_staticbox, wxVERTICAL);
     wxBoxSizer* sizer_1 = new wxBoxSizer(wxHORIZONTAL);
     wxStaticBoxSizer* vboxTime = new wxStaticBoxSizer(vboxTime_staticbox, wxVERTICAL);
     wxStaticBoxSizer* vboxMomentum = new wxStaticBoxSizer(vboxMomentum_staticbox, wxVERTICAL);
     wxStaticBoxSizer* vboxRate = new wxStaticBoxSizer(vboxRate_staticbox, wxVERTICAL);
     wxStaticBoxSizer* vboxSize = new wxStaticBoxSizer(vboxSize_staticbox, wxVERTICAL);
     wxStaticBoxSizer* vboxGot = new wxStaticBoxSizer(vboxGot_staticbox, wxVERTICAL);
     wxBoxSizer* hbox1 = new wxBoxSizer(wxHORIZONTAL);
     hbox1->Add(filenameButton, 1, 0, 0);
     hbox1->Add(doneButton, 0, 0, 0);
     panel_1->SetSizer(hbox1);
     vbox->Add(panel_1, 1, wxEXPAND, 0);
     sizer_1->Add(progressWidgets, 1, wxALL|wxEXPAND, 5);
     vboxGot->Add(labelGot, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
     vboxGot->Add(labelGotVal, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
     panelGot->SetSizer(vboxGot);
     sizer_1->Add(panelGot, 1, wxALL|wxEXPAND, 0);
     vboxSize->Add(labelSize, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
     vboxSize->Add(labelSizeVal, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
     panelSize->SetSizer(vboxSize);
     sizer_1->Add(panelSize, 1, wxEXPAND, 0);
     vboxRate->Add(labelRate, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
     vboxRate->Add(labelRateVal, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
     panelRate->SetSizer(vboxRate);
     sizer_1->Add(panelRate, 1, wxEXPAND, 0);
     vboxMomentum->Add(labelMomentum, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
     vboxMomentum->Add(labelRateVal_copy, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
     panelMomentum->SetSizer(vboxMomentum);
     sizer_1->Add(panelMomentum, 1, wxEXPAND, 0);
     vboxTime->Add(labelTime, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
     vboxTime->Add(labelTimeVal, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
     panelTime->SetSizer(vboxTime);
     sizer_1->Add(panelTime, 1, wxEXPAND, 0);
     panel_2->SetSizer(sizer_1);
     vbox->Add(panel_2, 1, wxEXPAND, 0);
     SetSizer(vbox);
     vbox->Fit(this);
     Layout();
}
