/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : PE_LDD.h.h
**     Project     : ProcessorExpert
**     Processor   : MKL25Z128VLK4
**     Version     : Component 01.025, Driver 01.04, CPU db: 3.00.000
**     Compiler    : GNU C Compiler
**     Date/Time   : 2013-08-28, 13:37, # CodeGen: 25
**     Abstract    :
**
**     Settings    :
**
**
**     Copyright : 1997 - 2012 Freescale, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/
#ifndef __PE_LDD_H
#define __PE_LDD_H

/* MODULE PE_LDD. */

#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"

/* Logical Device Driver API version */
#define PE_LDD_VERSION                           0x0100U

/* LDD driver states */
#define PE_LDD_DRIVER_DISABLED_IN_CLOCK_CONFIGURATION 0x01U
#define PE_LDD_DRIVER_DISABLED_BY_USER           0x02U
#define PE_LDD_DRIVER_BUSY                       0x04U

/* Macro to register component device structure */
#define PE_LDD_RegisterDeviceStructure(ComponentIndex, DeviceStructure) (PE_LDD_DeviceDataList[ComponentIndex] = DeviceStructure)

/* Macro to unregister component device structure */
#define PE_LDD_UnregisterDeviceStructure(ComponentIndex) (PE_LDD_DeviceDataList[ComponentIndex] = NULL)

/* Macro to get the component device structure */
#define PE_LDD_GetDeviceStructure(ComponentIndex) (PE_LDD_DeviceDataList[ComponentIndex])

/*
** ===========================================================================
** LDD component ID specifying the component instance in the project. This ID
** is used internally as an index to the array of LDD device structures.
** ===========================================================================
*/
#define PE_LDD_COMPONENT_IO1_ID                  0x00U
#define PE_LDD_COMPONENT_TU1_ID                  0x01U
#define PE_LDD_COMPONENT_GPIO1_ID                0x02U

/*
** ===================================================================
** Global HAL types and constants
** ===================================================================
*/
typedef uint32_t LDD_TPinMask;         /* Pin mask type. */

typedef uint16_t LDD_TError;           /* Error type. */

typedef uint32_t LDD_TEventMask;       /* Event mask type. */

typedef uint8_t LDD_TClockConfiguration; /* CPU clock configuration type. */

typedef void LDD_TDeviceData;          /* Pointer to private device structure managed and used by HAL components. */
typedef void* LDD_TDeviceDataPtr;      /* Obsolete type for backward compatibility. */

typedef void LDD_TData;                /* General pointer to data. */

typedef void LDD_TUserData;            /* Pointer to this type specifies the user or RTOS specific data will be passed as an event or callback parameter. */

typedef enum {
  DOM_NONE,
  DOM_RUN,
  DOM_WAIT,
  DOM_SLEEP,
  DOM_STOP
} LDD_TDriverOperationMode;            /* Driver operation mode type. */

typedef uint16_t LDD_TDriverState;     /* Driver state type. */

typedef void LDD_TCallbackParam;       /* Pointer to this type specifies the user data to be passed as a callback parameter. */
typedef void (* LDD_TCallback)(LDD_TCallbackParam *CallbackParam); /* Callback type used for definition of callback functions. */

extern LDD_TDeviceData *PE_LDD_DeviceDataList[]; /* Array of LDD component device structures */


/*
** ===================================================================
** RTOS specific types and constants
** ===================================================================
*/
/* {Default RTOS Adapter} RTOS specific definition of type of Ioctl() command constants */


/*
** ===================================================================
** Published RTOS settings and constants
** ===================================================================
*/
/* {Default RTOS Adapter} No published RTOS settings */


/*
** ===================================================================
** TimerUnit device types and constants
** ===================================================================
*/
#define LDD_TIMERUNIT_ON_CHANNEL_0           0x01u /* OnChannel0 event mask value */
#define LDD_TIMERUNIT_ON_CHANNEL_1           0x02u /* OnChannel1 event mask value */
#define LDD_TIMERUNIT_ON_CHANNEL_2           0x04u /* OnChannel2 event mask value */
#define LDD_TIMERUNIT_ON_CHANNEL_3           0x08u /* OnChannel3 event mask value */
#define LDD_TIMERUNIT_ON_CHANNEL_4           0x10u /* OnChannel4 event mask value */
#define LDD_TIMERUNIT_ON_CHANNEL_5           0x20u /* OnChannel5 event mask value */
#define LDD_TIMERUNIT_ON_CHANNEL_6           0x40u /* OnChannel6 event mask value */
#define LDD_TIMERUNIT_ON_CHANNEL_7           0x80u /* OnChannel7 event mask value */
#define LDD_TIMERUNIT_ON_COUNTER_RESTART     0x0100u /* OnCounterRestart event mask value */

typedef enum {                         /* Direction of counting */
  DIR_UP,
  DIR_DOWNS
} LDD_TimerUnit_TCounterDirection;

typedef enum                          { /* Output action type (flip-flop action on overrun or compare match) */
  OUTPUT_NONE,
  OUTPUT_TOGGLE,
  OUTPUT_CLEAR,
  OUTPUT_SET
} LDD_TimerUnit_TOutAction;

typedef enum  {                        /* Input edge type */
  EDGE_NONE,
  EDGE_RISING,
  EDGE_FALLING,
  EDGE_BOTH
} LDD_TimerUnit_TEdge;

typedef float LDD_TimerUnit_Tfloat;    /* Float type */

/*
** ===================================================================
** CMT device types and constants
** ===================================================================
*/
#define LDD_CMT_ON_END                       0x01u /* OnEnd event mask value */

/*
** ===================================================================
** PWM types and constants
** ===================================================================
*/
#define LDD_PWM_ON_END                       0x01u /* OnEnd event mask value */

/*
** ===================================================================
** TimerInt types and constants
** ===================================================================
*/
#define LDD_TIMERINT_ON_INTERRUPT            0x01u /* OnInterrupt event mask value */

/*
** ===================================================================
** TimerOut types and constants
** ===================================================================
*/
#define LDD_TIMEROUT_ON_INTERRUPT            0x01u /* OnInterrupt event mask value */

/*
** ===================================================================
** EventCntr types and constants
** ===================================================================
*/
#define LDD_EVENTCNTR_ON_END                 0x01u /* OnEnd event mask value */

/*
** ===================================================================
** UART device types and constants
** ===================================================================
*/
#define LDD_SERIAL_RX_PIN                      0x01u /* Receiver pin mask */
#define LDD_SERIAL_TX_PIN                      0x02u /* Transmitter pin mask */
#define LDD_SERIAL_CTS_PIN                     0x04u /* CTS pin mask */
#define LDD_SERIAL_RTS_PIN                     0x08u /* RTS pin mask */

#define LDD_SERIAL_ON_BLOCK_RECEIVED           0x01u /* OnBlockReceived event mask */
#define LDD_SERIAL_ON_BLOCK_SENT               0x02u /* OnBlockSent event mask */
#define LDD_SERIAL_ON_BREAK                    0x04u /* OnBreak event mask */
#define LDD_SERIAL_ON_TXCOMPLETE               0x08u /* OnTxComplete event mask */
#define LDD_SERIAL_ON_ERROR                    0x10u /* OnError event mask */

#define LDD_SERIAL_RX_OVERRUN                  0x01u /* Receiver overrun */
#define LDD_SERIAL_PARITY_ERROR                0x02u /* Parity error */
#define LDD_SERIAL_FRAMING_ERROR               0x04u /* Framing error */
#define LDD_SERIAL_NOISE_ERROR                 0x08u /* Noise error */

typedef uint32_t LDD_SERIAL_TError;    /* Serial communication error type */

typedef uint8_t LDD_SERIAL_TDataWidth; /* Bit length type. The number of bits transmitted by one character. */

typedef uint16_t LDD_SERIAL_TSize;     /* Type specifying the length of the data or buffer. */

typedef uint8_t LDD_SERIAL_TBaudMode;  /* Type specifying the baud mode. */

typedef enum {                         /* Type specifying the parity. */
  LDD_SERIAL_PARITY_UNDEF,
  LDD_SERIAL_PARITY_NONE,
  LDD_SERIAL_PARITY_ODD,
  LDD_SERIAL_PARITY_EVEN,
  LDD_SERIAL_PARITY_MARK,
  LDD_SERIAL_PARITY_SPACE
} LDD_SERIAL_TParity;

typedef enum {                         /* Type specifying the stop bit length. */
  LDD_SERIAL_STOP_BIT_LEN_UNDEF,
  LDD_SERIAL_STOP_BIT_LEN_1,
  LDD_SERIAL_STOP_BIT_LEN_1_5,
  LDD_SERIAL_STOP_BIT_LEN_2
} LDD_SERIAL_TStopBitLen;

typedef struct {                       /* Communication statistics */
  uint32_t ReceivedChars;              /* Number of received characters */
  uint32_t SentChars;                  /* Number of transmitted characters */
  uint32_t ReceivedBreaks;             /* Number of received break characters */
  uint32_t ParityErrors;               /* Number of receiver parity errors */
  uint32_t FramingErrors;              /* Number of receiver framing errors */
  uint32_t OverrunErrors;              /* Number of receiver overrun errors */
  uint32_t NoiseErrors;                /* Number of receiver noise errors */
} LDD_SERIAL_TStats;

typedef enum {                         /* Type specifying the loop mode operation. */
  LOOPMODE_UNDEF,
  LOOPMODE_NORMAL,
  LOOPMODE_AUTO_ECHO,
  LOOPMODE_LOCAL_LOOPBACK,
  LOOPMODE_REMOTE_LOOPBACK
} LDD_SERIAL_TLoopMode;


/*
** ===================================================================
** ADC device types and constants
** ===================================================================
*/

#define LDD_ADC_CHANNEL_0_PIN                0x01u /* Channel 0 pin mask */
#define LDD_ADC_CHANNEL_1_PIN                0x02u /* Channel 1 pin mask */
#define LDD_ADC_CHANNEL_2_PIN                0x04u /* Channel 2 pin mask */
#define LDD_ADC_CHANNEL_3_PIN                0x08u /* Channel 3 pin mask */
#define LDD_ADC_CHANNEL_4_PIN                0x10u /* Channel 4 pin mask */
#define LDD_ADC_CHANNEL_5_PIN                0x20u /* Channel 5 pin mask */
#define LDD_ADC_CHANNEL_6_PIN                0x40u /* Channel 6 pin mask */
#define LDD_ADC_CHANNEL_7_PIN                0x80u /* Channel 7 pin mask */
#define LDD_ADC_CHANNEL_8_PIN                0x0100u /* Channel 8 pin mask */
#define LDD_ADC_CHANNEL_9_PIN                0x0200u /* Channel 9 pin mask */
#define LDD_ADC_CHANNEL_10_PIN                0x0400u /* Channel 10 pin mask */
#define LDD_ADC_CHANNEL_11_PIN                0x0800u /* Channel 11 pin mask */
#define LDD_ADC_CHANNEL_12_PIN                0x1000u /* Channel 12 pin mask */
#define LDD_ADC_CHANNEL_13_PIN                0x2000u /* Channel 13 pin mask */
#define LDD_ADC_CHANNEL_14_PIN                0x4000u /* Channel 14 pin mask */
#define LDD_ADC_CHANNEL_15_PIN                0x8000u /* Channel 15 pin mask */
#define LDD_ADC_CHANNEL_16_PIN                0x00010000u /* Channel 16 pin mask */
#define LDD_ADC_CHANNEL_17_PIN                0x00020000u /* Channel 17 pin mask */
#define LDD_ADC_CHANNEL_18_PIN                0x00040000u /* Channel 18 pin mask */
#define LDD_ADC_CHANNEL_19_PIN                0x00080000u /* Channel 19 pin mask */
#define LDD_ADC_CHANNEL_20_PIN                0x00100000u /* Channel 20 pin mask */
#define LDD_ADC_CHANNEL_21_PIN                0x00200000u /* Channel 21 pin mask */
#define LDD_ADC_CHANNEL_22_PIN                0x00400000u /* Channel 22 pin mask */
#define LDD_ADC_CHANNEL_23_PIN                0x00800000u /* Channel 23 pin mask */
#define LDD_ADC_CHANNEL_24_PIN                0x01000000u /* Channel 24 pin mask */
#define LDD_ADC_CHANNEL_25_PIN                0x02000000u /* Channel 25 pin mask */
#define LDD_ADC_CHANNEL_26_PIN                0x04000000u /* Channel 26 pin mask */
#define LDD_ADC_CHANNEL_27_PIN                0x08000000u /* Channel 27 pin mask */
#define LDD_ADC_CHANNEL_28_PIN                0x10000000u /* Channel 28 pin mask */
#define LDD_ADC_CHANNEL_29_PIN                0x20000000u /* Channel 29 pin mask */
#define LDD_ADC_CHANNEL_30_PIN                0x40000000u /* Channel 30 pin mask */
#define LDD_ADC_CHANNEL_31_PIN                0x80000000u /* Channel 31 pin mask */
#define LDD_ADC_CHANNEL_32_PIN                0x01u /* Channel 32 pin mask */
#define LDD_ADC_CHANNEL_33_PIN                0x02u /* Channel 33 pin mask */
#define LDD_ADC_CHANNEL_34_PIN                0x04u /* Channel 34 pin mask */
#define LDD_ADC_CHANNEL_35_PIN                0x08u /* Channel 35 pin mask */
#define LDD_ADC_CHANNEL_36_PIN                0x10u /* Channel 36 pin mask */
#define LDD_ADC_CHANNEL_37_PIN                0x20u /* Channel 37 pin mask */
#define LDD_ADC_CHANNEL_38_PIN                0x40u /* Channel 38 pin mask */
#define LDD_ADC_CHANNEL_39_PIN                0x80u /* Channel 39 pin mask */
#define LDD_ADC_CHANNEL_40_PIN                0x0100u /* Channel 40 pin mask */
#define LDD_ADC_CHANNEL_41_PIN                0x0200u /* Channel 41 pin mask */
#define LDD_ADC_CHANNEL_42_PIN                0x0400u /* Channel 42 pin mask */
#define LDD_ADC_CHANNEL_43_PIN                0x0800u /* Channel 43 pin mask */
#define LDD_ADC_CHANNEL_44_PIN                0x1000u /* Channel 44 pin mask */
#define LDD_ADC_CHANNEL_45_PIN                0x2000u /* Channel 45 pin mask */
#define LDD_ADC_CHANNEL_46_PIN                0x4000u /* Channel 46 pin mask */
#define LDD_ADC_CHANNEL_47_PIN                0x8000u /* Channel 47 pin mask */
#define LDD_ADC_CHANNEL_48_PIN                0x00010000u /* Channel 48 pin mask */
#define LDD_ADC_CHANNEL_49_PIN                0x00020000u /* Channel 49 pin mask */
#define LDD_ADC_CHANNEL_50_PIN                0x00040000u /* Channel 50 pin mask */
#define LDD_ADC_CHANNEL_51_PIN                0x00080000u /* Channel 51 pin mask */
#define LDD_ADC_CHANNEL_52_PIN                0x00100000u /* Channel 52 pin mask */
#define LDD_ADC_CHANNEL_53_PIN                0x00200000u /* Channel 53 pin mask */
#define LDD_ADC_CHANNEL_54_PIN                0x00400000u /* Channel 54 pin mask */
#define LDD_ADC_CHANNEL_55_PIN                0x00800000u /* Channel 55 pin mask */
#define LDD_ADC_CHANNEL_56_PIN                0x01000000u /* Channel 56 pin mask */
#define LDD_ADC_CHANNEL_57_PIN                0x02000000u /* Channel 57 pin mask */
#define LDD_ADC_CHANNEL_58_PIN                0x04000000u /* Channel 58 pin mask */
#define LDD_ADC_CHANNEL_59_PIN                0x08000000u /* Channel 59 pin mask */
#define LDD_ADC_CHANNEL_60_PIN                0x10000000u /* Channel 60 pin mask */
#define LDD_ADC_CHANNEL_61_PIN                0x20000000u /* Channel 61 pin mask */
#define LDD_ADC_CHANNEL_62_PIN                0x40000000u /* Channel 62 pin mask */
#define LDD_ADC_CHANNEL_63_PIN                0x80000000u /* Channel 63 pin mask */

#define LDD_ADC_TRIGGER_0_PIN                0x01u /* Trigger 0 pin mask */
#define LDD_ADC_TRIGGER_1_PIN                0x02u /* Trigger 1 pin mask */

#define LDD_ADC_LOW_VOLT_REF_PIN             0x01u /* Low voltage reference pin mask */
#define LDD_ADC_HIGH_VOLT_REF_PIN            0x02u /* High voltage reference pin mask */

#define LDD_ADC_ON_MEASUREMENT_COMPLETE 0x40u /* OnMeasurementComplete event mask */

typedef struct {                       /* Structure pins for pin connection method */
  uint32_t Channel0_31PinMask;         /* Channel pin mask for channels 0 through 31 */
  uint32_t Channel32_63PinMask;        /* Channel pin mask for channels 32 through 63 */
  uint16_t TriggerPinMask;             /* Trigger pin mask */
  uint8_t  VoltRefPinMask;             /* Voltage reference pin mask */
} LDD_ADC_TPinMask;

typedef struct {                       /* Structure used to describing one sample */
  uint8_t ChannelIdx;                  /* Channel index */
} LDD_ADC_TSample;

typedef enum {                         /* Type specifying the ADC compare mode */
  LDD_ADC_LESS_THAN                     = 0x00u, /* Compare true if the result is less than the Low compare value */
  LDD_ADC_GREATER_THAN_OR_EQUAL         = 0x01u, /* Compare true if the result is greater than or equal to Low compare value */
  LDD_ADC_INSIDE_RANGE_INCLUSIVE        = 0x02u, /* Compare true if the result is greater than or equal to Low compare value and the result is less than or equal to High compare value */
  LDD_ADC_INSIDE_RANGE_NOT_INCLUSIVE    = 0x03u, /* Compare true if the result is greater than Low compare value and the result is less than High compare value */
  LDD_ADC_OUTSIDE_RANGE_INCLUSIVE       = 0x04u, /* Compare true if the result is less than or equal to Low compare value or the result is greater than or equal to High compare value */
  LDD_ADC_OUTSIDE_RANGE_NOT_INCLUSIVE   = 0x05u /* Compare true if the result is less than Low compare value or the result is greater than High compare value */
} LDD_ADC_TCompareMode;

/*
** ===================================================================
** I2C device types and constants
** ===================================================================
*/

#define LDD_I2C_SDA_PIN                        0x01u /* SDA pin mask */
#define LDD_I2C_SCL_PIN                        0x02u /* SCL pin  mask */

#define LDD_I2C_ON_MASTER_BLOCK_SENT           0x0001u /*  OnMasterBlockSent event mask */
#define LDD_I2C_ON_MASTER_BLOCK_RECEIVED       0x0002u /*  OnMasterBlockReceived event mask */
#define LDD_I2C_ON_SLAVE_BLOCK_SENT            0x0004u /*  OnSlaveBlockSent event mask */
#define LDD_I2C_ON_SLAVE_BLOCK_RECEIVED        0x0008u /*  OnSlaveBlockReceived event mask */
#define LDD_I2C_ON_SLAVE_TX_REQUEST            0x0010u /*  OnSlaveTxRequest event mask */
#define LDD_I2C_ON_SLAVE_RX_REQUEST            0x0020u /*  OnSlaveRxRequest event mask */
#define LDD_I2C_ON_ERROR                       0x0040u /*  OnError event mask */
#define LDD_I2C_ON_SLAVE_SM_BUS_CALL_ADDR      0x0080u /*  OnSlaveSMBusCallAddr event mask */
#define LDD_I2C_ON_SLAVE_SM_BUS_ALERT_RESPONSE 0x0100u /*  OnSlaveSMBusAlertResponse event mask */
#define LDD_I2C_ON_SLAVE_GENERAL_CALL_ADDR     0x0200u /*  OnSlaveGeneralCallAddr event mask */
#define LDD_I2C_ON_MASTER_BYTE_RECEIVED        0x0400u /*  OnMasterByteReceived event mask */
#define LDD_I2C_ON_SLAVE_BYTE_RECEIVED         0x0800u /*  OnMasterByteReceived event mask */

#define LDD_I2C_SLAVE_TX_UNDERRUN              0x0001u /*  SlaveTxUnderrun error mask */
#define LDD_I2C_SLAVE_RX_OVERRUN               0x0002u /*  SlaveRxOverrun error mask */
#define LDD_I2C_ARBIT_LOST                     0x0004u /*  ArbitLost error mask */
#define LDD_I2C_MASTER_NACK                    0x0008u /*  MasterNACK error mask */
#define LDD_I2C_SCL_LOW_TIMEOUT                0x0010u /*  SCLLowTimeout error mask */
#define LDD_I2C_SDA_LOW_TIMEOUT                0x0020u /*  SDALowTimeout error mask */
#define LDD_I2C_SLAVE_NACK                     0x0040u /*  SlaveNACK error mask */

typedef uint16_t LDD_I2C_TSize;        /* Type specifying the length of the data or buffer. */
typedef uint16_t LDD_I2C_TAddr;        /* Type specifying the address variable */
typedef uint16_t LDD_I2C_TErrorMask;   /* Type specifying the error mask type. */
typedef bool LDD_I2C_TMode;            /* Type specifynng the Actual operating mode */

typedef enum {                         /* Type specifying the address type  */
  LDD_I2C_ADDRTYPE_7BITS,
  LDD_I2C_ADDRTYPE_10BITS,
  LDD_I2C_ADDRTYPE_GENERAL_CALL
} LDD_I2C_TAddrType;

typedef enum {                         /* Type specifying generate the stop condition  */
  LDD_I2C_NO_SEND_STOP,
  LDD_I2C_SEND_STOP
} LDD_I2C_TSendStop;

typedef enum {                         /* Type specifying the I2C state of BUS. */
  LDD_I2C_BUSY,
  LDD_I2C_IDLE
} LDD_I2C_TBusState;

typedef enum {                         /* Type specifying the I2C byte acknowledge response. */
  LDD_I2C_ACK_BYTE,
  LDD_I2C_NACK_BYTE
} LDD_I2C_TAckType;

typedef struct {
  uint32_t MasterSentChars;            /* Number of master transmitted characters. */
  uint32_t MasterReceivedChars;        /* Number of master received characters. */
  uint32_t MasterNacks;                /* Number of no acknowledges. */
  uint32_t ArbitLost;                  /* Number of lost the bus arbitration. */
  uint32_t SlaveSentChars;             /* Number of slave transmitted characters. */
  uint32_t SlaveReceivedChars;         /* Number of slave received characters. */
  uint32_t SlaveTxUnderrun;            /* Number of slave underrun. */
  uint32_t SlaveRxOverrun;             /* Number of slave overrun. */
  uint32_t SlaveGeneralCallAddr;       /* Number of a general call address. */
  uint32_t SlaveSmBusCallAddr;         /* Number of a SMBus call address. */
  uint32_t SlaveSmBusAlertResponse;    /* Number of slave SMBus alert response received. */
  uint32_t SCLLowTimeout;              /* Number of SCL low timeout occur. */
  uint32_t SDALowTimeout;              /* Number of SCL low timeout occur. */
} LDD_I2C_TStats;


/*
** ===================================================================
** SegLCD device types and constants
** ===================================================================
*/

#define LDD_SEGLCD_ON_FRAME_FREQUENCY         0x0001u /*  OnFrameFrequency event mask */
#define LDD_SEGLCD_ON_FAULT_DETECT_COMPLETE   0x0002u /*  OnFaultDetectComplete event mask */

typedef uint8_t LDD_SegLCD_TPinIndex;  /* Type specifying the segment LCD pin index variable */
typedef uint8_t LDD_SegLCD_TFrontplaneData; /* Type specifying the frontplane/backplane segment variable */
typedef uint8_t LDD_SegLCD_TFaultValue; /* Type specifying the frontplane/backplane segment variable */

typedef enum {                         /* Types specifying the segment LCD blinking.  */
  LDD_SEGLCD_BLINK_OFF,
  LDD_SEGLCD_BLINK_ALL,
  LDD_SEGLCD_BLINK_ALL_ALTERNATE
} LDD_SegLCD_TBlinking;

typedef enum {                         /* Segment LCD blank state type.  */
  LDD_SEGLCD_BLANK_STATE,
  LDD_SEGLCD_NORMAL_STATE,
  LDD_SEGLCD_ALTERNATE_STATE
} LDD_SegLCD_TSetBlank;

typedef enum {                         /* Segment LCD pin type (frontplane/backplane)  */
  LDD_SEGLCD_BACKPLANE_PIN,
  LDD_SEGLCD_FRONTPLANE_PIN
} LDD_SegLCD_TPinType;


/*
** ===================================================================
** GPIO device types and constants
** ===================================================================
*/

#define LDD_GPIO_PIN_0                0x01u /* Pin 0 inside the port */
#define LDD_GPIO_PIN_1                0x02u /* Pin 1 inside the port */
#define LDD_GPIO_PIN_2                0x04u /* Pin 2 inside the port */
#define LDD_GPIO_PIN_3                0x08u /* Pin 3 inside the port */
#define LDD_GPIO_PIN_4                0x10u /* Pin 4 inside the port */
#define LDD_GPIO_PIN_5                0x20u /* Pin 5 inside the port */
#define LDD_GPIO_PIN_6                0x40u /* Pin 6 inside the port */
#define LDD_GPIO_PIN_7                0x80u /* Pin 7 inside the port */
#define LDD_GPIO_PIN_8                0x0100u /* Pin 8 inside the port */
#define LDD_GPIO_PIN_9                0x0200u /* Pin 9 inside the port */
#define LDD_GPIO_PIN_10                0x0400u /* Pin 10 inside the port */
#define LDD_GPIO_PIN_11                0x0800u /* Pin 11 inside the port */
#define LDD_GPIO_PIN_12                0x1000u /* Pin 12 inside the port */
#define LDD_GPIO_PIN_13                0x2000u /* Pin 13 inside the port */
#define LDD_GPIO_PIN_14                0x4000u /* Pin 14 inside the port */
#define LDD_GPIO_PIN_15                0x8000u /* Pin 15 inside the port */
#define LDD_GPIO_PIN_16                0x00010000u /* Pin 16 inside the port */
#define LDD_GPIO_PIN_17                0x00020000u /* Pin 17 inside the port */
#define LDD_GPIO_PIN_18                0x00040000u /* Pin 18 inside the port */
#define LDD_GPIO_PIN_19                0x00080000u /* Pin 19 inside the port */
#define LDD_GPIO_PIN_20                0x00100000u /* Pin 20 inside the port */
#define LDD_GPIO_PIN_21                0x00200000u /* Pin 21 inside the port */
#define LDD_GPIO_PIN_22                0x00400000u /* Pin 22 inside the port */
#define LDD_GPIO_PIN_23                0x00800000u /* Pin 23 inside the port */
#define LDD_GPIO_PIN_24                0x01000000u /* Pin 24 inside the port */
#define LDD_GPIO_PIN_25                0x02000000u /* Pin 25 inside the port */
#define LDD_GPIO_PIN_26                0x04000000u /* Pin 26 inside the port */
#define LDD_GPIO_PIN_27                0x08000000u /* Pin 27 inside the port */
#define LDD_GPIO_PIN_28                0x10000000u /* Pin 28 inside the port */
#define LDD_GPIO_PIN_29                0x20000000u /* Pin 29 inside the port */
#define LDD_GPIO_PIN_30                0x40000000u /* Pin 30 inside the port */
#define LDD_GPIO_PIN_31                0x80000000u /* Pin 31 inside the port */

#define LDD_GPIO_ON_PORT_EVENT 0x01u   /* OnPortEvent event mask */

typedef uint32_t LDD_GPIO_TBitField;   /* Abstract type specifying the bit field within the port. */

typedef enum {
  LDD_GPIO_DISABLED = 0x00u,           /* Event doesn't invoke */
  LDD_GPIO_LOW      = 0x00080000u,     /* Event when logic zero */
  LDD_GPIO_HIGH     = 0x000C0000u,     /* Event when logic one */
  LDD_GPIO_RISING   = 0x00090000u,     /* Event on rising edge */
  LDD_GPIO_FALLING  = 0x000A0000u,     /* Event on falling edge */
  LDD_GPIO_BOTH     = 0x000B0000u      /* Event on rising and falling edge */
} LDD_GPIO_TEventCondition;            /* Defines condition when event is invoked. */

#define LDD_GPIO_EVENT_CONDITIONS_MASK 0x000F0000u 

/*
** ===================================================================
** Ethernet device types and constants
** ===================================================================
*/

#define LDD_ETH_MDC_PIN     0x01u      /* MDC pin mask */
#define LDD_ETH_MDIO_PIN    0x02u      /* MDIO pin mask */
#define LDD_ETH_COL_PIN     0x04u      /* COL pin mask */
#define LDD_ETH_CRS_PIN     0x08u      /* CRS pin mask */
#define LDD_ETH_TXCLK_PIN   0x10u      /* TXCLK pin mask */
#define LDD_ETH_TXD0_PIN    0x20u      /* TXD0 pin mask */
#define LDD_ETH_TXD1_PIN    0x40u      /* TXD1 pin mask */
#define LDD_ETH_TXD2_PIN    0x80u      /* TXD2 pin mask */
#define LDD_ETH_TXD3_PIN    0x0100u    /* TXD3 pin mask */
#define LDD_ETH_TXEN_PIN    0x0200u    /* TXEN pin mask */
#define LDD_ETH_TXER_PIN    0x0400u    /* TXER pin mask */
#define LDD_ETH_RXCLK_PIN   0x0800u    /* RXCLK pin mask */
#define LDD_ETH_RXDV_PIN    0x1000u    /* RXDV pin mask */
#define LDD_ETH_RXD0_PIN    0x2000u    /* RXD0 pin mask */
#define LDD_ETH_RXD1_PIN    0x4000u    /* RXD1 pin mask */
#define LDD_ETH_RXD2_PIN    0x8000u    /* RXD2 pin mask */
#define LDD_ETH_RXD3_PIN    0x00010000u /* RXD3 pin mask */
#define LDD_ETH_RXER_PIN    0x00020000u /* RXER pin mask */

#define LDD_ETH_ON_FRAME_TRANSMITTED              0x01u /* OnFrameTransmitted event mask */
#define LDD_ETH_ON_FRAME_TRANSMITTED_TIMESTAMPED  0x02u /* OnFrameTransmittedTimestamped event mask */
#define LDD_ETH_ON_FRAME_RECEIVED                 0x04u /* OnFrameReceived event mask */
#define LDD_ETH_ON_FRAME_RECEIVED_TIMESTAMPED     0x08u /* OnFrameReceivedTimestamped event mask */
#define LDD_ETH_ON_MII_FINISHED                   0x10u /* OnMIIFinished event mask */
#define LDD_ETH_ON_FATAL_ERROR                    0x20u /* OnFatalError event mask */
#define LDD_ETH_ON_WAKE_UP                        0x40u /* OnWakeUp event mask */

typedef uint8_t LDD_ETH_TMACAddress[6]; /* Ethernet MAC address */

typedef enum {                         /* Ethernet duplex mode */
  LDD_ETH_FULL_DUPLEX,
  LDD_ETH_HALF_DUPLEX
} LDD_ETH_TDuplexMode;

typedef enum {                         /* Ethernet address filter mode options */
  LDD_ETH_PROMISC,
  LDD_ETH_REJECT_BC,
  LDD_ETH_ACCEPT_BC
} LDD_ETH_TFilterMode;

typedef enum {                         /* Ethernet sleep mode options */
  LDD_ETH_ENABLED,
  LDD_ETH_ENABLED_WITH_WAKEUP,
  LDD_ETH_DISABLED
} LDD_ETH_TSleepMode;

typedef struct {                       /* Ethernet frame buffer (fragment) descriptor */
  uint8_t  *DataPtr;
  uint16_t Size;
} LDD_ETH_TBufferDesc;

typedef LDD_ETH_TBufferDesc* LDD_ETH_TBufferDescPtr;

typedef struct {                       /* Ethernet communication statistics */
  uint32_t TxRMONDropEvents;           /* Count of frames not counted correctly */
  uint32_t TxRMONOctets;               /* Octet count for frames transmitted without error */
  uint32_t TxRMONPackets;              /* Transmitted packet count */
  uint32_t TxRMONBroadcastPackets;     /* Transmitted broadcast packets */
  uint32_t TxRMONMulticastPackets;     /* Transmitted multicast packets */
  uint32_t TxRMONCRCAlignErrors;       /* Transmitted packets with CRC or alignment error */
  uint32_t TxRMONUndersizePackets;     /* Transmitted packets smaller than 64 bytes with good CRC */
  uint32_t TxRMONOversizePackets;      /* Transmitted packets greater than max. frame length with good CRC */
  uint32_t TxRMONFragments;            /* Transmitted packets smaller than 64 bytes with bad CRC */
  uint32_t TxRMONJabbers;              /* Transmitted packets greater than max. frame length with bad CRC */
  uint32_t TxRMONCollisions;           /* Transmit collision count */
  uint32_t TxRMONPackets64Octets;      /* Transmitted 64 byte packets */
  uint32_t TxRMONPackets65To127Octets; /* Transmitted 65 to 127 byte packets */
  uint32_t TxRMONPackets128To255Octets; /* Transmitted 128 to 255 byte packets */
  uint32_t TxRMONPackets256To511Octets; /* Transmitted 256 to 511 byte packets */
  uint32_t TxRMONPackets512To1023Octets; /* Transmitted 512 to 1023 byte packets */
  uint32_t TxRMONPackets1024To2047Octets; /* Transmitted 1024 to 2047 byte packets */
  uint32_t TxRMONPacketsGreaterThan2048Octets; /* Transmitted packets greater than 2048 byte */
  uint32_t TxIEEEDrop;                 /* Count of frames not counted correctly */
  uint32_t TxIEEEFrameOK;              /* Frames transmitted OK */
  uint32_t TxIEEESingleCollision;      /* Frames transmitted with single collision */
  uint32_t TxIEEEMultipleCollisions;   /* Frames transmitted with multiple collisions */
  uint32_t TxIEEEDeferralDelay;        /* Frames transmitted after deferral delay */
  uint32_t TxIEEELateCollision;        /* Frames transmitted with late collision */
  uint32_t TxIEEEExcessiveCollision;   /* Frames transmitted with excessive collisions */
  uint32_t TxIEEEFIFOUnderrun;         /* Frames transmitted with transmit FIFO underrun */
  uint32_t TxIEEECarrierSenseError;    /* Frames transmitted with carrier sense error */
  uint32_t TxIEEESQEError;             /* Frames transmitted with SQE error */
  uint32_t TxIEEEPauseFrame;           /* Flow control pause frames transmitted */
  uint32_t TxIEEEOctetsOK;             /* Octet count for frames transmitted without error */
  uint32_t RxRMONDropEvents;           /* Count of frames not counted correctly */
  uint32_t RxRMONOctets;               /* Octet count for frames recieved without error */
  uint32_t RxRMONPackets;              /* Received packet count */
  uint32_t RxRMONBroadcastPackets;     /* Received broadcast packets */
  uint32_t RxRMONMulticastPackets;     /* Received multicast packets */
  uint32_t RxRMONCRCAlignErrors;       /* Received packets with CRC or alignment error */
  uint32_t RxRMONUndersizePackets;     /* Received packets smaller than 64 bytes with good CRC */
  uint32_t RxRMONOversizePackets;      /* Received packets greater than max. frame length with good CRC */
  uint32_t RxRMONFragments;            /* Received packets smaller than 64 bytes with bad CRC */
  uint32_t RxRMONJabbers;              /* Received packets greater than max. frame length with bad CRC */
  uint32_t RxRMONPackets64Octets;      /* Received 64 byte packets */
  uint32_t RxRMONPackets65To127Octets; /* Received 65 to 127 byte packets */
  uint32_t RxRMONPackets128To255Octets; /* Received 128 to 255 byte packets */
  uint32_t RxRMONPackets256To511Octets; /* Received 256 to 511 byte packets */
  uint32_t RxRMONPackets512To1023Octets; /* Received 512 to 1023 byte packets */
  uint32_t RxRMONPackets1024To2047Octets; /* Received 1024 to 2047 byte packets */
  uint32_t RxRMONPacketsGreaterThan2048Octets; /* Received packets greater than 2048 byte */
  uint32_t RxIEEEDrop;                 /* Count of frames not counted correctly */
  uint32_t RxIEEEFrameOK;              /* Frames received OK */
  uint32_t RxIEEECRCError;             /* Frames received with CRC error */
  uint32_t RxIEEEAlignmentError;       /* Frames received with alignment error */
  uint32_t RxIEEEFIFOOverflow;         /* Receive FIFO overflow count */
  uint32_t RxIEEEPauseFrame;           /* Flow control pause frames received */
  uint32_t RxIEEEOctetsOK;             /* Octet count for frames received without error */
} LDD_ETH_TStats;

/*
** ===================================================================
** FlexCAN device types and constants
** ===================================================================
*/

typedef uint8_t LDD_CAN_TMBIndex;      /* CAN message buffer index */
typedef uint32_t LDD_CAN_TAccMask;     /* Type specifying the acceptance mask variable. */
typedef uint32_t LDD_CAN_TMessageID;   /* Type specifying the ID mask variable. */
typedef uint8_t LDD_CAN_TErrorCounter; /* Type specifying the error counter variable. */
typedef uint32_t LDD_CAN_TErrorMask;   /* Type specifying the error mask variable. */
typedef uint16_t LDD_CAN_TBufferMask;  /* Type specifying the message buffer mask variable. */

#define LDD_CAN_RX_PIN            0x01U /* Rx pin mask */
#define LDD_CAN_TX_PIN            0x02U /* Tx pin mask */

#define LDD_CAN_ON_FULL_RXBUFFER  0x01U /* OnFullRxBuffer event mask */
#define LDD_CAN_ON_FREE_TXBUFFER  0x02U /* OnFreeTxBuffer event mask */
#define LDD_CAN_ON_BUSOFF         0x04U /* OnBusOff event mask */
#define LDD_CAN_ON_TXWARNING      0x08U /* OnTransmitterWarning event mask */
#define LDD_CAN_ON_RXWARNING      0x10U /* OnReceiverWarning event mask */
#define LDD_CAN_ON_ERROR          0x20U /* OnError event mask */
#define LDD_CAN_ON_WAKEUP         0x40U /* OnWakeUp event mask */

#define LDD_CAN_BIT0_ERROR        0x4000UL /* Bit0 error detect error mask */
#define LDD_CAN_BIT1_ERROR        0x8000UL /* Bit1 error detect error mask */
#define LDD_CAN_ACK_ERROR         0x2000UL /* Acknowledge error detect error mask */
#define LDD_CAN_CRC_ERROR         0x1000UL /* Cyclic redundancy check error detect error mask */
#define LDD_CAN_FORM_ERROR        0x0800UL /* Message form error detect error mask */
#define LDD_CAN_STUFFING_ERROR    0x0400UL /* Bit stuff error detect error mask */

#define LDD_CAN_MESSAGE_ID_EXT    0x80000000UL /* Value specifying extended Mask, ID */

typedef enum {                         /* Type specifying the CAN frame type. */
  LDD_CAN_MB_RX_NOT_ACTIVE = 0x00U,
  LDD_CAN_MB_RX_FULL       = 0x02U,
  LDD_CAN_MB_RX_EMPTY      = 0x04U,
  LDD_CAN_MB_RX_OVERRUN    = 0x06U,
  LDD_CAN_MB_RX_BUSY       = 0x01U,
  LDD_CAN_MB_RX_RANSWER    = 0x0AU
} LDD_CAN_TRxBufferState;

typedef enum {                         /* Type specifying the CAN frame type. */
  LDD_CAN_DATA_FRAME,                  /* Data frame type received or transmitted */
  LDD_CAN_REMOTE_FRAME,                /* Remote frame type  */
  LDD_CAN_RESPONSE_FRAME               /* Response frame type - Tx buffer send data after receiving remote frame with the same ID */
} LDD_CAN_TFrameType;


typedef struct {
  uint32_t TxFrames;                   /* Transmitted frame counter */
  uint32_t TxWarnings;                 /* Transmission warning counter */
  uint32_t RxFrames;                   /* Received frame counter */
  uint32_t RxWarnings;                 /* Reception warning counter */
  uint32_t BusOffs;                    /* Bus off counter */
  uint32_t Wakeups;                    /* Wakeup counter */
  uint32_t Bit0Errors;                 /* Bit0 error counter */
  uint32_t Bit1Errors;                 /* Bit1 error counter */
  uint32_t AckErrors;                  /* ACK error counter */
  uint32_t CrcErrors;                  /* CRC error counter */
  uint32_t FormErrors;                 /* Message form error counter */
  uint32_t BitStuffErrors;             /* Bit stuff error counter */
  uint32_t Errors;                     /* Error counter */
} LDD_CAN_TStats;

typedef struct {
  LDD_CAN_TMessageID MessageID;        /* Message ID */
  LDD_CAN_TFrameType FrameType;        /* Type of the frame DATA/REMOTE */
  uint8_t *Data;                       /* Message data buffer */
  uint8_t  Length;                     /* Message length */
  uint16_t TimeStamp;                  /* Message time stamp */
  uint8_t  LocPriority;                /* Local Priority Tx Buffers */
} LDD_CAN_TFrame;

/*
** ===================================================================
** USB device types and constants
** ===================================================================
*/

/* Events' masks */
#define LDD_USB_ON_DEVICE_RESET            0x00000001u /* OnDeviceReset event mask */
#define LDD_USB_ON_DEVICE_SPEED_DETECT     0x00000002u /* OnDeviceSpeedDetect event mask */
#define LDD_USB_ON_DEVICE_SUSPEND          0x00000004u /* OnDeviceSuspend event mask */
#define LDD_USB_ON_DEVICE_RESUME           0x00000008u /* OnDeviceResume event mask */
#define LDD_USB_ON_DEVICE_SETUP_PACKET     0x00000010u /* OnDeviceSetupPacket event mask */
#define LDD_USB_ON_DEVICE_SOF              0x00000020u /* OnDeviceSof event mask */
#define LDD_USB_ON_DEVICE_1MS_TIMER        0x00000040u /* OnDevice1msTimer event mask */
#define LDD_USB_ON_DEVICE_1_MS_TIMER       0x00000040u /* OnDevice1msTimer event mask */
#define LDD_USB_ON_DEVICE_ERROR            0x00000080u /* OnDeviceError event mask */
#define LDD_USB_ON_HOST_DEVICE_DEATTACH    0x00000100u /* OnHostDeviceAttach event mask */
#define LDD_USB_ON_HOST_RESET_RECOVERY     0x00000200u /* OnHostResetRecovery event mask */
#define LDD_USB_ON_HOST_RESUME_RECOVERY    0x00000400u /* OnHostResumeRecovery event mask */
#define LDD_USB_ON_HOST_1MS_TIMER          0x00000800u /* 1 ms timer event mask */
#define LDD_USB_ON_HOST_1_MS_TIMER         0x00000800u /* 1 ms timer event mask */
#define LDD_USB_ON_HOST_ERROR              0x00001000u /* OnHostError event mask */
#define LDD_USB_ON_OTG_DEVICE              0x00002000u /* OnOtgDevice event mask */
#define LDD_USB_ON_OTG_HOST                0x00004000u /* OnOtgHost event mask */
#define LDD_USB_ON_OTG_STATE_CHANGE        0x00008000u /* OnOtgStageChange event mask */
#define LDD_USB_ON_SIGNAL_CHANGE           0x00010000u /* OnSignalChange event mask */

/* Data pins' masks */
#define LDD_USB_DP_PIN                     0x00000001u /* Data+ pin mask */
#define LDD_USB_DM_PIN                     0x00000002u /* Data- pin mask */

/* Pullup/pulldown pin masks */
#define LDD_USB_DP_PU_PIN                  0x00000004u /* Data+ pull-up pin mask */
#define LDD_USB_DM_PU_PIN                  0x00000008u /* Data- pull-up pin mask */
#define LDD_USB_DP_PD_PIN                  0x00000010u /* Data+ pull-down pin mask */
#define LDD_USB_DM_PD_PIN                  0x00000020u /* Data- pull-down pin mask */

/* VBUS pins' mask */
#define LDD_USB_DEVICE_VBUS_DETECT_PIN     0x00000040u /* VBUS detect pin mask */
#define LDD_USB_HOST_VBUS_ENABLE_PIN       0x00000080u /* VBUS enable pin mask */
#define LDD_USB_HOST_VBUS_OVERCURRENT_PIN  0x00000100u /* VBUS overcurrent pin mask */

/* OTG pins' masks */
#define LDD_USB_OTG_ID_PIN                 0x00000200u /* ID pin mask */
#define LDD_USB_OTG_VBUS_VALID_PIN         0x00000400u /* VBUS valid pin mask */
#define LDD_USB_OTG_SESSION_VALID_PIN      0x00000800u /* SESSION valid pin mask */
#define LDD_USB_OTG_B_SESSION_END_PIN      0x00004000u /* B SESSION end pin mask */
#define LDD_USB_OTG_VBUS_ENABLE_PIN        0x00008000u /* VBUS drive pin mask */
#define LDD_USB_OTG_VBUS_CHARGE_PIN        0x00010000u /* VBUS charge pin mask */
#define LDD_USB_OTG_VBUS_DISCHARGE_PIN     0x00020000u /* VBUS discharge pin mask */

/* ULPI pins' masks */
#define LDD_USB_ULPI_CLK_PIN               0x00080000u /* ULPI_CLK pin mask */
#define LDD_USB_ULPI_DIR_PIN               0x00100000u /* ULPI_DIR pin mask */
#define LDD_USB_ULPI_NXT_PIN               0x00200000u /* ULPI_NXT pin mask */
#define LDD_USB_ULPI_STP_PIN               0x00400000u /* ULPI_STOP pin mask */
#define LDD_USB_ULPI_DATA_0_PIN            0x00800000u /* ULPI_DATA_0 pin mask */
#define LDD_USB_ULPI_DATA_1_PIN            0x01000000u /* ULPI_DATA_1 pin mask */
#define LDD_USB_ULPI_DATA_2_PIN            0x02000000u /* ULPI_DATA_2 pin mask */
#define LDD_USB_ULPI_DATA_3_PIN            0x04000000u /* ULPI_DATA_3 pin mask */
#define LDD_USB_ULPI_DATA_4_PIN            0x08000000u /* ULPI_DATA_4 pin mask */
#define LDD_USB_ULPI_DATA_5_PIN            0x10000000u /* ULPI_DATA_5 pin mask */
#define LDD_USB_ULPI_DATA_6_PIN            0x20000000u /* ULPI_DATA_6 pin mask */
#define LDD_USB_ULPI_DATA_7_PIN            0x40000000u /* ULPI_DATA_7 pin mask */

/* Alternate clock pin*/
#define LDD_USB_CLKIN_PIN                  0x80000000u /* Alternate clock pin mask */
#define LDD_USB_ALT_CLK_PIN                0x80000000u /* Alternate clock pin mask */

/* DeviceSetUsbStatus()/DeviceGetUsbStatus methods Cmd/CmdStatusPtr param. values */
#define LDD_USB_CMD_GET_EP_STATUS              0x00u /* Get endpoint status command ID */
#define LDD_USB_CMD_SET_EP_HALT_FATURE         0x01u /* Set endpoint HALT feature command ID */
#define LDD_USB_CMD_CLR_EP_HALT_FATURE         0x02u /* Clear endpoint HALT feature command ID */

#define LDD_USB_CMD_EP_STATUS_HALT_MASK        0x01u /* Endpoint halt status mask */


/* DeviceSetUsbStatus()/DeviceGetUsbStatus methods Recipient param. values */
/* (see USB 2.0, chapter 9.3.4 wIndex description)*/
#define LDD_USB_ID_EP0_OUT                     0x00u /* EP0 OUT component ID */
#define LDD_USB_ID_EP0_IN                      0x80u /* EP0 IN component ID */
#define LDD_USB_ID_EP1_OUT                     0x01u /* EP1 OUT component ID */
#define LDD_USB_ID_EP1_IN                      0x81u /* EP1 IN component ID */
#define LDD_USB_ID_EP2_OUT                     0x02u /* EP2 OUT component ID */
#define LDD_USB_ID_EP2_IN                      0x82u /* EP2 IN component ID */
#define LDD_USB_ID_EP3_OUT                     0x03u /* EP3 OUT component ID */
#define LDD_USB_ID_EP3_IN                      0x83u /* EP3 IN component ID */
#define LDD_USB_ID_EP4_OUT                     0x04u /* EP4 OUT component ID */
#define LDD_USB_ID_EP4_IN                      0x84u /* EP4 IN component ID */
#define LDD_USB_ID_EP5_OUT                     0x05u /* EP5 OUT component ID */
#define LDD_USB_ID_EP5_IN                      0x85u /* EP5 IN component ID */
#define LDD_USB_ID_EP6_OUT                     0x06u /* EP6 OUT component ID */
#define LDD_USB_ID_EP6_IN                      0x86u /* EP6 IN component ID */
#define LDD_USB_ID_EP7_OUT                     0x07u /* EP7 OUT component ID */
#define LDD_USB_ID_EP7_IN                      0x87u /* EP7 IN component ID */
#define LDD_USB_ID_EP8_OUT                     0x08u /* EP8 OUT component ID */
#define LDD_USB_ID_EP8_IN                      0x88u /* EP8 IN component ID */
#define LDD_USB_ID_EP9_OUT                     0x09u /* EP9 OUT component ID */
#define LDD_USB_ID_EP9_IN                      0x89u /* EP9 IN component ID */
#define LDD_USB_ID_EP10_OUT                    0x0Au /* EP10 OUT component ID */
#define LDD_USB_ID_EP10_IN                     0x8Au /* EP10 IN component ID */
#define LDD_USB_ID_EP11_OUT                    0x0Bu /* EP11 OUT component ID */
#define LDD_USB_ID_EP11_IN                     0x8Bu /* EP11 IN component ID */
#define LDD_USB_ID_EP12_OUT                    0x0Cu /* EP12 OUT component ID */
#define LDD_USB_ID_EP12_IN                     0x8Cu /* EP12 IN component ID */
#define LDD_USB_ID_EP13_OUT                    0x0Du /* EP13 OUT component ID */
#define LDD_USB_ID_EP13_IN                     0x8Du /* EP13 IN component ID */
#define LDD_USB_ID_EP14_OUT                    0x0Eu /* EP14 OUT component ID */
#define LDD_USB_ID_EP14_IN                     0x8Eu /* EP14 IN component ID */
#define LDD_USB_ID_EP15_OUT                    0x0Fu /* EP15 OUT component ID */
#define LDD_USB_ID_EP15_IN                     0x8Fu /* EP15 IN component ID */
#define LDD_USB_ID_EP_MASK                     0x8Fu /* EP15 IN component ID */

/* Token PID */
#define LDD_USB_PID_OUT                        0x01u /* OUT */
#define LDD_USB_PID_IN                         0x09u /* IN */
#define LDD_USB_PID_SOF                        0x05u /* SOF */
#define LDD_USB_PID_SETUP                      0x0Du /* SETUP */
/* Data PID */
#define LDD_USB_PID_DATA0                      0x03u /* DATA0 */
#define LDD_USB_PID_DATA1                      0x0Bu /* DATA1 */
#define LDD_USB_PID_DATA2                      0x07u /* DATA2 */
#define LDD_USB_PID_MDATA                      0x0Fu /* MDATA */
/* Handshake PID */
#define LDD_USB_PID_ACK                        0x02u /* ACK */
#define LDD_USB_PID_NACK                       0x0Au /* NACK */
#define LDD_USB_PID_STALL                      0x0Eu /* STALL */
#define LDD_USB_PID_NYET                       0x06u /* NYET */
/* Special PID */
#define LDD_USB_PID_PRE                        0x0Cu /* PRE */
#define LDD_USB_PID_ERR                        0x0Cu /* ERR */
#define LDD_USB_PID_SPLIT                      0x08u /* SPLIT */
#define LDD_USB_PID_PING                       0x04u /* PING */

/* Data direction */
#define LDD_USB_DIR_OUT                        0x00u /* Recipient is Device */
#define LDD_USB_DIR_IN                         0x80u /* Recipient is Host */
#define LDD_USB_DIR_MASK                       0x80u /* Bit mask for data transfer direction */

/* Flags used in the TD.Head.Flags variable */

/* The following flag can be used to force zero-length termination(ZLT) of the transfer.
   Note: ZLT can be set for all transfer during the initialization of the endpoint.
*/
#define LDD_USB_DEVICE_TRANSFER_FLAG_ZLT       0x01u

/* If the TRANSFER_FLAG_EXT_PARAM is defined all variables of the TD are used
  and TD must NOT be freed until transfer is done or is cancelled
  (TransferState != LDD_USB_TRANSFER_PENDING)
  If not defined only the Head member of TD is used and TD can be freed after
  Send/Recv() method returns.
*/
#define LDD_USB_DEVICE_TRANSFER_FLAG_EXT_PARAM 0x02u


#define ERR_COMPONET_SPECIFIC 0x100u

/* Device mode USB specific error codes */
#define ERR_USB_DEVICE_DISABLED                (ERR_COMPONET_SPECIFIC + 0x00u) /* Device mode is disabled (by the user or by the clock configuration) */
#define ERR_USB_DEVICE_DISABLED_BY_OTG         (ERR_COMPONET_SPECIFIC + 0x01u) /* Device mode is disabled by the OTG driver */
#define ERR_USB_DEVICE_VBUS_OFF                (ERR_COMPONET_SPECIFIC + 0x02u) /* No VBUS is detected */
#define ERR_USB_DEVICE_VBUS_ON                 (ERR_COMPONET_SPECIFIC + 0x03u) /* VBUS is detected */
#define ERR_USB_DEVICE_ENABLED                 (ERR_COMPONET_SPECIFIC + 0x04u) /* Device is enabled */
#define ERR_USB_DEVICE_SUSPENDED               (ERR_COMPONET_SPECIFIC + 0x05u) /* Device is suspended */
#define ERR_USB_DEVICE_SUSPENDED_RESUME_READY  (ERR_COMPONET_SPECIFIC + 0x06u) /* Device is suspended and ready to generate resume signaling */
#define ERR_USB_DEVICE_RESUME_PENDING          (ERR_COMPONET_SPECIFIC + 0x07u) /* Device generates resume signaling */

/* Host mode USB specific error codes */
#define ERR_USB_HOST_DISABLED                  (ERR_COMPONET_SPECIFIC + 0x00u) /* Host mode is disabled (by the user or by the clock configuration) */
#define ERR_USB_HOST_DISABLED_BY_OTG           (ERR_COMPONET_SPECIFIC + 0x01u) /* Host mode is disabled by the OTG driver */
#define ERR_USB_HOST_PORT_POWERED_OFF          (ERR_COMPONET_SPECIFIC + 0x02u) /* Port is power off */
#define ERR_USB_HOST_PORT_DISCONNECTED         (ERR_COMPONET_SPECIFIC + 0x03u) /* Port is power on */
#define ERR_USB_HOST_PORT_DISABLED             (ERR_COMPONET_SPECIFIC + 0x04u) /* Device is connected to the port */
#define ERR_USB_HOST_PORT_RESETING             (ERR_COMPONET_SPECIFIC + 0x05u) /* Port generates reset signaling */
#define ERR_USB_HOST_PORT_RESET_RECOVERING     (ERR_COMPONET_SPECIFIC + 0x06u) /* Port waits 10ms for reset recovery */
#define ERR_USB_HOST_PORT_ENABLED              (ERR_COMPONET_SPECIFIC + 0x07u) /* PortDevice is connected, reset and ready to use */
#define ERR_USB_HOST_PORT_SUSPENDED            (ERR_COMPONET_SPECIFIC + 0x08u) /* Port is suspended */
#define ERR_USB_HOST_PORT_RESUME_READY         (ERR_COMPONET_SPECIFIC + 0x09u) /* Port can generate resume signaling */
#define ERR_USB_HOST_PORT_RESUMING             (ERR_COMPONET_SPECIFIC + 0x0Au) /* Port generates resume signaling */
#define ERR_USB_HOST_PORT_RESUME_RECOVERING    (ERR_COMPONET_SPECIFIC + 0x0Bu) /* Port generates resume signaling */

/* OTG mode USB specific error codes */
#define ERR_USB_OTG_DISABLED                   (ERR_COMPONET_SPECIFIC + 0x00u)
#define ERR_USB_OTG_ENABLED_PENDING            (ERR_COMPONET_SPECIFIC + 0x01u)
#define ERR_USB_OTG_A_IDLE                     (ERR_COMPONET_SPECIFIC + 0x02u)
#define ERR_USB_OTG_A_WAIT_VRISE               (ERR_COMPONET_SPECIFIC + 0x03u)
#define ERR_USB_OTG_A_WAIT_VFALL               (ERR_COMPONET_SPECIFIC + 0x05u)
#define ERR_USB_OTG_A_WAIT_BCON                (ERR_COMPONET_SPECIFIC + 0x07u)
#define ERR_USB_OTG_A_VBUS_ERROR               (ERR_COMPONET_SPECIFIC + 0x09u)
#define ERR_USB_OTG_A_SUSPEND                  (ERR_COMPONET_SPECIFIC + 0x0Au)

#define ERR_USB_OTG_B_IDLE                     (ERR_COMPONET_SPECIFIC + 0x0Cu)
#define ERR_USB_OTG_B_SRP_INIT                 (ERR_COMPONET_SPECIFIC + 0x0Eu)
#define ERR_USB_OTG_B_WAIT_ACON                (ERR_COMPONET_SPECIFIC + 0x0Fu)

#define ERR_USB_OTG_A_HOST                     (ERR_COMPONET_SPECIFIC + 0x10u)
#define ERR_USB_OTG_A_PERIPHERAL               (ERR_COMPONET_SPECIFIC + 0x11u)
#define ERR_USB_OTG_B_HOST                     (ERR_COMPONET_SPECIFIC + 0x12u)
#define ERR_USB_OTG_B_PERIPHERAL               (ERR_COMPONET_SPECIFIC + 0x13u)

/* Device speed symbolic names */
typedef enum {
  LDD_USB_LOW_SPEED     = 0x00u,
  LDD_USB_FULL_SPEED    = 0x01u,
  LDD_USB_HIGH_SPEED    = 0x02u,
  LDD_USB_SPEED_UNKNOWN = 0xFFu
} LDD_USB_TBusSpeed;

/* Trnsfer type symbolic names */
typedef enum {
  LDD_USB_CONTROL      = 0x00u,
  LDD_USB_ISOCHRONOUS  = 0x01u,
  LDD_USB_BULK         = 0x02u,
  LDD_USB_INTERRUPT    = 0x03u
} LDD_USB_TTransferType;

/* Transfer state symbolic names */
typedef enum {
  LDD_USB_TRANSFER_NONE               = 0x00u,
  LDD_USB_TRANSFER_DONE               = 0x01u,
  LDD_USB_TRANSFER_ERROR_CANCELLED    = 0x02u,
  LDD_USB_TRANSFER_ERROR_STALLED      = 0x03u,
  LDD_USB_TRANSFER_ERROR_BUS_TIMEOUT  = 0x04u,
  LDD_USB_TRANSFER_ERROR_DATA         = 0x05u,
  LDD_USB_TRANSFER_ERROR_PID          = 0x06u,
  LDD_USB_TRANSFER_ERROR_EOF          = 0x07u,
  LDD_USB_TRANSFER_ERROR_CRC16        = 0x08u,
  LDD_USB_TRANSFER_ERROR_DFN8         = 0x09u,
  LDD_USB_TRANSFER_ERROR_DMA          = 0x0Au,
  LDD_USB_TRANSFER_ERROR_BTS          = 0x0Bu,
  LDD_USB_TRANSFER_ERROR              = 0x0Fu,
  LDD_USB_TRANSFER_QUEUED             = 0x10u,
  LDD_USB_TRANSFER_PENDING            = 0x30u
} LDD_USB_TTransferState;

/* Setup data packet structure, uint16_t items must be in little-endian format */
typedef struct LDD_USB_TSDP_Struct {
  uint8_t   bmRequestType; /* Characteristics of request */
  uint8_t   bRequest;      /* Request code */
  uint16_t  wValue;        /* Word-sized field that varies according to request */
  uint16_t  wIndex;        /* Word-sized field that varies according to request, typically used to pass an index or offset */
  uint16_t  wLength;       /* Number of bytes to transfer if there is a data stage */
} LDD_USB_TSDP;

/* Endpoint descriptor structure, uint16_t items must be in little-endian format */
typedef struct LDD_USB_TEpDescriptor_Struct {
  uint8_t   bLength;          /* Size of this descriptor in bytes */
  uint8_t   bDescriptorType;  /* Descriptor type */
  uint8_t   bEndpointAddress; /* Endpoint address */
  uint8_t   bmAttributes;     /* Endpoint attributes */
  uint16_t  wMaxPacketSize;   /* Maximum packet size the endpoint is capable of sending or receiving */
  uint8_t   bInterval;        /* Interval for polling endpoint for data transfers */
} LDD_USB_TEpDescriptor;

/* Standard device descriptor structure, uint16_t items must be in little-endian format  */
typedef struct LDD_USB_TDevDescriptor_Struct {
  uint8_t   bLength;            /* Size of this descriptor in bytes */
  uint8_t   bDescriptorType;    /* Descriptor type */
  uint16_t  bcdUSB;             /* USB specification release number in binary-coded Decimal */
  uint8_t   bDeviceClass;       /* Class code (assigned by the USB-IF) */
  uint8_t   bDeviceSubClass;    /* Subclass code (assigned by the USB-IF) */
  uint8_t   bDeviceProtocol;    /* Protocol code (assigned by the USB-IF) */
  uint8_t   bMaxPacketSize0;    /* Maximum packet size for endpoint zero */
  uint16_t  idVendor;           /* Vendor ID (assigned by the USB-IF) */
  uint16_t  idProduct;          /* Product ID (assigned by the manufacturer) */
  uint16_t  bcdDevice;          /* Device release number in binary-coded decimal */
  uint8_t   iManufacturer;      /* Index of string descriptor describing manufacturer */
  uint8_t   iProduct;           /* Index of string descriptor describing product */
  uint8_t   iSerialNumber;      /* Index of string descriptor describing the devices serial number */
  uint8_t   bNumConfigurations; /* Number of possible configurations */
} LDD_USB_TDevDescriptor;


/* Device transfer descriptor structure forward declaration */
struct LDD_USB_Device_TTD_Struct;

/* Device transfer done callback prototype */
typedef void (LDD_USB_Device_TTransferDoneCalback)(LDD_TDeviceData *DevDataPtr, struct LDD_USB_Device_TTD_Struct *TrParamPtr);

/* Device transfer descriptor structure - head part */
typedef struct LDD_USB_Device_TTD_Head_Struct {
  uint8_t    EpNum;      /* Endpoint number */
  LDD_TData *BufferPtr;  /* Buffer address */
  uint16_t   BufferSize; /* Buffer size */
  uint8_t    Flags;      /* Transfer flags - see constants definition */
} LDD_USB_Device_TTD_Head;

/* Device transfer descriptor structure */
typedef struct LDD_USB_Device_TTD_Struct {
  /* Requierd variables */
  LDD_USB_Device_TTD_Head              Head;                /* Td head data, not changed by the driver */
  /* Optional items - the following items are used */
  /* only if Head.Flags & LDD_USB_DEVICE_TRANSFER_FLAG_EXT_PARAM != 0 */
  LDD_USB_TTransferState               TransferState;       /* Transfer state. Set by the driver */
  uint16_t                             TransmittedDataSize; /* Transmitted data size. Set by the driver */
  LDD_USB_Device_TTransferDoneCalback *CallbackFnPtr;       /* Address of the callback function. Must be set by the caller */
  uint8_t                             *ParamPtr;            /* User parameter. Not changed by the driver */
} LDD_USB_Device_TTD;

/* USB device states symbolic names */
typedef enum {
  LDD_USB_DEVICE_DISABLED                = ERR_USB_DEVICE_DISABLED,               /* Device mode is disabled (by the user or by the clock configuration) */
  LDD_USB_DEVICE_DISABLED_BY_OTG         = ERR_USB_DEVICE_DISABLED_BY_OTG,        /* Device mode is disabled by the OTG driver */
  LDD_USB_DEVICE_VBUS_OFF                = ERR_USB_DEVICE_VBUS_OFF,               /* No VBUS is detected */
  LDD_USB_DEVICE_VBUS_ON                 = ERR_USB_DEVICE_VBUS_ON,                /* VBUS is detected */
  LDD_USB_DEVICE_ENABLED                 = ERR_USB_DEVICE_ENABLED,                /* Device is enabled - reset by the host */
  LDD_USB_DEVICE_SUSPENDED               = ERR_USB_DEVICE_SUSPENDED,              /* Device is suspended - Bus is idle more then 3 ms */
  LDD_USB_DEVICE_SUSPENDED_RESUME_READY  = ERR_USB_DEVICE_SUSPENDED_RESUME_READY, /* Device can generate resume signaling - Bus is idle more then 5 ms. */
  LDD_USB_DEVICE_RESUME_PENDING          = ERR_USB_DEVICE_RESUME_PENDING          /* Device generates resume signaling */
} LDD_USB_Device_TState;

/* USB host mode states symbolic names */
typedef enum {
  LDD_USB_HOST_DISABLED                = ERR_USB_HOST_DISABLED,              /* Host mode is disabled (by the user or by the clock configuration) */
  LDD_USB_HOST_DISABLED_BY_OTG         = ERR_USB_HOST_DISABLED_BY_OTG,       /* Host mode is disabled by the OTG driver */
  LDD_USB_HOST_PORT_POWERED_OFF        = ERR_USB_HOST_PORT_POWERED_OFF,      /* Port is powered-off */
  LDD_USB_HOST_PORT_DISCONNECTED       = ERR_USB_HOST_PORT_DISCONNECTED,     /* No device is connected */
  LDD_USB_HOST_PORT_DISABLED           = ERR_USB_HOST_PORT_DISABLED,         /* Device is connected to the port */
  LDD_USB_HOST_PORT_RESETING           = ERR_USB_HOST_PORT_RESETING,         /* Port generates reset signaling */
  LDD_USB_HOST_PORT_RESET_RECOVERING   = ERR_USB_HOST_PORT_RESET_RECOVERING, /* Port waits 10 ms for reset recovery */
  LDD_USB_HOST_PORT_ENABLED            = ERR_USB_HOST_PORT_ENABLED,          /* Device is connected, reset and ready to use */
  LDD_USB_HOST_PORT_SUSPENDED          = ERR_USB_HOST_PORT_SUSPENDED,        /* Port is suspended */
  LDD_USB_HOST_PORT_RESUME_READY       = ERR_USB_HOST_PORT_RESUME_READY,     /* Port is ready to generate resume signaling */
  LDD_USB_HOST_PORT_RESUMING           = ERR_USB_HOST_PORT_RESUMING,         /* Port generates resume signaling */
  LDD_USB_HOST_PORT_RESUME_RECOVERING  = ERR_USB_HOST_PORT_RESUME_RECOVERING /* Port waits 10 ms for resume recovery */
} LDD_USB_Host_TState;

/* USB otg mode states symbolic names */
typedef enum {
  LDD_USB_OTG_DISABLED                   = ERR_USB_OTG_DISABLED,
  LDD_USB_OTG_ENABLED                    = ERR_USB_OTG_ENABLED_PENDING,
  LDD_USB_OTG_A_IDLE                     = ERR_USB_OTG_A_IDLE,
  LDD_USB_OTG_A_WAIT_VRISE               = ERR_USB_OTG_A_WAIT_VRISE,
  LDD_USB_OTG_A_WAIT_VFALL               = ERR_USB_OTG_A_WAIT_VFALL,
  LDD_USB_OTG_A_WAIT_BCON                = ERR_USB_OTG_A_WAIT_BCON,
  LDD_USB_OTG_A_VBUS_ERROR               = ERR_USB_OTG_A_VBUS_ERROR,
  LDD_USB_OTG_A_SUSPEND                  = ERR_USB_OTG_A_SUSPEND,
  LDD_USB_OTG_B_IDLE                     = ERR_USB_OTG_B_IDLE,
  LDD_USB_OTG_B_SRP_INIT                 = ERR_USB_OTG_B_SRP_INIT,
  LDD_USB_OTG_B_WAIT_ACON                = ERR_USB_OTG_B_WAIT_ACON,
  LDD_USB_OTG_A_HOST                     = ERR_USB_OTG_A_HOST,
  LDD_USB_OTG_A_PERIPHERAL               = ERR_USB_OTG_A_PERIPHERAL,
  LDD_USB_OTG_B_HOST                     = ERR_USB_OTG_B_HOST,
  LDD_USB_OTG_B_PERIPHERAL               = ERR_USB_OTG_B_PERIPHERAL
} LDD_USB_Otg_TState;

/* USB Otg commands symbolic names */
typedef enum {
  LDD_USB_OTG_CMD_SET_A_BUS_REQUEST,          /* A-device application wants to use the bus */
  LDD_USB_OTG_CMD_CLR_A_BUS_REQUEST,          /* A-device application doesn't want to use the bus */
  LDD_USB_OTG_CMD_SET_B_BUS_REQUEST,          /* B-device application wants to use the bus */
  LDD_USB_OTG_CMD_CLR_B_BUS_REQUEST,          /* B-device application doesn't want to use the bus */
  LDD_USB_OTG_CMD_SET_A_BUS_DROP,             /* A-device application needs to power down the bus */
  LDD_USB_OTG_CMD_CLR_A_BUS_DROP,             /* A-device application doesn't need to power down the bus */
  LDD_USB_OTG_CMD_SET_A_SUSPEND_REQUEST,      /* A-device application wants to suspend the bus */
  LDD_USB_OTG_CMD_CLR_A_SUSPEND_REQUEST,      /* A-device application doesn't want to suspend the bus */
  LDD_USB_OTG_CMD_SET_A_SET_B_HNP_EN_REQUEST, /* A-device sets HNP enabled feature on B-device */
  LDD_USB_OTG_CMD_CLR_A_SET_B_HNP_EN_REQUEST, /* A-device clears HNP enabled feature on B-device */
  LDD_USB_OTG_CMD_SET_B_HNP_EN_REQUEST,       /* Enable B-device HNP */
  LDD_USB_OTG_CMD_CLR_B_HNP_EN_REQUEST        /* Disable B-device HNP */
} LDD_USB_Otg_TCmd;

/* USB host port control commands symbolic names */
typedef enum {
  LDD_USB_HOST_PORT_CMD_POWER_ON,  /* Power-on the bus */
  LDD_USB_HOST_PORT_CMD_POWER_OFF, /* Power-off the bus */
  LDD_USB_HOST_PORT_CMD_RESET,     /* Perform the bus reset signaling and call event after the reset recovery interval elapse */
  LDD_USB_HOST_PORT_CMD_RESUME,    /* Perform the bus resume signaling and call event after the resume recovery interval elapse */
  LDD_USB_HOST_PORT_CMD_SUSPEND,   /* Suspend the bus and transceiver */
  LDD_USB_HOST_PORT_CMD_DISABLE    /* Disable the port */
} LDD_USB_Host_TPortControlCmd;

/* USB host handle prototypes */
typedef void LDD_USB_Host_TPipeHandle;     /* Pipe handle prototype */
typedef void LDD_USB_Host_TTransferHandle; /* Transfer handle prototype */

/* USB host pipe descriptor structure */
typedef struct LDD_USB_Host_TPipeDescr_Struct {
  uint8_t                DevAddress;    /* Device address */
  LDD_USB_TBusSpeed      DevSpeed;      /* Device speed */
  uint8_t                EpNumber;      /* EP number */
  uint8_t                EpDir;         /* EP direction */
  LDD_USB_TTransferType  TransferType;  /* EP Transfer type */
  uint16_t               MaxPacketSize; /* EP max. packet size */
  uint8_t                TrPerUFrame;   /* Transaction pre microframe */
  uint32_t               Interval;      /* Interval for polling endpoint for data transfers */
  uint32_t               NAKCount;      /* NAK count */
  uint8_t                Flags;         /* 1 = ZLT */
} LDD_USB_Host_TPipeDescr;

/* USB host transfer done callback prototype */
typedef void (LDD_USB_Host_TTransferDoneCalback)(
  LDD_TDeviceData        *DevDataPtr, /* User value passed as parameter of the Init() method */
  LDD_TData              *BufferPtr,  /* Buffer address */
  uint16_t                BufferSize, /* Transferred data size */
  uint8_t                *ParamPtr,   /* User value passed in Send()/Recv() method */
  LDD_USB_TTransferState  Status      /* Transfer status */
);

/* USB host transfer descriptor structure */
typedef struct LDD_USB_Host_TTD_Struct {
  LDD_TData                         *BufferPtr;     /* Buffer address */
  uint16_t                           BufferSize;    /* Buffer size */
  uint8_t                            Flags;         /* Transfer flags */
  LDD_USB_Host_TTransferDoneCalback *CallbackFnPtr; /* Address of the callback function. Must be set by the caller */
  uint8_t                           *ParamPtr;      /* User parameter. Not changed by the driver */
  LDD_USB_TSDP                      *SDPPrt;        /* Setup data buffer pointer */
} LDD_USB_Host_TTD;

/* Following USB constants and types are for test purpose only */

/* Request types */
#define LDD_USB_REQ_TYPE_STANDARD              0x00u /* Standard request */
#define LDD_USB_REQ_TYPE_CLASS                 0x20u /* Class request */
#define LDD_USB_REQ_TYPE_VENDOR                0x40u /* Vendor request */
#define LDD_USB_REQ_TYPE_MASK                  0x60u /* Bit mask for request type (bmRequestType) */

/* Request recepient */
#define LDD_USB_REQ_RECP_DEVICE                0x00u /* Recipient = Device */
#define LDD_USB_REQ_RECP_INTERFACE             0x01u /* Recipient = Interface */
#define LDD_USB_REQ_RECP_ENDPOINT              0x02u /* Recipient = Endpoint */
#define LDD_USB_REQ_RECP_OTHER                 0x03u /* Recipient = Other */
#define LDD_USB_REQ_RECP_MASK                  0x03u /* Bit mask for recipient */

/* Standard request codes (bRequest) */
#define LDD_USB_REQ_GET_STATUS                 0x00u /* GET_STATUS request code */
#define LDD_USB_REQ_CLEAR_FEATURE              0x01u /* CLEAR_FEATURE request code */
#define LDD_USB_REQ_SET_FEATURE                0x03u /* SET_FEATURE request code */
#define LDD_USB_REQ_GET_STATE                  0x04u /* GET_STATE request code (for Hub Class only)*/
#define LDD_USB_REQ_SET_ADDRESS                0x05u /* SET_ADDRESS request code */
#define LDD_USB_REQ_GET_DESCRIPTOR             0x06u /* GET_DESCRIPTOR request code */
#define LDD_USB_REQ_SET_DESCRIPTOR             0x07u /* SET_DESCRIPTOR request code, this request is not supported */
#define LDD_USB_REQ_GET_CONFIGURATION          0x08u /* GET_CONFIGURATION request code */
#define LDD_USB_REQ_SET_CONFIGURATION          0x09u /* SET_CONFIGURATION request code */
#define LDD_USB_REQ_GET_INTERFACE              0x0Au /* GET_INTERFACE request code */
#define LDD_USB_REQ_SET_INTERFACE              0x0Bu /* SET_INTERFACE request code */
#define LDD_USB_REQ_SYNCH_FRAME                0x0Cu /* SYNCH_FRAME request code */

/* Standard request words for device (bmRequestType | bRequest) */
#define LDD_USB_STD_REQ_GET_DEV_STATUS         0x0080u /* GET_DEVICE_STATUS bmRequestType and bRequest word */
#define LDD_USB_STD_REQ_CLR_DEV_FEATURE        0x0100u /* CLEAR_DEVICE_FEATURE bmRequestType and bRequest word */
#define LDD_USB_STD_REQ_SET_DEV_FEATURE        0x0300u /* SET_DEVICE_FEATURE bmRequestType and bRequest word */
#define LDD_USB_STD_REQ_SET_ADDRESS            0x0500u /* SET_DEVICE_ADDRESS bmRequestType and bRequest word */
#define LDD_USB_STD_REQ_GET_DESCRIPTOR         0x0680u /* GET_DESCRIPTOR bmRequestType and bRequest word */
#define LDD_USB_STD_REQ_SET_DESCRIPTOR         0x0700u /* SET_DESCRIPTOR bmRequestType and bRequest word */
#define LDD_USB_STD_REQ_GET_CONFIGURATION      0x0880u /* GET_DEVICE_CONFIGURATION bmRequestType and bRequest word */
#define LDD_USB_STD_REQ_SET_CONFIGURATION      0x0900u /* SET_DEVICE_CONFIGURATION bmRequestType and bRequest word */

/* Standard request words for interface (bmRequestType | bRequest) */
#define LDD_USB_STD_REQ_GET_INT_STATUS         0x0081u /* GET_INTERFACE_STATUS bmRequestType and bRequest word */
#define LDD_USB_STD_REQ_CLR_INT_FEATURE        0x0101u /* CLEAR_INTERFACE_FEATURE bmRequestType and bRequest word */
#define LDD_USB_STD_REQ_SET_INT_FEATURE        0x0301u /* SET_INTERFACE_FEATURE bmRequestType and bRequest word */
#define LDD_USB_STD_REQ_GET_INTERFACE          0x0A81u /* GET_DEVICE_INTERFACE bmRequestType and bRequest word */
#define LDD_USB_STD_REQ_SET_INTERFACE          0x0B01u /* SET_DEVICE_INTERFACE bmRequestType and bRequest word */

/* Standard request words for endpoint (bmRequestType | bRequest) */
#define LDD_USB_STD_REQ_GET_EP_STATUS          0x0082u /* GET_ENDPOINT_STATUS bmRequestType and bRequest word */
#define LDD_USB_STD_REQ_CLR_EP_FEATURE         0x0102u /* CLEAR_ENDPOINT_FEATURE bmRequestType and bRequest word */
#define LDD_USB_STD_REQ_SET_EP_FEATURE         0x0302u /* ENDPOINT_ bmRequestType and bRequest word */
#define LDD_USB_STD_REQ_SYNCH_FRAME            0x0C12u /* SYNCH_DEVICE_FRAME bmRequestType and bRequest code */

#define LDD_USB_STATUS_DEVICE_SELF_POWERED_MASK  0x01u
#define LDD_USB_STATUS_DEVICE_REMOTE_WAKEUP_MASK 0x02u

/* Standard descriptors */
#define LDD_USB_DT_DEVICE                      0x01u /* Device descriptor */
#define LDD_USB_DT_CONFIGURATION               0x02u /* Configuration descriptor */
#define LDD_USB_DT_STRING                      0x03u /* String descriptor */
#define LDD_USB_DT_INTERFACE                   0x04u /* Interface descriptor */
#define LDD_USB_DT_ENDPOINT                    0x05u /* Endpoint descriptor */
#define LDD_USB_DT_DEVICE_QUALIFIER            0x06u /* Device qualifier descriptor */
#define LDD_USB_DT_OTHER_SPEED_CONFIGURATION   0x07u /* Other speed configuration descriptor */
#define LDD_USB_DT_INTERFACE_POWER             0x08u /* Interface-level power management descriptor */
#define LDD_USB_DT_OTG                         0x09u /* OTG descriptor */
#define LDD_USB_DT_DEBUG                       0x0Au /* Debug descriptor */
#define LDD_USB_DT_INTERFACE_ASSOCIATION       0x0Bu /* Interface association descriptor */

/* Standard feature selectors */
#define LDD_USB_FEATURE_EP_HALT                0x00u /* Endpoint HALT feature selector */
#define LDD_USB_FEATURE_DEV_REMOTE_WAKEUP      0x01u /* Remote Wake-up feature selector */
#define LDD_USB_FEATURE_DEV_TEST_MODE          0x02u /* Test mode feature selector */

/* Get decriptor request structure */
typedef struct LDD_USB_TGetDecriptorRequest_Struct {
  uint8_t            bmRequestType;
  uint8_t            bRequest;
  uint8_t            bDescriptorIndex;
  uint8_t            bDescriptorType;
  uint16_t           wLanguageID;
  uint16_t           wLength;
} LDD_USB_TGetDecriptorRequest;

/* Get endpoint status request structure */
typedef struct LDD_USB_TEndpointStatusRequest_Struct {
  uint8_t            bmRequestType;
  uint8_t            bRequest;
  uint16_t           wValue;
  uint8_t            bEndpoint;
  uint8_t            bIndexHigh;
  uint16_t           wLength;
} LDD_USB_TEndpointStatusRequest;

/* Clear/Set endpoint feature request structure */
typedef struct LDD_USB_TEndpointFeatureRequest_Struct {
  uint8_t            bmRequestType;
  uint8_t            bRequest;
  uint16_t           wFeatureSelector;
  uint8_t            bEndpoint;
  uint8_t            bIndexHigh;
  uint16_t           wLength;
} LDD_USB_TEndpointFeatureRequest;

/* Clear/Set interface request structure */
typedef struct LDD_USB_TInterfaceFeatureRequest_Struct {
  uint8_t            bmRequestType;
  uint8_t            bRequest;
  uint16_t           wFeatureSelector;
  uint16_t           wInterface;
  uint16_t           wLength;
} LDD_USB_TInterfaceFeatureRequest;

/* Clear/Set device request structure */
typedef struct LDD_USB_TDeviceFeatureRequest_Struct {
  uint8_t            bmRequestType;
  uint8_t            bRequest;
  uint16_t           wFeatureSelector;
  uint16_t           wIndex;
  uint16_t           wLength;
} LDD_USB_TDeviceFeatureRequest;

/* Get interface request structure */
typedef struct LDD_USB_TGetInterfaceRequest_Struct {
  uint8_t            bmRequestType;
  uint8_t            bRequest;
  uint16_t           wWalue;
  uint16_t           wInterface;
  uint16_t           wLength;
} LDD_USB_TGetInterfaceRequest;

/* Set interface request structure */
typedef struct LDD_USB_TSetInterfaceRequest_Struct {
  uint8_t            bmRequestType;
  uint8_t            bRequest;
  uint16_t           wAltSet;
  uint16_t           wInterface;
  uint16_t           wLength;
} LDD_USB_TSetInterfaceRequest;

/* Set address request structure */
typedef struct LDD_USB_TSetAddressRequest_Struct {
  uint8_t            bmRequestType;
  uint8_t            bRequest;
  uint8_t            DeviceAddress;
  uint8_t            bValueHigh;
  uint16_t           wIndex;
  uint16_t           wLength;
} LDD_USB_TSetAddressRequest;

/* Set address request structure */
typedef struct LDD_USB_TSetConfigRequest_Struct {
  uint8_t            bmRequestType;
  uint8_t            bRequest;
  uint8_t            bValueHigh;
  uint8_t            ConfigNumber;
  uint16_t           wIndex;
  uint16_t           wLength;
} LDD_USB_TSetConfigRequest;

/*
** ===================================================================
** DAC device types and constants
** ===================================================================
*/
#define LDD_DAC_OUTPUT_PIN_0          0x01u /* DAC output pin 0 mask */

#define LDD_DAC_ON_BUFFER_END         0x01U /* OnBufferEnd event mask */
#define LDD_DAC_ON_BUFFER_START       0x02U /* OnBufferStart event mask */
#define LDD_DAC_ON_BUFFER_WATERMARK   0x04U /* OnBufferWatermark event mask */
#define LDD_DAC_ON_COMPLETE           LDD_DMA_ON_COMPLETE /* OnComplete event mask */
#define LDD_DAC_ON_ERROR              LDD_DMA_ON_ERROR /* OnError event mask */

typedef enum {                         /* Type specifying the DAC buffer work mode */
  LDD_DAC_BUFFER_NORMAL_MODE          = 0x00U, /* Normal (cyclic) mode */
  LDD_DAC_BUFFER_SWING_MODE           = 0x01U, /* Swing mode  */
  LDD_DAC_BUFFER_SCAN_MODE            = 0x02U /* One-time scan mode */
} LDD_DAC_TBufferMode;

typedef enum {                         /* Type specifying the DAC buffer watermark levels */
  LDD_DAC_BUFFER_WATERMARK_L1         = 0x00U,
  LDD_DAC_BUFFER_WATERMARK_L2         = 0x01U,
  LDD_DAC_BUFFER_WATERMARK_L3         = 0x02U,
  LDD_DAC_BUFFER_WATERMARK_L4         = 0x03U
} LDD_DAC_TBufferWatermark;

typedef void* LDD_DAC_TDataPtr;        /* Type specifying the pointer to the DAC data variable */
typedef uint32_t LDD_DAC_TData;        /* The DAC data variable type */

/*
** ===================================================================
** FLASH device types and constants
** ===================================================================
*/
#define LDD_FLASH_ON_OPERATION_COMPLETE 0x02u           /* OnOperationComplete event mask */
#define LDD_FLASH_ON_ERROR              0x04u           /* OnError event mask */

#define LDD_FLASH_READ_COLLISION_ERROR     0x40u       /* Read collision error flag's mask */
#define LDD_FLASH_ACCESS_ERROR             0x20u       /* Access error flag's mask */
#define LDD_FLASH_PROTECTION_VIOLATION     0x10u       /* Protection violation error flag's mask */
#define LDD_FLASH_ERASE_VERIFICATION_ERROR 0x08u        /* Erase verification error flag's mask */
#define LDD_FLASH_MULTIPLE_WRITE_ERROR     0x04u        /* Multiple write to one flash memory location error flag's mask */

typedef enum {                                          /* Type specifying HW commands for a flash device */
  LDD_FLASH_READ_1S_BLOCK             = 0x00u,          /* Checks if an entire program flash or data flash logical block has been erased to the specified margin level */
  LDD_FLASH_READ_1S_SECTION           = 0x01u,          /* Checks if a section of program flash or data flash memory is erased to the specified read margin level */
  LDD_FLASH_WRITE_BYTE                = 0x04u,          /* Program byte */
  LDD_FLASH_WRITE_WORD                = 0x05u,          /* Program word */
  LDD_FLASH_WRITE_LONG_WORD           = 0x06u,          /* Program long word */
  LDD_FLASH_WRITE_PHRASE              = 0x07u,          /* Program phrase */
  LDD_FLASH_ERASE_FLASH_BLOCK         = 0x08u,          /* Erase flash memory block */
  LDD_FLASH_ERASE_SECTOR              = 0x09u,          /* Erase sector */
  LDD_FLASH_ERASE_ALL_FLASH_BLOCKS    = 0x44u          /* Erase all flash memory blocks */
} LDD_FLASH_TCommand;

typedef enum {                                          /* Type specifying possible FLASH component operation types */
  LDD_FLASH_NO_OPERATION,                               /* No operation - initial state */
  LDD_FLASH_READ,                                       /* Read operation */
  LDD_FLASH_WRITE,                                      /* Write operation */
  LDD_FLASH_ERASE,                                      /* Erase operation */
  LDD_FLASH_ERASE_BLOCK,                                /* Erase block operation */
  LDD_FLASH_VERIFY_ERASED_BLOCK                         /* Verify erased block operation */
} LDD_FLASH_TOperationType;

typedef enum {                                          /* Type specifying possible FLASH component operation states */
  LDD_FLASH_IDLE,                                       /* No operation in progress */
  LDD_FLASH_STOP,                                       /* The operation has been stopped */
  LDD_FLASH_STOP_REQ,                                   /* The operation is in the STOP request mode */
  LDD_FLASH_START,                                      /* Start of the operation, no operation steps have been done yet */
  LDD_FLASH_RUNNING,                                    /* Operation is in progress */
  LDD_FLASH_FAILED                                      /* Operation has failed */
} LDD_FLASH_TOperationStatus;

typedef uint8_t LDD_FLASH_TErrorFlags;                  /* Type specifying FLASH component's error flags bit field */

typedef uint32_t LDD_FLASH_TAddress;                    /* Type specifying the Address parameter used by the FLASH component's methods */

typedef uint32_t LDD_FLASH_TDataSize;                   /* Type specifying the Size parameter used by the FLASH component's methods */

typedef uint16_t LDD_FLASH_TErasableUnitSize;           /* Type specifying the Size output parameter of the GetErasableUnitSize method (pointer to a variable of this type is passed to the method) */

typedef struct {                                        /* Type specifying the FLASH component's rrror status information */
  LDD_FLASH_TOperationType CurrentOperation;            /* Current operation */
  LDD_FLASH_TCommand       CurrentCommand;              /* Last flash controller command */
  LDD_FLASH_TErrorFlags    CurrentErrorFlags;           /* Bitfield with error flags. See FLASH2.h for details */
  LDD_FLASH_TAddress       CurrentAddress;              /* Address of the flash memory location the error status is related to */
  LDD_TData               *CurrentDataPtr;              /* Pointer to current input data the error status is related to */
  LDD_FLASH_TDataSize      CurrentDataSize;             /* Size of the current input data to be programmed or erased in bytes */
} LDD_FLASH_TErrorStatus;

/*
** ===================================================================
** HSCMP device types and constants
** ===================================================================
*/

#define LDD_ANALOGCOMP_ON_COMPARE 0x01u /* OnCompare event mask */

/* Positive input pin masks */
#define LDD_ANALOGCOMP_POSITIVE_INPUT_0_MASK 0x01U
#define LDD_ANALOGCOMP_POSITIVE_INPUT_1_MASK 0x02U
#define LDD_ANALOGCOMP_POSITIVE_INPUT_2_MASK 0x04U
#define LDD_ANALOGCOMP_POSITIVE_INPUT_3_MASK 0x08U
#define LDD_ANALOGCOMP_POSITIVE_INPUT_4_MASK 0x10U
#define LDD_ANALOGCOMP_POSITIVE_INPUT_5_MASK 0x20U
#define LDD_ANALOGCOMP_POSITIVE_INPUT_6_MASK 0x40U
#define LDD_ANALOGCOMP_POSITIVE_INPUT_7_MASK 0x80U

/* Negative input pin masks */
#define LDD_ANALOGCOMP_NEGATIVE_INPUT_0_MASK 0x0100U
#define LDD_ANALOGCOMP_NEGATIVE_INPUT_1_MASK 0x0200U
#define LDD_ANALOGCOMP_NEGATIVE_INPUT_2_MASK 0x0400U
#define LDD_ANALOGCOMP_NEGATIVE_INPUT_3_MASK 0x0800U
#define LDD_ANALOGCOMP_NEGATIVE_INPUT_4_MASK 0x1000U
#define LDD_ANALOGCOMP_NEGATIVE_INPUT_5_MASK 0x2000U
#define LDD_ANALOGCOMP_NEGATIVE_INPUT_6_MASK 0x4000U
#define LDD_ANALOGCOMP_NEGATIVE_INPUT_7_MASK 0x8000U

/* Output pin masks */
#define LDD_ANALOGCOMP_OUTPUT_PIN_MASK 0x00010000U

/* Window Sample pin masks */
#define LDD_ANALOGCOMP_WINDOWSAMPLE_PIN_MASK 0x00020000UL

typedef enum {
  LDD_ANALOGCOMP_INPUT_0 = 0x00U,
  LDD_ANALOGCOMP_INPUT_1 = 0x01U,
  LDD_ANALOGCOMP_INPUT_2 = 0x02U,
  LDD_ANALOGCOMP_INPUT_3 = 0x03U,
  LDD_ANALOGCOMP_INPUT_4 = 0x04U,
  LDD_ANALOGCOMP_INPUT_5 = 0x05U,
  LDD_ANALOGCOMP_INPUT_6 = 0x06U,
  LDD_ANALOGCOMP_INPUT_7 = 0x07U,
  LDD_ANALOGCOMP_INPUT_DISABLED = 0x08U
} LDD_AnalogComp_TComparatorInput;     /* Type specifying comparator input number */

typedef enum {
  LDD_ANALOGCOMP_NO_EDGE = 0x00U,
  LDD_ANALOGCOMP_FALLING_EDGE = 0x02U,
  LDD_ANALOGCOMP_RISING_EDGE = 0x04U,
  LDD_ANALOGCOMP_BOTH_EDGES = 0x06U
} LDD_AnalogComp_TCompareStatus;       /* Type specifying current comparator output status */

typedef enum {
  LDD_ANALOGCOMP_RISING_EDGE_MODE = 0x10U,
  LDD_ANALOGCOMP_FALLING_EDGE_MODE = 0x08U,
  LDD_ANALOGCOMP_BOTH_EDGES_MODE = 0x18U
} LDD_AnalogComp_TComparatorMode;      /* Type specifying requested comparator mode */

typedef uint8_t LDD_AnalogComp_TOutputValue; /* Type specifying comparator output value */

/*
** ===================================================================
** SDHC component types and constants
** ===================================================================
*/

#define LDD_SDHC_CARD_DATA_WIDTH_1_BIT 0x01u /* Card supports 1 bit data bus */
#define LDD_SDHC_CARD_DATA_WIDTH_4_BIT 0x02u /* Card supports 4 bit data bus */
#define LDD_SDHC_CARD_DATA_WIDTH_8_BIT 0x04u /* Card supports 8 bit data bus */
#define LDD_SDHC_CARD_BLOCK_READ       0x01u /* Card supports block reading */
#define LDD_SDHC_CARD_BLOCK_WRITE      0x04u /* Card supports block writing */
#define LDD_SDHC_CARD_ERASE            0x08u /* Card supports block erasion */
#define LDD_SDHC_CARD_WRITE_PROTECTION 0x10u /* Card supports write protection */
#define LDD_SDHC_CARD_IO               0x80u /* Card supports IO */

#define LDD_SDHC_CLK_PIN   0x01u       /* SD clock pin mask */
#define LDD_SDHC_CMD_PIN   0x02u       /* SD command line pin mask */
#define LDD_SDHC_DAT0_PIN  0x04u       /* SD data line 0 pin mask */
#define LDD_SDHC_DAT1_PIN  0x08u       /* SD data line 1 pin mask */
#define LDD_SDHC_DAT2_PIN  0x10u       /* SD data line 2 pin mask */
#define LDD_SDHC_DAT3_PIN  0x20u       /* SD data line 3 pin mask */
#define LDD_SDHC_DAT4_PIN  0x40u       /* SD data line 4 pin mask */
#define LDD_SDHC_DAT5_PIN  0x80u       /* SD data line 5 pin mask */
#define LDD_SDHC_DAT6_PIN  0x0100u     /* SD data line 6 pin mask */
#define LDD_SDHC_DAT7_PIN  0x0200u     /* SD data line 7 pin mask */
#define LDD_SDHC_CD_PIN    0x0400u     /* SD card detection pin mask */
#define LDD_SDHC_WP_PIN    0x0800u     /* SD write protection pin mask */
#define LDD_SDHC_LCTL_PIN  0x1000u     /* SD LED control pin mask */
#define LDD_SDHC_VS_PIN    0x2000u     /* SD voltage control pin mask */

#define LDD_SDHC_ON_CARD_INSERTED 0x01u /* OnCardInserted event mask */
#define LDD_SDHC_ON_CARD_REMOVED  0x02u /* OnCardRemoved event mask */
#define LDD_SDHC_ON_FINISHED      0x04u /* OnFinished event mask */

typedef enum {                         /* Card types */
  LDD_SDHC_SD,                         /* Secure Digital memory card */
  LDD_SDHC_SDIO,                       /* Secure Digital IO card */
  LDD_SDHC_SDCOMBO,                    /* Combined Secure Digital memory and IO card */
  LDD_SDHC_MMC,                        /* MultiMediaCard memory card */
  LDD_SDHC_CE_ATA                      /* Consumer Electronics ATA card */
} LDD_SDHC_TCardType;

typedef struct {                       /* Card access properties */
  uint16_t MaxBlockLength;             /* Max. transferable block length */
  bool     MisalignBlock;              /* Indicates if the data block can be spread over more than one physical block of the memory device */
  bool     PartialBlock;               /* Indicates whether partial block sizes can be used in block access */
} LDD_SDHC_TCardAccess;

typedef struct {                       /* Card erasion properties */
  uint16_t SectorSize;                 /* The size of an erasable unit */
  uint8_t  Pattern;                    /* Memory content after erase */
} LDD_SDHC_TCardErase;

typedef struct {                       /* Card write protection properties */
  uint16_t GroupSize;                  /* The size of write protected group in number of erase groups */
  bool     Permanent;                  /* Indicates whether card is permanently write protected (read-only) */
} LDD_SDHC_TCardWriteProtect;

typedef struct {                       /* Card capabilities */
  uint8_t              DataWidths;     /* Bit mask of supported data bus widths */
  uint8_t              Operations;     /* Bit mask of supported operations */
  bool                 HighSpeed;      /* Indicates whether the card supports high clock configuration (SD bus clock frequency higher than about 25MHz) */
  bool                 HighCapacity;   /* Indicates whether the card requires block addressing instead of byte addressing */
  bool                 LowVoltage;     /* Indicates whether the card supports the host's low voltage range */
  LDD_SDHC_TCardAccess Read;           /* Card data read access capabilities */
  LDD_SDHC_TCardAccess Write;          /* Card data write access capabilities */
  LDD_SDHC_TCardErase  Erase;          /* Card data erasion capabilities */
  LDD_SDHC_TCardWriteProtect WriteProtect; /* Write protection properties */
} LDD_SDHC_TCardCaps;

typedef struct {                       /* Card features description */
  LDD_SDHC_TCardType Type;             /* Card type */
  uint16_t           BlockLength;      /* Physical memory block length */
  uint32_t           BlockCount;       /* Number of physical memory blocks */
  LDD_SDHC_TCardCaps Caps;             /* Card capabilities */
} LDD_SDHC_TCardInfo;

typedef enum {                         /* Transfer operations */
  LDD_SDHC_READ,
  LDD_SDHC_WRITE
} LDD_SDHC_TTransferOperation;

typedef struct {                       /* Transfer buffer descriptor */
  uint16_t Size;                       /* Buffer data size */
  uint8_t  *DataPtr;                   /* Pointer to buffer data */
} LDD_SDHC_TBufferDesc;

typedef enum {                         /* Voltage options */
  LDD_SDHC_LOW_VOLTAGE,
  LDD_SDHC_HIGH_VOLTAGE
} LDD_SDHC_TVoltage;

typedef enum {                         /* Write protection types */
  LDD_SDHC_GROUP,                      /* Write protection by groups */
  LDD_SDHC_CARD                        /* Whole card write protection */
} LDD_SDHC_TWriteProtectType;

typedef enum {                         /* Component states */
  LDD_SDHC_DISABLED,
  LDD_SDHC_RESET,
  LDD_SDHC_IDLE,
  LDD_SDHC_VOLTAGE_VALIDATION,
  LDD_SDHC_CARD_REGISTRATION,
  LDD_SDHC_CARD_SELECTION,
  LDD_SDHC_CARD_INFO_RETRIEVAL,
  LDD_SDHC_TRANSFER,
  LDD_SDHC_ERASION,
  LDD_SDHC_IO_REG_TRANSFER,
  LDD_SDHC_DATA_WIDTH_SELECTION,
  LDD_SDHC_BUS_CLOCK_SELECTION,
  LDD_SDHC_WRITE_PROTECTION_SETUP,
  LDD_SDHC_WRITE_PROTECTION_RETRIEVAL
} LDD_SDHC_TStatus;

typedef enum {                         /* Operation completion error codes */
  LDD_SDHC_ERR_OK,                     /* No error */
  LDD_SDHC_ERR_DMA,                    /* DMA or block size error */
  LDD_SDHC_ERR_NOT_SUPPORTED,          /* Initiated operation is not supported by the card (supported operations are contained in the card information structure) */
  LDD_SDHC_ERR_TIMEOUT,                /* Command or data timeout */
  LDD_SDHC_ERR_COMMAND_CRC,            /* Command CRC check failed */
  LDD_SDHC_ERR_DATA_CRC,               /* Data CRC check failed */
  LDD_SDHC_ERR_ADDRESS_OUT_OF_RANGE,   /* The card address is beyond the card capacity */
  LDD_SDHC_ERR_ADDRESS_MISALIGN,       /* The card address does not align with physical blocks of the card */
  LDD_SDHC_ERR_BLOCK_LEN_ERROR,        /* Block length exceeds the maximum value for the card */
  LDD_SDHC_ERR_WP_VIOLATION,           /* Attempt to program a write protected block */
  LDD_SDHC_ERR_CARD_IS_LOCKED,         /* The card is locked by the host */
  LDD_SDHC_ERR_WP_ERASE_SKIP,          /* Only partial address space was erased due to existing write protected blocks */
  LDD_SDHC_ERR_INTERNAL_FAILURE,       /* Internal component error */
  LDD_SDHC_ERR_CARD_FAILURE            /* The card was unable to complete the operation */
} LDD_SDHC_TError;

/*
** ===================================================================
** DMA device types and constants
** ===================================================================
*/

#define LDD_DMA_ON_COMPLETE                    0x01U /* OnTransferComplete event mask. */
#define LDD_DMA_ON_ERROR                       0x02U /* OnError event mask. */

#define LDD_DMA_CONFIGURATION_ERROR            0x40000000U /* Configuration error. */
#define LDD_DMA_SOURCE_BUS_ERROR               0x20000000U /* Bus error on a source read. */
#define LDD_DMA_DESTINATION_BUS_ERROR          0x10000000U /* Bus error on a destination write. */

/* eDMA device error constants for backward compatibility */
#define LDD_DMA_CHANNEL_PRIORITY_ERROR         0x4000U /* Channel priority error. */
#define LDD_DMA_SOURCE_ADDRESS_ERROR           0x80U /* Address inconsistency with transfer size error. */
#define LDD_DMA_SOURCE_OFFSET_ERROR            0x40U /* Offset inconsistency with transfer size error. */
#define LDD_DMA_DESTINATION_ADDRESS_ERROR      0x20U /* Address inconsistency with transfer size error. */
#define LDD_DMA_DESTINATION_OFFSET_ERROR       0x10U /* Offset inconsistency with transfer size error. */
#define LDD_DMA_COUNT_ERROR                    0x08U /* Byte count inconsistency with transfer sizes or transfer count error. */
#define LDD_DMA_SCATTER_GATHER_ERROR           0x04U /* Scatter/gather configuration error. */

#define LDD_DMA_CHANNEL_0_MASK                 0x01U /* DMA channel 0 mask. */
#define LDD_DMA_CHANNEL_1_MASK                 0x02U /* DMA channel 1 mask. */
#define LDD_DMA_CHANNEL_2_MASK                 0x04U /* DMA channel 2 mask. */
#define LDD_DMA_CHANNEL_3_MASK                 0x08U /* DMA channel 3 mask. */
#define LDD_DMA_CHANNEL_4_MASK                 0x10U /* DMA channel 4 mask. */
#define LDD_DMA_CHANNEL_5_MASK                 0x20U /* DMA channel 5 mask. */
#define LDD_DMA_CHANNEL_6_MASK                 0x40U /* DMA channel 6 mask. */
#define LDD_DMA_CHANNEL_7_MASK                 0x80U /* DMA channel 7 mask. */
#define LDD_DMA_CHANNEL_8_MASK                 0x0100U /* DMA channel 8 mask. */
#define LDD_DMA_CHANNEL_9_MASK                 0x0200U /* DMA channel 9 mask. */
#define LDD_DMA_CHANNEL_10_MASK                0x0400U /* DMA channel 10 mask. */
#define LDD_DMA_CHANNEL_11_MASK                0x0800U /* DMA channel 11 mask. */
#define LDD_DMA_CHANNEL_12_MASK                0x1000U /* DMA channel 12 mask. */
#define LDD_DMA_CHANNEL_13_MASK                0x2000U /* DMA channel 13 mask. */
#define LDD_DMA_CHANNEL_14_MASK                0x4000U /* DMA channel 14 mask. */
#define LDD_DMA_CHANNEL_15_MASK                0x8000U /* DMA channel 15 mask. */

/* Action executed after request and transfer service completes */
#define LDD_DMA_NO_ACTION                      0x00U /* No action performed after request serviced. */
#define LDD_DMA_DESTINATION_ADDRESS_ADJUSTMENT 0x01U /* Destination address adjustment after request serviced. */
#define LDD_DMA_SOURCE_ADDRESS_ADJUSTMENT      0x02U /* Source address adjustment after request serviced. */
#define LDD_DMA_ADDRESS_ADJUSTMENT             0x01U /* Address adjustment after transfer completed. */
#define LDD_DMA_SCATTER_GATHER                 0x02U /* Scatter/gather performed after transfer completed. */

typedef uint32_t LDD_DMA_TAddress;     /* Type specifying the address parameter used by the DMA component's methods. */
typedef int32_t  LDD_DMA_TAddressOffset; /* Type specifying the address signed offset parameter used by the DMA component's methods. */
typedef uint32_t LDD_DMA_TByteCount;   /* Type specifying the byte count/minor loop count parameter used by the DMA component's methods. */
typedef uint8_t  LDD_DMA_TTransferSize; /* Type specifying the transfer size parameter used by the DMA component's methods. See the DMA_PDD header file for detail description of allowed values. */
typedef uint8_t  LDD_DMA_TModuloSize;  /* Type specifying the modulo size parameter used by the DMA component's methods. */
                                       /* This value power of two represents size of used circular buffer (0U - buffer disabled). See the MCU manual for detail description of allowed values. */
typedef uint8_t  LDD_DMA_TTriggerSource; /* Type specifying the trigger source signal number. See the MCU manual for detail description of allowed values. */
typedef uint8_t  LDD_DMA_TChannelNumber; /* Type specifying the DMA channel number. See the MCU manual for detail description of allowed values. */
typedef uint8_t  LDD_DMA_TRecordNumber; /* Type specifying the DMA descriptor record number. */
typedef uint16_t LDD_DMA_TChannelMask; /* Type specifying the DMA channel mask. For possible values see channel mask constants. */
typedef uint8_t  LDD_DMA_TChannelPriority; /* Type specifying the DMA channel priority number. See the MCU manual for detail description of allowed values. */
typedef uint8_t  LDD_DMA_TOuterLoopCount; /* Type specifying the transfer outer/major loop count. */
typedef uint8_t  LDD_DMA_TAfterRequest; /* Type specifying the operation executed after request service is completed. */
typedef uint8_t  LDD_DMA_TAfterTransfer; /* Type specifying the operation executed after transfer service is completed. */
typedef uint8_t  LDD_DMA_TBandwidthControl; /* Type specifying the bandwidth control. See the DMA_PDD header file for detail description of allowed values. */
typedef uint32_t LDD_DMA_TErrorFlags;  /* DMA controller error flags. See the DMA_LDD component's header file for detail description of allowed values. */

typedef enum {                         /* Type specifying a DMA channel status. */
  LDD_DMA_IDLE,                        /* Channel is idle, no request is serviced nor transfer completed. */
  LDD_DMA_BUSY,                        /* Channel is active, request is serviced. */
  LDD_DMA_DONE,                        /* Transfer is completed, waiting to start of next transfer. */
  LDD_DMA_ERROR                        /* Error detected. */
} LDD_DMA_TChannelStatus;

typedef enum {                         /* Type specifying the DMA transfer mode. */
  LDD_DMA_CYCLE_STEAL_TRANSFERS,       /* Only single read/write transfer is done per one service request. */
  LDD_DMA_SINGLE_TRANSFER,             /* Transfer of all bytes defined by Data size is done after single service request. */
  LDD_DMA_NESTED_TRANSFERS             /* Sequence of transfers triggered by service requests. One request transfers number of bytes defined by Byte count value. */
} LDD_DMA_TTransferMode;

typedef enum {                         /* Type specifying the DMA trigger source type. */
  LDD_DMA_SW_TRIGGER,                  /* Explicit software trigger. */
  LDD_DMA_HW_TRIGGER,                  /* Peripheral device trigger. */
  LDD_DMA_ALWAYS_ENABLED_TRIGGER       /* Always enabled trigger. */
} LDD_DMA_TTriggerType;

typedef enum {                         /* Type specifying the DMA channel linking mode. */
  LDD_DMA_LINKING_DISABLED,            /* No linking. */
  LDD_DMA_CYCLE_STEAL_AND_TRANSFER_COMPLETE_LINKING, /* Channel linked after each particular read-write operation and after transfer byte count reaches zero. */
  LDD_DMA_CYCLE_STEAL_LINKING,         /* Channel linked after each particular read-write operation. */
  LDD_DMA_TRANSFER_COMPLETE_LINKING    /* Channel linked after transfer byte count reaches zero. */
} LDD_DMA_TChannelLinkingMode;

typedef struct {                       /* Type specifying the DMA error information structure. */
  LDD_DMA_TChannelNumber ChannelNumber; /* Last error recorded channel number. */
  LDD_DMA_TErrorFlags ErrorFlags;      /* Channel error flags. */
} LDD_DMA_TError;

typedef struct {                       /* Type specifying the DMA Transfer descriptor information structure. */
  LDD_TUserData                  *UserDataPtr; /* User device data structure pointer to be returned by the DMA_LDD component's ISR to the dynamic callback of this transfer descriptor. */
  LDD_DMA_TAddress               SourceAddress; /* Address of a DMA transfer source data. */
  bool                           SourceAddressIncrement; /* TRUE - Source address incrementrf after each elemental read operation. */
  LDD_DMA_TTransferSize          SourceTransferSize; /* Source data transfer size (size of a elemental read operation). See the DMA_PDD header file for detail description of allowed values. */
  LDD_DMA_TModuloSize            SourceModuloSize; /* Source address modulo size. For the description of allowed values see the LDD_DMA_TModuloSize type declaration. */
  LDD_DMA_TAddress               DestinationAddress; /* Address of a DMA transfer destination. */
  bool                           DestinationAddressIncrement; /* TRUE - destination address incremented after each elemental write operation. */
  LDD_DMA_TTransferSize          DestinationTransferSize; /* Destination data transfer size (size of a elemental write operation). See the DMA_PDD header file for detail description of allowed values. */
  LDD_DMA_TModuloSize            DestinationModuloSize; /* Destination address modulo size. For the description of allowed values see the LDD_DMA_TModuloSize type declaration. */
  LDD_DMA_TTransferMode          TransferMode; /* Selects DMA transfer mode. For the description of allowed values see the LDD_DMA_TTransferMode type declaration. */
  LDD_DMA_TByteCount             ByteCount; /* Size of data in bytes to be transferred in single transfer. */
  bool                           AutoAlign; /* TRUE - Auto-align mode is enabled. Transfers are optimized based on the transfer address and size. */
  LDD_DMA_TChannelLinkingMode    ChannelLinkingMode; /* Selects channel linking mode. For the description of allowed values see the LDD_DMA_TChannelLinkingMode type declaration. */
  LDD_DMA_TChannelNumber         InnerLoopLinkedChannel; /* Linked DMA channel number (used only if the ChannelLinkingMode item is set with LDD_DMA_CYCLE_STEAL_AND_TRANSFER_COMPLETE_LINKING or LDD_DMA_CYCLE_STEAL_LINKING). */
  LDD_DMA_TChannelNumber         OuterLoopLinkedChannel; /* Linked DMA channel number (used only if the ChannelLinkingMode item is set with LDD_DMA_CYCLE_STEAL_AND_TRANSFER_COMPLETE_LINKING or LDD_DMA_TRANSFER_COMPLETE_LINKING). */
  bool                           ChannelAutoSelection; /* TRUE - DMA channel autoselection engine is used. FALSE - DMA fixed channel is used. */
  LDD_DMA_TChannelNumber         ChannelNumber; /* If ChannelAutoSelection is FALSE this item contains fixed channel number. If ChannelAutoSelection is TRUE then after allocation this item is filled by autoselected channel number. */
  LDD_DMA_TTriggerType           TriggerType; /* DMA transfer trigger type. For the description of allowed values see the LDD_DMA_TBTriggerType declaration. */
  LDD_DMA_TTriggerSource         TriggerSource; /* Trigger source number. For the description of allowed values see the LDD_DMA_TBTriggerType declaration. */
  bool                           PeriodicTrigger; /* TRUE - periodic trigger is required, FALSE - periodic trigger is not required. */
  bool                           DisableAfterRequest; /* TRUE - DMA transfer request is automatically disabled after transfer complete. */
  bool                           AsynchronousRequests; /* TRUE - Enables the channel to support asynchronous DREQs while the MCU is in Stop mode. */
  bool                           Interrupts; /* TRUE - interrupts are requested. */
  bool                           OnComplete; /* TRUE - event is enabled during initialization. */
  bool                           OnError; /* TRUE - event is enabled during initialization. */
  void (*OnCompleteEventPtr)(LDD_TUserData* UserDataPtr); /* Pointer to the OnComplete event, NULL if event is not used. */
  void (*OnErrorEventPtr)(LDD_TUserData* UserDataPtr); /* Pointer to the OnError event, NULL if event is not used. */
  bool                           ChannelEnabled; /* TRUE - DMA channel is allocated and used by DMATransfer component. */
} LDD_DMA_TTransferDescriptor;

typedef LDD_DMA_TTransferDescriptor *LDD_DMA_TTransferDescriptorPtr; /* Type specifying address of the DMA Transfer descriptor structure. */

/*
** ===================================================================
** SPI device types and constants - SPIMaster_LDD
** ===================================================================
*/

#define LDD_SPIMASTER_INPUT_PIN                      0x01u /* Input pin mask */
#define LDD_SPIMASTER_OUTPUT_PIN                     0x02u /* Output pin mask */
#define LDD_SPIMASTER_CLK_PIN                        0x04u /* Clock pin mask */
#define LDD_SPIMASTER_CS_0_PIN                       0x08u /* Chip select 0 pin mask */
#define LDD_SPIMASTER_CS_1_PIN                       0x10u /* Chip select 1 pin mask */
#define LDD_SPIMASTER_CS_2_PIN                       0x20u /* Chip select 2 pin mask */
#define LDD_SPIMASTER_CS_3_PIN                       0x40u /* Chip select 3 pin mask */
#define LDD_SPIMASTER_CS_4_PIN                       0x80u /* Chip select 4 pin mask */
#define LDD_SPIMASTER_CS_5_PIN                       0x0100u /* Chip select 5 pin mask */
#define LDD_SPIMASTER_CS_6_PIN                       0x0200u /* Chip select 6 pin mask */
#define LDD_SPIMASTER_CS_7_PIN                       0x0400u /* Chip select 7 pin mask */
#define LDD_SPIMASTER_CSS_PIN                        0x0800u /* Chip select strobe pin mask */

#define LDD_SPIMASTER_ON_BLOCK_RECEIVED 0x01u /* OnBlockReceived event mask */
#define LDD_SPIMASTER_ON_BLOCK_SENT     0x02u /* OnBlockSent event mask */
#define LDD_SPIMASTER_ON_ERROR          0x04u /* OnError event mask */

#define LDD_SPIMASTER_RX_OVERFLOW   (SPI_SR_RFOF_MASK) /* Receiver overflow */
#define LDD_SPIMASTER_PARITY_ERROR  (SPI_SR_SPEF_MASK) /* Parity error */

typedef uint32_t LDD_SPIMASTER_TError; /* Communication error type */

typedef struct {                       /* Communication statistics */
  uint32_t RxChars;                    /* Number of received characters */
  uint32_t TxChars;                    /* Number of transmitted characters */
  uint32_t RxParityErrors;             /* Number of receiver parity errors, which have occured */
  uint32_t RxOverruns;                 /* Number of receiver overruns, which have occured */
} LDD_SPIMASTER_TStats;

/*
** ===================================================================
** SPI device types and constants - SPISlave_LDD
** ===================================================================
*/

#define LDD_SPISLAVE_INPUT_PIN                      0x01u /* Input pin mask */
#define LDD_SPISLAVE_OUTPUT_PIN                     0x02u /* Output pin mask */
#define LDD_SPISLAVE_CLK_PIN                        0x04u /* Clock pin mask */
#define LDD_SPISLAVE_SS_PIN                         0x08u /* Slave select pin mask */

#define LDD_SPISLAVE_ON_BLOCK_RECEIVED 0x01u /* OnBlockReceived event mask */
#define LDD_SPISLAVE_ON_BLOCK_SENT     0x02u /* OnBlockSent event mask */
#define LDD_SPISLAVE_ON_ERROR          0x04u /* OnError event mask */

#define LDD_SPISLAVE_RX_OVERFLOW   (SPI_SR_RFOF_MASK) /* Receiver overflow */
#define LDD_SPISLAVE_TX_UNDERFLOW  (SPI_SR_TFUF_MASK) /* Transmitter underflow */
#define LDD_SPISLAVE_PARITY_ERROR  (SPI_SR_SPEF_MASK) /* Parity error */

typedef uint32_t LDD_SPISLAVE_TError;  /* Communication error type */

typedef struct {                       /* Communication statistics */
  uint32_t RxChars;                    /* Number of received characters */
  uint32_t TxChars;                    /* Number of transmitted characters */
  uint32_t RxParityErrors;             /* Number of receiver parity errors, which have occured */
  uint32_t RxOverruns;                 /* Number of receiver overruns, which have occured */
  uint32_t TxUnderruns;                /* Number of transmitter underruns, which have occured */
} LDD_SPISLAVE_TStats;

/*
** ===================================================================
** I2S device types and constants
** ===================================================================
*/

#define LDD_SSI_INPUT_PIN                         0x01U /* Input pin mask */
#define LDD_SSI_OUTPUT_PIN                        0x02U /* Output pin mask */
#define LDD_SSI_RX_CLK_PIN                        0x04U /* Rx clock pin mask */
#define LDD_SSI_TX_CLK_PIN                        0x08U /* Tx clock pin mask */
#define LDD_SSI_RX_FS_PIN                         0x10U /* Rx frame sync pin mask */
#define LDD_SSI_TX_FS_PIN                         0x20U /* Tx frame sync pin mask */
#define LDD_SSI_MCLK_PIN                          0x40U /* Master clock pin mask */
#define LDD_SSI_INPUT_PIN_CHANNEL_0               0x80U /* Input pin mask for data channel 0 */
#define LDD_SSI_INPUT_PIN_CHANNEL_1               0x0100U /* Input pin mask for data channel 1 */
#define LDD_SSI_OUTPUT_PIN_CHANNEL_0              0x0200U /* Output pin mask for data channel 0 */
#define LDD_SSI_OUTPUT_PIN_CHANNEL_1              0x0400U /* Output pin mask for data channel 1 */

#define LDD_SSI_ON_BLOCK_RECEIVED                  0x01u /* OnBlockReceived event mask */
#define LDD_SSI_ON_BLOCK_SENT                      0x02u /* OnBlockSent event mask */
#define LDD_SSI_ON_ERROR                           0x04u /* OnError event mask */
#define LDD_SSI_ON_BLOCK_RECEIVED_1                0x08u /* OnBlockReceived event mask for second channel */
#define LDD_SSI_ON_BLOCK_SENT_1                    0x10u /* OnBlockSent event mask for second channel */
#define LDD_SSI_ON_RECEIVE_FRAME_SYNC              0x20u /* OnReceiveFrameSync event mask for second channel */
#define LDD_SSI_ON_TRANSMIT_FRAME_SYNC             0x40u /* OnTransmitFrameSync event mask for second channel */
#define LDD_SSI_ON_RECEIVE_LAST_SLOT               0x80u /* OnReceiveLastSlot event mask for second channel */
#define LDD_SSI_ON_TRANSMIT_LAST_SLOT              0x0100u /* OnTransmitLastSlot event mask for second channel */
#define LDD_SSI_ON_RECEIVE_COMPLETE                0x0200u /* OnReceiveComplete event mask for second channel */
#define LDD_SSI_ON_TRANSMIT_COMPLETE               0x0400u /* OnTransmitComplete event mask for second channel */
#define LDD_SSI_ON_A_C_9_7_TAG_UPDATED             0x0800u /* OnAC97TagUpdated event mask for second channel */
#define LDD_SSI_ON_AC_97_TAG_UPDATED               0x0800u /* OnAC97TagUpdated event mask for second channel */
#define LDD_SSI_ON_A_C_9_7_COMMAND_ADDRESS_UPDATED 0x1000u /* OnAC97CommandAddressUpdated event mask for second channel */
#define LDD_SSI_ON_AC_97_COMMAND_ADDRESS_UPDATED   0x1000u /* OnAC97CommandAddressUpdated event mask for second channel */
#define LDD_SSI_ON_A_C_9_7_COMMAND_DATA_UPDATED    0x2000u /* OnAC97CommandDataUpdated event mask for second channel */
#define LDD_SSI_ON_AC_97_COMMAND_DATA_UPDATED      0x2000u /* OnAC97CommandDataUpdated event mask for second channel */

#define LDD_SSI_RECEIVER        (I2S_CR_RE_MASK) /* Receive section of the device. */
#define LDD_SSI_TRANSMITTER     (I2S_CR_TE_MASK) /* Transmit section of the device. */

#define LDD_SSI_RX_OVERFLOW    (I2S_ISR_ROE0_MASK) /* Receiver overflow */
#define LDD_SSI_RX_OVERFLOW_1  (I2S_ISR_ROE1_MASK) /* Receiver overflow 1 */
#define LDD_SSI_TX_UNDERFLOW   (I2S_ISR_TUE0_MASK) /* Transmitter underflow */
#define LDD_SSI_TX_UNDERFLOW_1 (I2S_ISR_TUE1_MASK) /* Transmitter underflow 1 */

#define LDD_SSI_RX_FRAME_COMPLETE    (I2S_ISR_RFRC_MASK) /* Receive frame is finished after disabling transfer */
#define LDD_SSI_TX_FRAME_COMPLETE    (I2S_ISR_TFRC_MASK) /* Transmit frame is finished after disabling transfer */
#define LDD_SSI_RX_FRAME_SYNC        (I2S_ISR_RFS_MASK) /* Receiver frame sync */
#define LDD_SSI_TX_FRAME_SYNC        (I2S_ISR_TFS_MASK) /* Transmit frame sync */
#define LDD_SSI_RX_LAST_SLOT         (I2S_ISR_RLS_MASK) /* Receive last time slot */
#define LDD_SSI_TX_LAST_SLOT         (I2S_ISR_TLS_MASK) /* Transmit last time slot */
#define LDD_SSI_AC97_TAG             (I2S_ISR_RXT_MASK) /* AC97 tag updated */
#define LDD_SSI_AC97_COMMAND_ADDRESS (I2S_ISR_CMDAU_MASK) /* AC97 command address updated */
#define LDD_SSI_AC97_COMMAND_DATA    (I2S_ISR_CMDDU_MASK) /* AC97 command data updated */

typedef uint8_t LDD_SSI_TSectionMask;  /* Device section type */

typedef uint32_t LDD_SSI_TError;       /* Communication error type */

typedef uint32_t LDD_SSI_TComStatus;   /* Communication status type */

typedef struct {                       /* Group of pointers to data blocks. */
  LDD_TData *Channel0Ptr;              /* Pointer to data block to send/received via data channel 0 */
  LDD_TData *Channel1Ptr;              /* Pointer to data block to send/received via data channel 1 */
} LDD_SSI_TDataBlocks;

typedef enum {
  LDD_SSI_READ_COMMAND  = 0x08u,
  LDD_SSI_WRITE_COMMAND = 0x10u
} LDD_SSI_TAC97CommandType;            /* Command type */

typedef struct {                       /* AC97 command */
  LDD_SSI_TAC97CommandType Type;       /* Command type */
  uint32_t Address;                    /* Command address */
  uint32_t Data;                       /* Command data */
} LDD_SSI_TAC97Command;

typedef struct {                       /* Communication statistics */
  uint32_t RxChars;                    /* Number of received characters */
  uint32_t TxChars;                    /* Number of transmitted characters */
  uint32_t RxOverruns;                 /* Number of receiver overruns, which have occured */
  uint32_t TxUnderruns;                /* Number of transmitter underruns, which have occured */
  uint32_t RxChars1;                   /* Number of received characters for second channel */
  uint32_t TxChars1;                   /* Number of transmitted characters for second channel */
  uint32_t RxOverruns1;                /* Number of receiver overruns, which have occured for second channel */
  uint32_t TxUnderruns1;               /* Number of transmitter underruns, which have occured for second channel */
} LDD_SSI_TStats;

/*
** ===================================================================
** RTC device types and constants
** ===================================================================
*/

#define LDD_RTC_ON_SECOND              0x10u /* OnSecond event mask */
#define LDD_RTC_ON_MONOTONIC_OVERFLOW  0x08u /* OnMonotonicCounter event mask */
#define LDD_RTC_ON_ALARM               0x04u /* OnAlarm event mask */
#define LDD_RTC_ON_TIME_OVERFLOW       0x02u /* OnTimeOverflow event mask */
#define LDD_RTC_ON_TIME_INVALID        0x01u /* OnTimeInvalid event mask */
#define LDD_RTC_ON_STOPWATCH           0x0100u /* OnStopwatch event mask */

typedef struct {                       /* Structure used for time operation */
  uint32_t Second;                     /* seconds (0 - 59) */
  uint32_t Minute;                     /* minutes (0 - 59) */
  uint32_t Hour;                       /* hours (0 - 23) */
  uint32_t DayOfWeek;                  /* day of week (0-Sunday, .. 6-Saturday)  */
  uint32_t Day;                        /* day (1 - 31) */
  uint32_t Month;                      /* month (1 - 12) */
  uint32_t Year;                       /* year */
} LDD_RTC_TTime;



/*
** ===================================================================
** CRC device types and constants
** ===================================================================
*/

#define LDD_CRC_16_SEED_LOW 0x00U      /* CRC 16bit seed low */
#define LDD_CRC_16_POLY_LOW 0x8005U    /* CRC 16bit poly low */
#define LDD_CRC_32_SEED_LOW 0xFFFFU    /* CRC 32bit seed low */
#define LDD_CRC_32_SEED_HIGH 0xFFFFU   /* CRC 32bit seed high */
#define LDD_CRC_32_POLY_LOW 0x1DB7U    /* CRC 32bit poly low */
#define LDD_CRC_32_POLY_HIGH 0x04C1U   /* CRC 32bit poly high */
#define LDD_CRC_CCITT_SEED_LOW 0xFFFFU /* CRC CCITT seed low */
#define LDD_CRC_CCITT_POLY_LOW 0x1021U /* CRC CCITT poly low */
#define LDD_CRC_MODBUS_16_SEED_LOW 0xFFFFU /* CRC MODBUS16 seed low */
#define LDD_CRC_MODBUS_16_POLY_LOW 0x8005U /* CRC MODBUS16 poly low */
#define LDD_CRC_KERMIT_SEED_LOW 0x00U  /* CRC KERMIT seed low */
#define LDD_CRC_KERMIT_POLY_LOW 0x1021U /* CRC KERMIT poly low */
#define LDD_CRC_DNP_SEED_LOW 0x00U     /* CRC DNP seed low */
#define LDD_CRC_DNP_POLY_LOW 0x3D65U   /* CRC DNP poly low */

typedef enum  {                        /* Transpose type */
  LDD_CRC_NO_TRANSPOSE = 0,
  LDD_CRC_BITS = 1,
  LDD_CRC_BITS_AND_BYTES = 2,
  LDD_CRC_BYTES = 3
} LDD_CRC_TTransposeType;


typedef enum  {                        /* CRC standard  */
  LDD_CRC_16,
  LDD_CRC_CCITT,
  LDD_CRC_MODBUS_16,
  LDD_CRC_KERMIT,
  LDD_CRC_DNP,
  LDD_CRC_32,
  LDD_CRC_USER
} LDD_CRC_TCRCStandard;

typedef struct  {                      /* User CRC standard  */
  bool Width32bit;                     /* 32bir CRC? */
  bool ResultXORed;                    /* Result XORed? */
  uint16_t SeedLow;                    /* Seed low value */
  uint16_t SeedHigh;                   /* Seed high value */
  uint16_t PolyLow;                    /* Poly low value */
  uint16_t PolyHigh;                   /* Poly high value */
  LDD_CRC_TTransposeType InputTransposeMode; /* Input transpose type */
  LDD_CRC_TTransposeType OutputTransposeMode; /* Output transpose type */
} LDD_CRC_TUserCRCStandard;

/*
** ===================================================================
** RNG device types and constants
** ===================================================================
*/


#define LDD_RNG_LFSR_ERROR 0x01U       /* Linear feedback shift register error */
#define LDD_RNG_OSCILLATOR_ERROR 0x02U /* Oscillator error */
#define LDD_RNG_SELF_TEST_ERROR 0x04U  /* Self test error */
#define LDD_RNG_STATISTICAL_ERROR 0x08U /* LStatistical test error */
#define LDD_RNG_FIFO_UNDERFLOW_ERROR 0x10U /* FIFO underflow error */

#define LDD_RNG_SELF_TETS_RESEED_ERROR 0x00200000U /* Reseed self test fail */
#define LDD_RNG_SELF_TEST_PRNG_ERROR 0x00400000U /* PRNG self test fail */
#define LDD_RNG_SELF_TEST_TRNG_ERROR 0x00800000U /* TRNG self test fail */
#define LDD_RNG_MONOBIT_TEST_ERROR 0x01000000U /* Monobit test fail */
#define LDD_RNG_LENGTH_1_RUN_TEST_ERROR 0x02000000U /* Length 1 run test fail */
#define LDD_RNG_LENGTH_2_RUN_TEST_ERROR 0x04000000U /* Length 2 run test fail */
#define LDD_RNG_LENGTH_3_RUN_TEST_ERROR 0x08000000U /* Length 3 run test fail */
#define LDD_RNG_LENGTH_4_RUN_TEST_ERROR 0x10000000U /* Length 4 run test fail */
#define LDD_RNG_LENGTH_5_RUN_TEST_ERROR 0x20000000U /* Length 5 run test fail */
#define LDD_RNG_LENGTH_6_RUN_TEST_ERROR 0x40000000U /* Length 6 run test fail */
#define LDD_RNG_LONG_RUN_TEST_ERROR 0x80000000U /* Long run test fail */

#define LDD_RNG_ON_SEED_GENERATION_DONE 0x01U /* OnSeedGenerationDone event mask */
#define LDD_RNG_ON_SELF_TEST_DONE 0x02U /* OnSelfTestDone event mask */
#define LDD_RNG_ON_ERROR_LFSR 0x04U    /* OnErrorLFSR event mask */
#define LDD_RNG_ON_OSC_ERROR 0x08U     /* OnOscError event mask */
#define LDD_RNG_ON_SELF_TEST_ERROR 0x10U /* OnSelfTestError event mask */
#define LDD_RNG_ON_STATISTICAL_ERROR 0x20U /* OnStatisticalError event mask */
#define LDD_RNG_ON_FIFO_UNDER_FLOW_ERROR 0x40U /* OnFIFOUnderFlowError event mask */
#define LDD_RNG_ON_FIFOUNDER_FLOW_ERROR 0x40U /* OnFIFOUnderFlowError event mask */

#define LDD_RNG_STATUS_ERROR 0xFFFFU   /* Error in RNG module flag */
#define LDD_RNG_STATUS_NEW_SEED_DONE 0x40U /* New seed done flag */
#define LDD_RNG_STATUS_SEED_DONE 0x20U /* Seed done flag */
#define LDD_RNG_STATUS_SELF_TEST_DONE 0x10U /* Self test done flag */
#define LDD_RNG_STATUS_RESEED_NEEDED 0x08U /* Reseed needed flag */
#define LDD_RNG_STATUS_SLEEP 0x04U     /* RNG in sleep mode */
#define LDD_RNG_STATUS_BUSY 0x02U      /* RNG busy flag */


/*
** ===================================================================
** RNGA device types and constants
** ===================================================================
*/

#define LDD_RNG_ON_ERROR 0x01U         /* OnError event mask */

#define LDD_RNG_STATUS_SECURITY_VIOLATION 0x01U /* Security violation occured */
#define LDD_RNG_STATUS_LAST_READ_UNDERFLOW 0x02U /* Last read from RNGA caused underflow error */
#define LDD_RNG_STATUS_OUT_REG_UNDERFLOW 0x04U /* The RNGA Output Register has been read while empty since last read of the RNGA Status Register. */
#define LDD_RNG_STATUS_ERR_INT_PENDING 0x08U /* Error interrupt pending */
#define LDD_RNG_STATUS_SLEEP_MODE 0x10U /* Sleep mode enabled */

typedef enum {                         /* RNGA sleep mode */
  LDD_RNG_SLEEP_ENABLED,               /* RNGA is in sleep mode */
  LDD_RNG_SLEEP_DISABLED               /* RNGA is running */
} LDD_RNG_TSleepMode;

/*
** ===================================================================
** DryIce device types and constants
** ===================================================================
*/

#define LDD_DRY_ON_TAMPER_DETECTED  0x01U /* OnTamperDetected event mask */

/* Tamper flags */
#define LDD_DRY_TIME_OVERFLOW       0x04U /* RTC time overflow has occurred. */
#define LDD_DRY_MONOTONIC_OVERFLOW  0x08U /* RTC monotonic overflow has occurred. */
#define LDD_DRY_VOLTAGE_TAMPER      0x10U /* VBAT voltage is outside of the valid range. */
#define LDD_DRY_CLOCK_TAMPER        0x20U /* The 32.768 kHz clock source is outside the valid range. */
#define LDD_DRY_TEMPERATURE_TAMPER  0x40U /* The junction temperature is outside of specification. */
#define LDD_DRY_SECURITY_TAMPER     0x80U /* The (optional) security module asserted its tamper detect. */
#define LDD_DRY_FLASH_SECURITY      0x0100U /* The flash security is disabled. */
#define LDD_DRY_TEST_MODE           0x0200U /* Any test mode has been entered. */
/* Tamper flags indicating that the pin does not equal its expected value and was not filtered by the glitch filter (if enabled). */
#define LDD_DRY_TAMPER_PIN_0        0x00010000U
#define LDD_DRY_TAMPER_PIN_1        0x00020000U
#define LDD_DRY_TAMPER_PIN_2        0x00040000U
#define LDD_DRY_TAMPER_PIN_3        0x00080000U
#define LDD_DRY_TAMPER_PIN_4        0x00100000U
#define LDD_DRY_TAMPER_PIN_5        0x00200000U
#define LDD_DRY_TAMPER_PIN_6        0x00400000U
#define LDD_DRY_TAMPER_PIN_7        0x00800000U

#define LDD_DRY_SECURE_KEY_WORD_0  0x01U /* Secure key word 0 mask */
#define LDD_DRY_SECURE_KEY_WORD_1  0x02U /* Secure key word 1 mask */
#define LDD_DRY_SECURE_KEY_WORD_2  0x04U /* Secure key word 2 mask */
#define LDD_DRY_SECURE_KEY_WORD_3  0x08U /* Secure key word 3 mask */
#define LDD_DRY_SECURE_KEY_WORD_4  0x10U /* Secure key word 4 mask */
#define LDD_DRY_SECURE_KEY_WORD_5  0x20U /* Secure key word 5 mask */
#define LDD_DRY_SECURE_KEY_WORD_6  0x40U /* Secure key word 6 mask */
#define LDD_DRY_SECURE_KEY_WORD_7  0x80U /* Secure key word 7 mask */

/*
** ===================================================================
** NFC device types and constants
** ===================================================================
*/

/* Events' masks */
#define LDD_NFC_ON_CMD_ERROR               0x01U /* OnCmdError event mask */
#define LDD_NFC_ON_CMD_DONE                0x02U /* OnCmdDone event mask */

/* Pins' masks */
#define LDD_NFC_CE0_PIN                    0x01U /* CE0 pin mask */
#define LDD_NFC_RB0_PIN                    0x02U /* RB0 pin mask */
#define LDD_NFC_CE1_PIN                    0x04U /* CE1 pin mask */
#define LDD_NFC_RB1_PIN                    0x08U /* RB1 pin mask */
#define LDD_NFC_CE2_PIN                    0x10U /* CE2 pin mask */
#define LDD_NFC_RB2_PIN                    0x20U /* RB2 pin mask */
#define LDD_NFC_CE3_PIN                    0x40U /* CE3 pin mask */
#define LDD_NFC_RB3_PIN                    0x80U /* RB3 pin mask */
#define LDD_NFC_ALE_PIN                    0x0100U /* ALE pin mask */
#define LDD_NFC_CLE_PIN                    0x0200U /* CLE pin mask */
#define LDD_NFC_RE_PIN                     0x0400U /* RE pin mask */
#define LDD_NFC_WE_PIN                     0x0800U /* WE pin mask */
#define LDD_NFC_D0_PIN                     0x00010000U /* D0 pin mask */
#define LDD_NFC_D1_PIN                     0x00020000U /* D1 pin mask */
#define LDD_NFC_D2_PIN                     0x00040000U /* D2 pin mask */
#define LDD_NFC_D3_PIN                     0x00080000U /* D3 pin mask */
#define LDD_NFC_D4_PIN                     0x00100000U /* D4 pin mask */
#define LDD_NFC_D5_PIN                     0x00200000U /* D5 pin mask */
#define LDD_NFC_D6_PIN                     0x00400000U /* D6 pin mask */
#define LDD_NFC_D7_PIN                     0x00800000U /* D7 pin mask */
#define LDD_NFC_D8_PIN                     0x01000000U /* D8 pin mask */
#define LDD_NFC_D9_PIN                     0x02000000U /* D9 pin mask */
#define LDD_NFC_D10_PIN                    0x04000000U /* D10 pin mask */
#define LDD_NFC_D11_PIN                    0x08000000U /* D11 pin mask */
#define LDD_NFC_D12_PIN                    0x10000000U /* D12 pin mask */
#define LDD_NFC_D13_PIN                    0x20000000U /* D13 pin mask */
#define LDD_NFC_D14_PIN                    0x40000000U /* D14 pin mask */
#define LDD_NFC_D15_PIN                    0x80000000U /* D15 pin mask */

typedef uint32_t LDD_NFC_TTargetID;

typedef enum {
  LDD_NFC_CMD_NONE            = 0x00U, /* No command */
  LDD_NFC_CMD_RESET           = 0x01U, /* Reset command */
  LDD_NFC_CMD_ERASE           = 0x02U, /* Erase command */
  LDD_NFC_CMD_READ_ID         = 0x03U, /* Read ID command */
  LDD_NFC_CMD_READ_PAGES      = 0x04U, /* Read pages command */
  LDD_NFC_CMD_WRITE_PAGES     = 0x05U, /* Write pages command */
  LDD_NFC_CMD_ERASE_BLOCKS    = 0x06U, /* Erase page command */
  LDD_NFC_CMD_READ_RAW_PAGE   = 0x07U, /* Read raw page command */
  LDD_NFC_CMD_WRITE_RAW_PAGE  = 0x08U  /* Write raw page command */
} LDD_NFC_TeCmd;

/*
** ===================================================================
** LCDC device types and constants
** ===================================================================
*/

#define LDD_LCDC_ON_ERROR 0x01U        /* OnError event mask */
#define LDD_LCDC_ON_START_OF_FRAME 0x02U /* OnStartOfFrame event mask */
#define LDD_LCDC_ON_END_OF_FRAME 0x04U /* OnEndOfFrame event mask */

#define LDD_LCDC_NO_ERR 0x00U          /* No error */
#define LDD_LCDC_PLANE_0_UNDERRUN_ERR 0x01U /* Plane 0 underrurn error */
#define LDD_LCDC_PLANE_1_UNDERRUN_ERR 0x02U /* Plane 1 underrurn error */

#define LDD_LCDC_REVERSED_VERTICAL_SCAN 0x8000U /* Enable reversed vertical scan (flip along x-axis) */

typedef struct {
  LDD_TData *Address;                  /* Bitmap starting address */
  uint16_t Width;                      /* Bitmap width  */
  uint16_t Height;                     /* Bitmap height */
  uint16_t Format;                     /* Bitmap format */
} LDD_LCDC_TBitmap;

typedef struct {
  uint16_t X;                          /* Window position in bitmap - X */
  uint16_t Y;                          /* Window position in bitmap - Y */
  uint16_t Width;                      /* Window width */
  uint16_t Height;                     /* Window height */
} LDD_LCDC_TWindow;

typedef enum {
  LDD_LCDC_DISABLED = 0,               /* Cursor disabled */
  LDD_LCDC_ALWAYS_1,                   /* Cursor 1''s, monochrome display only. */
  LDD_LCDC_ALWAYS_0,                   /* Cursor 0''s, monochrome display only. */
  LDD_LCDC_COLOR,                      /* Defined cursor color, color display only. */
  LDD_LCDC_INVERTED,                   /* Inverted background, monochrome display only. */
  LDD_LCDC_INVERTED_COLOR,             /* Inverted cursor color, color display only. */
  LDD_LCDC_AND,                        /* Cursor color AND backgroun, color display only. */
  LDD_LCDC_OR,                         /* Cursor color OR backgroun, color display only. */
  LDD_LCDC_XOR
} LDD_LCDC_CursorOperation;

typedef enum {
  LDD_LCDC_PLANE_COMMON,               /* Common for all planes */
  LDD_LCDC_PLANE_0,                    /* Plane (layer) 0 */
  LDD_LCDC_PLANE_1                     /* Plane (layer) 1 */
} LDD_LCDC_TPlaneID;


/*
** ===================================================================
** Interrupt vector constants
** ===================================================================
*/
#define LDD_ivIndex_INT_Initial_Stack_Pointer   0x00u
#define LDD_ivIndex_INT_Initial_Program_Counter 0x01u
#define LDD_ivIndex_INT_NMI                     0x02u
#define LDD_ivIndex_INT_Hard_Fault              0x03u
#define LDD_ivIndex_INT_Reserved4               0x04u
#define LDD_ivIndex_INT_Reserved5               0x05u
#define LDD_ivIndex_INT_Reserved6               0x06u
#define LDD_ivIndex_INT_Reserved7               0x07u
#define LDD_ivIndex_INT_Reserved8               0x08u
#define LDD_ivIndex_INT_Reserved9               0x09u
#define LDD_ivIndex_INT_Reserved10              0x0Au
#define LDD_ivIndex_INT_SVCall                  0x0Bu
#define LDD_ivIndex_INT_Reserved12              0x0Cu
#define LDD_ivIndex_INT_Reserved13              0x0Du
#define LDD_ivIndex_INT_PendableSrvReq          0x0Eu
#define LDD_ivIndex_INT_SysTick                 0x0Fu
#define LDD_ivIndex_INT_DMA0                    0x10u
#define LDD_ivIndex_INT_DMA1                    0x11u
#define LDD_ivIndex_INT_DMA2                    0x12u
#define LDD_ivIndex_INT_DMA3                    0x13u
#define LDD_ivIndex_INT_Reserved20              0x14u
#define LDD_ivIndex_INT_FTFA                    0x15u
#define LDD_ivIndex_INT_LVD_LVW                 0x16u
#define LDD_ivIndex_INT_LLW                     0x17u
#define LDD_ivIndex_INT_I2C0                    0x18u
#define LDD_ivIndex_INT_I2C1                    0x19u
#define LDD_ivIndex_INT_SPI0                    0x1Au
#define LDD_ivIndex_INT_SPI1                    0x1Bu
#define LDD_ivIndex_INT_UART0                   0x1Cu
#define LDD_ivIndex_INT_UART1                   0x1Du
#define LDD_ivIndex_INT_UART2                   0x1Eu
#define LDD_ivIndex_INT_ADC0                    0x1Fu
#define LDD_ivIndex_INT_CMP0                    0x20u
#define LDD_ivIndex_INT_TPM0                    0x21u
#define LDD_ivIndex_INT_TPM1                    0x22u
#define LDD_ivIndex_INT_TPM2                    0x23u
#define LDD_ivIndex_INT_RTC                     0x24u
#define LDD_ivIndex_INT_RTC_Seconds             0x25u
#define LDD_ivIndex_INT_PIT                     0x26u
#define LDD_ivIndex_INT_Reserved39              0x27u
#define LDD_ivIndex_INT_USB0                    0x28u
#define LDD_ivIndex_INT_DAC0                    0x29u
#define LDD_ivIndex_INT_TSI0                    0x2Au
#define LDD_ivIndex_INT_MCG                     0x2Bu
#define LDD_ivIndex_INT_LPTimer                 0x2Cu
#define LDD_ivIndex_INT_Reserved45              0x2Du
#define LDD_ivIndex_INT_PORTA                   0x2Eu
#define LDD_ivIndex_INT_PORTD                   0x2Fu

/*
** ===================================================================
** Function prototypes
** ===================================================================
*/

/*
** ===================================================================
**     Method      :  PE_FillMemory (component MKL25Z128LK4)
**
**     Description :
**         Fill the memory area by specified value.
** ===================================================================
*/
void PE_FillMemory(register void* SourceAddressPtr, register uint8_t c, register uint32_t len);

/*
** ===================================================================
**     Method      :  PE_PeripheralUsed (component MKL25Z128LK4)
**
**     Description :
**         Returns the information whether a peripheral is allocated by 
**         PE or not.
** ===================================================================
*/
bool PE_PeripheralUsed(uint32_t PrphBaseAddress);

/*
** ===================================================================
**     Method      :  LDD_SetClockConfiguration (component MKL25Z128LK4)
**
**     Description :
**         This method changes the clock configuration of all LDD 
**         components in the project.
** ===================================================================
*/
void LDD_SetClockConfiguration(LDD_TClockConfiguration ClockConfiguration);

/* END PE_LDD. */

#include "CsIO1.h"
#include "IO1.h"
#include "TU1.h"
#include "GPIO1.h"


#endif
/* __PE_LDD_H */
