#!/usr/bin/python
# -*- coding: utf-8 -*-

import urllib
import urllib2
import cookielib
import re

from BeautifulSoup import BeautifulSoup 

class OtpAuthError(Exception):
    def __init__(self, value):
        self.value = value
    def __str__(self):
        return repr(self.value)

class Otp(object):
    url = "http://magazine.sourceforge.jp/login.pl"
    edit_url = "http://magazine.sourceforge.jp/admin.pl?op=edit&sid="
    fileadmin_url = "http://magazine.sourceforge.jp/fileadmin.pl?op=editBySid&sid="
    form_data = { 'op':'userlogin',
             'unickname':'',
             'upasswd':'',
             'userlogin':'ログイン',
              }
    headers = {
        'User-Agent':'Mozilla/5.0 (Windows; U; Windows NT 6.0; ja; rv:1.9.0.1) Gecko/2008070208 Firefox/3.0.1',
        }
    def __init__(self):
        self.opener = None
        self.cookiejar = None
        self._rcache = None
        self._cached_url = ""

    def login(self, uname, passwd):
        data = dict(self.form_data)
        data['unickname'] = uname
        data['upasswd'] = passwd
        encoded_data = urllib.urlencode(data)
        req = urllib2.Request(self.url, encoded_data, self.headers)
        self.cookiejar = cookielib.CookieJar()
        self.opener = urllib2.build_opener(urllib2.HTTPCookieProcessor(self.cookiejar))
        resp = self.opener.open(req)

        for c in self.cookiejar:
            if c.name == 'user':
                if c.value:
                    return
        self.opener = None
        self.cookiejar = None
        raise OtpAuthError('login failed')

    def _read(self, url):
        if self.opener:
            resp = self.opener.open(url)
            return resp.read()
        else:
            raise OtpAuthError('not logined')

    def reset_cache(self):
        self._cached_url = ""
        self._racache = None

    def _fetch_edit(self, sid):
        url = self.edit_url + sid
        if self._cached_url != url:
            self._rcache = self._read(url)
            self._cached_url = url
            self._bsp = BeautifulSoup(self._rcache)

    def _fetch_fileadmin(self, sid):
        url = self.fileadmin_url + sid
        if self._cached_url != url:
            self._rcache = self._read(url)
            self._cached_url = url
            self._bsp = BeautifulSoup(self._rcache)

    def get_imagelist(self, sid):
        self._fetch_fileadmin(sid)
        elems = self._bsp.findAll('a')
        rex = re.compile(r"^\/\/magazine.sourceforge.jp\/blob.pl\?id=(.*)$")
        imagelist = []
        for elem in elems:
            href = elem.get("href", "")
            if href:
                m = rex.match(href)
                if m:
                    blob = m.group(1)
                    fname = elem.contents[0]
                    imagelist.append((blob, fname))
        return imagelist

    def get_intro(self, sid):
        self._fetch_edit(sid)
        t = self._bsp.find('textarea', dict(name='introtext')).contents[0]
        return self.replace_entity(t)

    def get_bodytext(self, sid):
        self._fetch_edit(sid)
        t = self._bsp.find('textarea', dict(name='bodytext')).contents[0]
        return self.replace_entity(t)

    def get_title(self, sid):
        self._fetch_edit(sid)
        t = self._bsp.find('input', dict(name='title'))['value']
        return self.replace_entity(t)

    def replace_entity(self, text):
        t = text
        t = t.replace('&gt;', '>')
        t = t.replace('&lt;', '<')
        t = t.replace('&amp;', '&')
        return t.encode('utf-8')
