package jp.operation.structure;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

import jp.operation.structure.trie.BasicTrieTree;
import jp.operation.structure.trie.Word;
import jp.operation.structure.trie.Words;

import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicTrieTreeTest {

	private static Logger log = LoggerFactory.getLogger(BasicTrieTreeTest.class);

	private static BasicTrieTree tree;
	private static String encode = "utf-8";

	@BeforeClass
	public static void build() throws IOException {
		tree = new BasicTrieTree();
		Words words = new Words();
		InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("_dicdata");
		BufferedReader br = new BufferedReader(new InputStreamReader(is, encode));
		while (br.ready()) {
			String line = br.readLine();
			words.add(line);
		}
		br.close();
		log.info(" build start ");
		tree.build(words);
	}

	@Test
	public void testExtract() throws IOException {

		InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("spamdata");
		BufferedReader br = new BufferedReader(new InputStreamReader(is, encode));
		while (br.ready()) {
			String line = br.readLine();
			List<Word> list = new ArrayList<Word>();
			tree.extractWords(list, line, true);
			String str = "";
			for (Word word : list)
				str += word.getWord() + ",";
			log.info(str);
		}
		br.close();

	}

}
