package jp.operation.stat;

import junit.framework.Assert;
import junit.framework.TestCase;

import org.junit.Test;

public class VarianceTest extends TestCase {
	
	@Test
	public void testIncrement() {
		
		Variance variance = new Variance();
		variance.increment(1d);
		variance.increment(2d);
		variance.increment(3d);
		variance.increment(4d);
		variance.increment(5d);
		Assert.assertEquals(10d / 4d, variance.getUnbiasedVariance());
		Assert.assertEquals(Math.sqrt(10d / 4d), variance.getStandardDeviation());
		Assert.assertEquals(Math.sqrt(10d / 4d) / 3d, variance.getCoefficientOfVariation());

	}

	
}
