package jp.operation.sort;

import java.util.Random;

import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * クイックソート
 * 特徴
 *  O = n*log(n)
 *  最悪の計算量は O = n^2になる
 *
 * @author yasuda
 *
 */
public class QuickSortTest {

	private static final Logger log = LoggerFactory.getLogger(QuickSortTest.class);

	private static final int N = 1000;	// データ件数
	private static int[] sort = new int[N];

	/**
	 * ソート用データ生成
	 */
	@Before
	public void setup() {

		Random random = new Random();
		log.debug("クイックソート準備");
		StringBuilder progress = new StringBuilder();
		for(int i = 0; i < N; i++) {
			sort[i] = random.nextInt(1000);
			progress.append(sort[i] + " ");
		}
		log.debug(progress.toString());
		
	}
	
	@Test
	public void testQuickSort() {
		
		log.debug("ソート開始");
		QuickSort qSort = new QuickSort();
		qSort.sort(sort);
		StringBuilder progress = new StringBuilder();
		for(int i = 0; i < N; i++) {
			progress.append(sort[i] + " ");
		}
		log.debug(progress.toString());

	}

}
