package jp.operation.sort;

import java.util.Random;

import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * マージソート
 * 特徴
 *  O = n*log(n)
 *  最悪の計算量も n*log(n)で、安定ソートだが、O(n)の外部記憶(メモリ)を必要とする
 *
 * @author yasuda
 *
 */
public class MergeSortTest {

	private static final Logger log = LoggerFactory.getLogger(MergeSortTest.class);

	private static final int N = 100;	// データ件数
	private static int[] sort = new int[N];

	/**
	 * ソート用データ生成
	 */
	@Before
	public void setup() {

		Random random = new Random();
		log.debug("マージソート準備");
		StringBuilder progress = new StringBuilder();
		for(int i = 0; i < N; i++) {
			sort[i] = random.nextInt(1000);
			progress.append(sort[i] + " ");
		}
		log.debug(progress.toString());
		
	}
	
	@Test
	public void testQuickSort() {
		
		log.debug("ソート開始");
		MergeSort mergeSort = new MergeSort();
		mergeSort.sort(sort);
		StringBuilder progress = new StringBuilder();
		for(int i = 0; i < N; i++) {
			progress.append(sort[i] + " ");
		}
		log.debug(progress.toString());

	}

}
