package jp.operation.sort;

import java.util.Random;

import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 単純挿入ソート（基本挿入法）テスト
 * 特徴
 *  O = n^2
 *  整列してある配列に追加要素を適切な場所に挿入する。
 *  ほとんど整列されたデータに対しては高速。
 * 
 * @author yasuda
 *
 */
public class InsertionSortTest {

	private static final Logger log = LoggerFactory.getLogger(InsertionSortTest.class);

	private static final int N = 100;	// データ件数
	private static int[] sort = new int[N];

	/**
	 * ソート用データ生成
	 */
	@Before
	public void setup() {

		Random random = new Random();
		log.debug("挿入ソート準備");
		StringBuilder progress = new StringBuilder();
		for(int i = 0; i < N; i++) {
			sort[i] = random.nextInt(1000);
			progress.append(sort[i] + " ");
		}
		log.debug(progress.toString());
		
	}
	
	@Test
	public void testInsertionSort() {
		
		log.debug("ソート開始");
		InsertionSort.sort(sort);
		StringBuilder progress = new StringBuilder();
		for(int i = 0; i < N; i++) {
			progress.append(sort[i] + " ");
		}
		log.debug(progress.toString());

	}

}