package jp.operation.sort;

import java.util.Random;

import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 2分挿入ソートテスト
 * 特徴
 *  O = n^2
 *  単純挿入ソートの改良版
 *  挿入箇所を探す処理にリニアサーチではなく、バイナリサーチを適用
 * 
 * @author yasuda
 *
 */
public class InsertionBinarySortTest {

	private static final Logger log = LoggerFactory.getLogger(InsertionBinarySortTest.class);

	private static final int N = 10;	// データ件数
	private static int[] sort = new int[N];

	/**
	 * ソート用データ生成
	 */
	@Before
	public void setup() {

		Random random = new Random();
		log.debug("2分挿入ソート準備");
		StringBuilder progress = new StringBuilder();
		for(int i = 0; i < N; i++) {
			sort[i] = random.nextInt(1000);
			progress.append(sort[i] + " ");
		}
		log.debug(progress.toString());
		
	}
	
	@Test
	public void testInsertionBinarySort() {
		
		log.debug("ソート開始");
		InsertionBinarySort.sort(sort);
		StringBuilder progress = new StringBuilder();
		for(int i = 0; i < N; i++) {
			progress.append(sort[i] + " ");
		}
		log.debug(progress.toString());

	}

}