package jp.operation.sort;

import java.util.Random;

import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * コームソートテスト
 * 特徴
 *  O = n*log(n)
 *  バブルソートでは隣り合った要素同士を交換するが、コームソートでは少し離れた要素同士を交換し、徐々に比較する距離（ギャップ）を縮めていく
 *  1回の比較ごとにギャップを縮める度合いを「収縮率」といい、この値によってパフォーマンスが変わってくる。
 *  経験的に収縮率は1.3が良いといわれている。
 *
 * @author yasuda
 *
 */
public class CombSortTest {

	private static final Logger log = LoggerFactory.getLogger(CombSortTest.class);

	private static final int N = 100;	// データ件数
	private static int[] sort = new int[N];

	/**
	 * ソート用データ生成
	 */
	@Before
	public void setup() {

		Random random = new Random();
		log.debug("コームソート準備");
		StringBuilder progress = new StringBuilder();
		for(int i = 0; i < N; i++) {
			sort[i] = random.nextInt(1000);
			progress.append(sort[i] + " ");
		}
		log.debug(progress.toString());
		
	}
	
	@Test
	public void testCombSort() {
		
		log.debug("ソート開始");
		CombSort.sort(sort);
		StringBuilder progress = new StringBuilder();
		for(int i = 0; i < N; i++) {
			progress.append(sort[i] + " ");
		}
		log.debug(progress.toString());

	}

}