package jp.operation.sort;

import java.util.Random;

import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * バブルソートテスト
 * 特徴
 *  O = n^2
 *  後方の配列要素は確実にソート済みになる
 *
 * @author yasuda
 *
 */
public class BubbleSortTest {

	private static final Logger log = LoggerFactory.getLogger(BubbleSortTest.class);

	private static final int N = 100;	// データ件数
	private static int[] sort = new int[N];

	/**
	 * ソート用データ生成
	 */
	@Before
	public void setup() {

		Random random = new Random();
		log.debug("バブルソート準備");
		StringBuilder progress = new StringBuilder();
		for(int i = 0; i < N; i++) {
			sort[i] = random.nextInt(1000);
			progress.append(sort[i] + " ");
		}
		log.debug(progress.toString());
		
	}
	
	@Test
	public void testBubbleSort() {
		
		log.debug("ソート開始");
		BubbleSort.sort(sort);
		StringBuilder progress = new StringBuilder();
		for(int i = 0; i < N; i++) {
			progress.append(sort[i] + " ");
		}
		log.debug(progress.toString());

	}

}
