package jp.operation.math;

import junit.framework.Assert;

import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 基本的な数学処理のテスト
 *  
 * @author yasuda_masahiro
 *
 */
public class BasicMathTest {

	private static final Logger log = LoggerFactory.getLogger(BasicMathTest.class);

	private static int[] GCD_TEST = {15, 30, 20};
	private static int GCD_ANSWER = 5;

	/**
	 * テスト用データ生成
	 */
	@Before
	public void setup() {

		log.debug("GCDテスト準備");
		StringBuilder progress = new StringBuilder();
		for(int i = 0; i < GCD_TEST.length; i++) {
			progress.append(GCD_TEST[i] + " ");
		}
		log.debug(progress.toString());
		
	}
	
	@Test
	public void testBinarySearch() {
		
		log.debug("answer:" + BasicMath.gcd(GCD_TEST));
		Assert.assertEquals(GCD_ANSWER, BasicMath.gcd(GCD_TEST));

	}

}