package jp.operation.distance.vector;

import jp.operation.distance.vector.Euclidean;
import junit.framework.Assert;

import org.apache.commons.math.linear.BlockRealMatrix;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.util.MathUtils;
import org.junit.Before;
import org.junit.Test;

public class EuclideanTest {

	// 2次元の場合
	private double[] p1 = {2,2};
	private double[] p2 = {4,4};

	// 3次元の場合
	private double[] p3 = {1,1,1};
	private double[] p4 = {2,2,2};

	@Before
	public void setup() {
		
	}
	
	@Test
	public void testEuclidean() {

		Assert.assertEquals(2*Math.sqrt(2), Euclidean.distance2(p1, p2));
		Assert.assertEquals(Math.sqrt(3), Euclidean.distance2(p3, p4));

		// math
		Assert.assertEquals(2*Math.sqrt(2), MathUtils.distance(p1, p2));
		Assert.assertEquals(Math.sqrt(3), MathUtils.distance(p3, p4));
		
		System.out.println();
		System.out.println("Standard Euclidean Distance");
		System.out.println("{2,2},{4,4} - "  + Euclidean.standardDistance2(p1, p2));
		System.out.println("{1,1,1},{2,2,2} - "  + Euclidean.standardDistance2(p3, p4));

		// mathでやるには拡張が必要かも
	}

}
