package jp.operation.distance.vector;

import jp.operation.distance.vector.Chebyshev;
import jp.operation.distance.vector.Euclidean;
import jp.operation.distance.vector.Manhattan;

import org.apache.commons.math.DimensionMismatchException;
import org.junit.Before;
import org.junit.Test;

public class DistanceTest {

	// 2次元の場合
	private double[] p1 = {2d,2d};
	private double[] p2 = {4d,4d};

	// 3次元の場合
	private double[] p3 = {1.5d,1d,3.5d};
	private double[] p4 = {7.1d,5.1d,6.3d};

	private double[] p5 = {1d,1d,1d};
	private double[] p6 = {2d,2d,2d};

	@Before
	public void setup() {
		
	}
	
	@Test
	public void testDistance() throws DimensionMismatchException {

		System.out.println("{2,2} - {4,4}");
		System.out.println("Manhattan - " + Manhattan.distance1(p1, p2));
		System.out.println("Euclidean - " + Euclidean.distance2(p1, p2));
		System.out.println("Chebyshev - " + Chebyshev.distanceInf(p1, p2));
//		System.out.println("Mahalanobis - " + Mahalanobis.distance(p1, p2));

		System.out.println();
		System.out.println("{1,1,1} - {2,2,2}");
		System.out.println("Manhattan - " + Manhattan.distance1(p3, p4));
		System.out.println("Euclidean - " + Euclidean.distance2(p3, p4));
		System.out.println("Chebyshev - " + Chebyshev.distanceInf(p3, p4));
//		System.out.println("Mahalanobis - " + Mahalanobis.distance(p3, p4));

	}

}
