package jp.operation.distance.vector;

import jp.operation.distance.vector.Chebyshev;
import junit.framework.Assert;

import org.apache.commons.math.util.MathUtils;
import org.junit.Before;
import org.junit.Test;

public class ChebyshevTest {

	// 2次元の場合
	private int[] p1 = {2,2};
	private int[] p2 = {4,4};

	// 3次元の場合
	private int[] p3 = {1,1,1};
	private int[] p4 = {2,2,2};

	@Before
	public void setup() {
		
	}
	
	@Test
	public void testEuclidean() {
		
		Assert.assertEquals(2, Chebyshev.distanceInf(p1, p2));
		Assert.assertEquals(1, Chebyshev.distanceInf(p3, p4));

		// math
		Assert.assertEquals(2, MathUtils.distanceInf(p1, p2));
		Assert.assertEquals(1, MathUtils.distanceInf(p3, p4));

	}

}
