package jp.operation.distance.string;

import java.util.ArrayList;
import java.util.List;

import junit.framework.Assert;

import org.junit.Before;
import org.junit.Test;

public class LevenshteinTest {

	private List<Object[]> testData;

	@Before
	public void setup() {
		Object[][] param = {
				{1, "伊藤直也", "伊藤直哉"},
				{1, "伊藤直", "伊藤直也"},
				{2, "佐藤直哉", "伊藤直也"},
				{3, "佐藤B作", "伊藤直也"}
		};

		testData = new ArrayList<Object[]>();
		for(int i = 0; i < param.length; i++) {
			testData.add(param[i]);
		}
	}

	@Test
	public void testLevenshteinDistance() {

		for(Object[] param : testData) {
			Assert.assertEquals(param[0], Levenshtein.distance(param[1].toString(), param[2].toString()));
		}
	}

}
