package jp.operation.structure.trie;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class Words implements Iterable<Word>, Serializable {

	private static final long serialVersionUID = 5064048349483504261L;

	private List<Word> wordSet;

	private AtomicInteger counter = new AtomicInteger();

	public Words() {
		wordSet = new ArrayList<Word>();
	}

	public Words(List<Word> wordSet) {
		this.wordSet = wordSet;
	}

	public List<Word> getWordSet() {
		return wordSet;
	}

	public void setWordSet(List<Word> wordSet) {
		this.wordSet = wordSet;
	}

	public void allAdd(String[] words) {
		for (String word : words)
			add(word);
	}

	public void add(String word) {
		wordSet.add(new Word(word, counter.getAndIncrement()));
	}

	public int size() {
		return wordSet.size();
	}

	@Override
	public Iterator<Word> iterator() {
		return wordSet.iterator();
	}

	public AtomicInteger getWordIDCounter() {
		return counter;
	}

}
