package jp.operation.structure.trie;

public class Word {

	private int id;
	private String word;

	public Word(String word, int id) {
		this.id = id;
		this.word = word;
	}

	public int getId() {
		return id;
	}

	public String getWord() {
		return word;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public void setWord(String word) {
		this.word = word;
	}

	@Override
	protected Word clone() throws CloneNotSupportedException {
		Word word = new Word(this.word, this.id);
		word.setId(this.id);
		return word;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + id;
		result = prime * result + ((word == null) ? 0 : word.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Word other = (Word) obj;
		if (id != other.id)
			return false;
		if (word == null) {
			if (other.word != null)
				return false;
		} else if (!word.equals(other.word))
			return false;
		return true;
	}

}