package jp.operation.stat;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * copy from commons-math
 * unbiased variance = sum((x_i - mean)^2) / (n - 1)
 * sample variance = sum((x_i - mean)^2) / n
 * 
 * 標準偏差、変動係数には、不偏分散を利用
 * 
 * @author yasuda_masahiro
 *
 */
public class Variance extends Mean {

	private static final Logger log = LoggerFactory.getLogger(Variance.class);

	protected double variance;

    public void increment(final double d) {
        if (num < 1) {
            mean = variance = 0d;
        }
        super.increment(d);
        variance += ((double) num - 1) * normalizedDeviation * deviation;

        log.debug("variance+="
   					+ (num-1) + "*" + normalizedDeviation + "*" + deviation
   					+ "  -> " + variance
   					+ ",  standardDeviation -> " + getStandardDeviation()
   					+ ",  unbiasedVariance -> " + getUnbiasedVariance()
   					+ ",  coefficiantOfVariation -> " + getCoefficientOfVariation());
    }

    public double getSampleVariance() {
    	return variance / num;
    }

    public double getUnbiasedVariance() {
    	return variance / (num - 1);
    }

    public double getStandardDeviation() {
    	return Math.sqrt(getUnbiasedVariance());
    }
    
    public double getCoefficientOfVariation() {
    	return getStandardDeviation() / getMean();
    }
}
