package jp.operation.stat;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * copy from commons-math
 * mean = sum(x_i) / n
 * 
 * @author yasuda_masahiro
 *
 */
public class Mean {

	private static final Logger log = LoggerFactory.getLogger(Mean.class);

	protected int num;						// データ数
	protected double mean;					// 平均
	protected double deviation;				// 偏差
	protected double normalizedDeviation;	// 正規化偏差
	
    public void increment(final double d) {
        if (num == 0) {
        	mean = 0d;
        }
        num++;
        double n0 = num;
        deviation = d - mean;
        normalizedDeviation = deviation / n0;
        mean += normalizedDeviation;
        
        log.debug("mean=" + mean);
    }
    
    public double getMean() {
    	return mean;
    }
    
}
