package jp.operation.sort;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * クイックソート
 * 特徴
 *  O = n*log(n)
 *  最悪の計算量は O = n^2になる
 *
 * @author Yasuda
 *
 */
public class QuickSort {

	private static final Logger log = LoggerFactory.getLogger(QuickSort.class);

	private int step = 0;
	private int loop = 0;

	public void sort(int[] data) {
		
		// 初期化
		int bottom = 0;
		int top = data.length - 1;
		
		quickSort(bottom, top, data);
		log.debug("ソート終了 step:" + step);

	}
	
	private void quickSort(int bottom, int top, int[] data) {

		int N = data.length;
		int lower, upper = 0;
		if(bottom >= top)
			return;

		// 先頭の値を「適当な値」とする
		int div = data[bottom];
		for(lower = bottom, upper = top; lower < upper;) {

			log.debug("bottom=" + bottom + "(センターの値" + data[bottom] + "), top=" + top + ", lower=" + lower + ", upper=" + upper);
			while(lower <= upper && data[lower] <= div) {
				lower++;
				step++;
			}
			while(lower <= upper && data[upper] > div) {
				upper--;
				step++;
			}

			if(lower < upper) {
				int temp = data[lower];
				data[lower] = data[upper];
				data[upper] = temp;
			} else {
				break;
			}

			StringBuilder progress = new StringBuilder();
			for(int i = 0; i < N; i++) {
				progress.append(data[i] + " ");
			}
			log.debug(progress.toString());

		}

		// 最初に選択した値を中央に移動する
		int temp = data[bottom];
		data[bottom] = data[upper];
		data[upper] = temp;

		StringBuilder progress = new StringBuilder();
		for(int i = 0; i < N; i++) {
			progress.append(data[i] + " ");
		}
		log.debug(progress.toString());
		log.debug(++loop + "ループ終了");

		quickSort(bottom, upper - 1, data);
		quickSort(upper + 1, top, data);
	}

}
