package jp.operation.sort;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 単純挿入ソート（基本挿入法）
 * 特徴
 *  O = n^2
 *  整列してある配列に追加要素を適切な場所に挿入する。
 *  ほとんど整列されたデータに対しては高速。
 *
 * @author yasuda
 *
 */
public class InsertionSort {

	private static final Logger log = LoggerFactory.getLogger(InsertionSort.class);
	
	public static void sort(int[] sort) {

		int step = 0;
		int N = sort.length;		// データ件数

		// すべてがソート済みになるまで繰り返す
		for(int sorted = 0; sorted < N - 1; ++sorted) {

			int checkNum = sort[sorted + 1];			// ソート済み領域の直後の値
			// 挿入箇所を探す（リニアサーチ）
			int insertPlace = 0;
			for(insertPlace = 0; insertPlace <= sorted; ++insertPlace) {
				if(sort[insertPlace] > checkNum) break;
				step++;
			}
			
			// checkNumを挿入した後、insertPlace以降の値を繰り上げていく
			while(insertPlace <= sorted + 1) {
				int temp = sort[insertPlace];
				sort[insertPlace] = checkNum;
				checkNum = temp;
				insertPlace++;
				
				step++;
			}
			
			StringBuilder progress = new StringBuilder();
			for(int i = 0; i < N; i++) {
				progress.append(sort[i] + " ");
			}
			log.debug(progress.toString());
		}
		log.debug("ソート終了 step:" + step);

	}

}