package jp.operation.sort;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 2分挿入ソート
 * 特徴
 *  O = n^2
 *  単純挿入ソートの改良版
 *  挿入箇所を探す処理にリニアサーチではなく、バイナリサーチを適用
 *
 * @author yasuda
 *
 */
public class InsertionBinarySort {

	private static final Logger log = LoggerFactory.getLogger(InsertionBinarySort.class);
	
	public static void sort(int[] sort) {

		int step = 0;
		int N = sort.length;		// データ件数

		// すべてがソート済みになるまで繰り返す
		for(int sorted = 1; sorted < N; ++sorted) {

			int checkNum = sort[sorted];			// ソート済み領域の直後の値
			// 挿入箇所を探す（バイナリサーチ）
			int left = 0;
			int right = sorted;
			while(left < right) {
				int mid = (left + right) / 2;
				if(sort[mid] < checkNum) {
					left = mid + 1;
				} else {
					right = mid;
				}
				step++;
			}
			int insertPlace = left;

			// checkNumを挿入した後、insertPlace以降の値を繰り上げていく
			while(insertPlace <= sorted) {
				int temp = sort[insertPlace];
				sort[insertPlace] = checkNum;
				checkNum = temp;
				insertPlace++;

				step++;
			}

			StringBuilder progress = new StringBuilder();
			for(int i = 0; i < N; i++) {
				progress.append(sort[i] + " ");
			}
			log.debug(progress.toString());
		}
		log.debug("ソート終了 step:" + step);

	}

}