package jp.operation.sort;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * コームソート
 * 特徴
 *  O = n*log(n)
 *  バブルソートでは隣り合った要素同士を交換するが、コームソートでは少し離れた要素同士を交換し、徐々に比較する距離（ギャップ）を縮めていく
 *  1回の比較ごとにギャップを縮める度合いを「収縮率」といい、この値によってパフォーマンスが変わってくる。
 *  経験的に収縮率は1.3が良いといわれている。
 *
 * @author yasuda
 *
 */
public class CombSort {

	private static final Logger log = LoggerFactory.getLogger(CombSort.class);
	
	private static final float SHRINKAGE;
	static {
		SHRINKAGE = 1f / 1.3f;
	}

	public static void sort(int[] sort) {

		int step = 0;
		boolean flag = false;
		int N = sort.length;		// データ件数
		int gap = N;

		do {
			gap = (int) (gap * SHRINKAGE);
			if(gap == 0) {
				gap = 1;
			}
			log.debug("gap=" + gap);
			
			flag = false;
			for(int i = 0; i < N - gap; ++i) {
				if(sort[i] > sort[i + gap]) {
					// 距離がgapだけ離れた要素を比較し、並びがおかしければ入れ替える
					flag = true;
					int tmp = sort[i];
					sort[i] = sort[i + gap];
					sort[i + gap] = tmp;
				}
				step++;
			}
			
			StringBuilder progress = new StringBuilder();
			for(int i = 0; i < N; i++) {
				progress.append(sort[i] + " ");
			}
			log.debug(progress.toString());
	
		} while(flag || gap > 1);
		log.debug("ソート終了 step:" + step);

	}

}