package jp.operation.sort;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * バブルソート
 * 特徴
 *  O = n^2
 *  後方の配列要素は確実にソート済みになる
 *
 * @author yasuda
 *
 */
public class BubbleSort {

	private static final Logger log = LoggerFactory.getLogger(BubbleSort.class);

	public static void sort(int[] sort) {

		boolean flag = false;
		int N = sort.length;		// データ件数
		int step = 0;

		do {
			flag = false;
			for(int i = 0; i < N - 1; ++i) {
				if(sort[i] > sort[i + 1]) {
					flag = true;
					// 左右の並びがおかしければ入れ替える
					int j = sort[i];
					sort[i] = sort[i + 1];
					sort[i + 1] = j;
				}
				step++;
			}
			
			StringBuilder progress = new StringBuilder();
			for(int i = 0; i < N; i++) {
				progress.append(sort[i] + " ");
			}
			log.debug(progress.toString());
	
		} while(flag);
		log.debug("ソート終了 step:" + step);

	}

}
