package jp.operation.search;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * 番兵を使ったリニアサーチ（順検索、逐次検索）
 * 特徴
 *  O = n
 *  リニアサーチに番兵を用いて、ループ内での条件判断を少なくする
 *
 * @author yasuda
 *
 */
public class LenearSentinelSearch {

	private static final Logger log = LoggerFactory.getLogger(LenearSentinelSearch.class);

	public static int search(int x, int[] list) {

		int step = 0;
		int n = 0;
		// 最後の値をxに置き換え、必ず目的の値が見つかるようにする
		int lastValue = list[list.length - 1];
		list[list.length - 1] = x;

		while(list[n] != x) {
			step++;
			n++;
		}

		// 最後の値を元に戻す
		list[list.length - 1] = lastValue;
		
		// 最後以外で一致、または最後が一致
		if((n < list.length - 1) || (x == lastValue)) {
			log.debug("探索終了 step:" + step);
			return n;
		}
		
		return -1;
		
	}

}
