package jp.operation.search;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * リニアサーチ（順検索、逐次検索）
 * 特徴
 *  O = n
 *  データを一つ一つ順に端から調べるだけ
 *
 * @author yasuda
 *
 */
public class LenearSearch {

	private static final Logger log = LoggerFactory.getLogger(LenearSearch.class);

	public static int search(int x, int[] list) {
		
		int step = 0;
		int n = 0;
		// 目的の値を探す
		while(n < list.length && list[n] != x) {
			step++;
			n++;
		}
		
		if(n < list.length) {
			log.debug("探索終了 step:" + step);
			return n;
		}
		
		return -1;
		
	}

}