package jp.operation.search;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * バイナリサーチ（二分探索）
 * 特徴
 *  O = log(n)
 *  ソート済みのリストや配列に入ったデータに対する検索を行うにあたって、
 *  中央の値を見て、検索したい値との大小関係を用いて、右にあるか、左にあるかを判断して、片側には存在しないことを確かめながら検索していく
 *
 * @author yasuda
 *
 */
public class BinarySearch {

	private static final Logger log = LoggerFactory.getLogger(BinarySearch.class);

	public static int search(int x, int[] list) {
		
		int left = 0;
		int right = list.length - 1;
		int step = 0;

		while(left <= right) {
			int mid = (left + right) / 2;
			if(list[mid] == x) {
				log.debug("探索終了 step:" + step);
				return mid;
			}
			
			if(list[mid] < x) {
				// midより左側にxは存在しない
				left = mid + 1;
			} else {
				// midより右側にxは存在しない
				right = mid - 1;
			}
			step++;
		}

		// 一致するものは存在しなかった
		return -1;
		
	}

}