package jp.operation.math;

/**
 * 基本的な数学処理
 * 
 * @author yasuda_masahiro
 *
 */
public class BasicMath {

	/**
	 * 最大公約数(greatest common divisor)を求めます
	 * 
	 * @param n
	 * @return gcd
	 */
	public static int gcd(int[] n) {
		
		int N = n.length;
		return calculateGcd(n, N);
		
	}
	
	/**
	 * 3つ以上の数値のGCDを計算します
	 * 
	 * @param n
	 * @param use
	 * @return
	 */
	private static int calculateGcd(int[] n, int use) {

		if(use == 2) {
			return innerGcd(n[0], n[1]);
		}
		
		return innerGcd(n[n.length - 1], calculateGcd(n, use - 1));
		
	}

	/**
	 * aとbの最大公約数を求めます
	 * 
	 * @param a
	 * @param b
	 * @return
	 */
	private static int innerGcd(int a, int b) {
		
		for(int i = a; i > 0; i--) {
			if(a % i == 0 && b % i == 0) {
				return i;
			}
		}
		
		return 1;
	}
}
