package jp.operation.distance.vector;

/**
 * copy from commons-math
 * 2点を直線で結ぶのではなく，各時点における1次元の移動だけを許した移動距離であらわしたもの
 * 
 * @author yasuda_masahiro
 *
 */
public class Manhattan implements Minkowski {

    /**
     * Calculates the L<sub>1</sub> (sum of abs) distance between two points.
     *
     * @param p1 the first point
     * @param p2 the second point
     * @return the L<sub>1</sub> distance between the two points
     */
    public static double distance1(double[] p1, double[] p2) {
        double sum = 0;
        for (int i = 0; i < p1.length; i++) {
            sum += Math.abs(p1[i] - p2[i]);
        }
        return sum;
    }

    /**
     * Calculates the L<sub>1</sub> (sum of abs) distance between two points.
     *
     * @param p1 the first point
     * @param p2 the second point
     * @return the L<sub>1</sub> distance between the two points
     */
    public static int distance1(int[] p1, int[] p2) {
      int sum = 0;
      for (int i = 0; i < p1.length; i++) {
          sum += Math.abs(p1[i] - p2[i]);
      }
      return sum;
    }

}
