package jp.operation.distance.string;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Levenshtein Distance
 * http://en.wikipedia.org/wiki/Levenshtein_distance
 * 
 * @author yasuda_masahiro
 * 
 */
public class Levenshtein implements EditDistance {

	private static final Logger log = LoggerFactory.getLogger(Levenshtein.class);

	private static int minimum(int a, int b, int c) {
		return Math.min(Math.min(a, b), c);
	}

	public static int distance(String str1, String str2) {

		str1 = str1.toLowerCase();
		str2 = str2.toLowerCase();
		int[][] distance = new int[str1.length() + 1][str2.length() + 1];

		for (int i = 0; i <= str1.length(); i++) {
			distance[i][0] = i;
		}

		for (int j = 0; j <= str2.length(); j++) {
			distance[0][j] = j;
		}

		for (int i = 1; i <= str1.length(); i++) {
			for (int j = 1; j <= str2.length(); j++) {
				boolean isSame = (str1.charAt(i - 1) == str2.charAt(j - 1));
				distance[i][j] = minimum(
						distance[i - 1][j] + 1,						// 挿入
						distance[i][j - 1] + 1,						// 削除
						distance[i - 1][j - 1] + (isSame ? 0 : 1));	// 文字列が同一なら+0、異なれば+1
			}
		}
		log.debug("distance=" + distance[str1.length()][str2.length()] + "," + str1 + "," + str2);

		return distance[str1.length()][str2.length()];
	}
}
