#include "jp/ggaf/lib/actor/laserchip/HomingLaserChip.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;

HomingLaserChip::HomingLaserChip(const char* prm_name, const char* prm_model, GgafStatus* prm_pStat) :
            LaserChip(prm_name, prm_model, prm_pStat) {
    _class_name = "HomingLaserChip";
    _is_leader = false;

    _begining_x = _x;
    _begining_y = _y;
    _begining_z = _z;
    _begining_rx = _rx;
    _begining_ry = _ry;
    _begining_rz = _rz;
    _prev_x = _x;
    _prev_y = _y;
    _prev_z = _z;
    _prev_rx = _rx;
    _prev_ry = _ry;
    _prev_rz = _rz;
    _is_fix_begin_pos = true;
}

void HomingLaserChip::onActive() {
    //Ǝݒ肵ꍇApĕʃNX쐬AI[o[ChĂB
    //̍ ́A{NX onActive() \bhĂяoĂB
    LaserChip::onActive();
    HomingLaserChip* pChip_front =  (HomingLaserChip*)_pChip_front;

    //[U[`bvo
    if (pChip_front == nullptr) {
        //_TRACE_("HomingLaserChip::onActive() "<<getName()<<" pChip_front == nullptr");
        _is_leader = true;
        //g擪̏ꍇ
        _begining_x = _x;
        _begining_y = _y;
        _begining_z = _z;
        _begining_rx = _rx;
        _begining_ry = _ry;
        _begining_rz = _rz;
    } else {
        _is_leader = false;
        //_TRACE_("HomingLaserChip::onActive() "<<getName()<<" pChip_front =="<<(pChip_front->getName()));
        _begining_x = pChip_front->_begining_x;
        _begining_y = pChip_front->_begining_y;
        _begining_z = pChip_front->_begining_z;
        _begining_rx = pChip_front->_begining_rx;
        _begining_ry = pChip_front->_begining_ry;
        _begining_rz = pChip_front->_begining_rz;
        if (_is_fix_begin_pos) {
            _x = _begining_x;
            _y = _begining_y;
            _z = _begining_z;
            _rx = _begining_rx;
            _ry = _begining_ry;
            _rz = _begining_rz;
        }
    }
}

void HomingLaserChip::onInactive() {
    //[U[`bv
    //      -==========<>            [U[
    //
    //      -= === === === <>        ȂӂɕfĂ܂B
    //
    //    | -=|===|===|===|<> |      }̓[U[IuWFNgŋ؂̐}
    //
    //    <--><--><--><--><-->^
    //    ^   ^   ^   ^   ^   |
    //    |   |   |   |   |   |
    //    |   |   |   |   |    `----- 4:[`bv(\ŁAԐ擪`bv\邽߂ɑ)
    //    |   |   |   |    `----- 3:Ԑ擪`bv(\̐擪)
    //    |   |   |    `----- 2:ԃ`bv
    //    |   |    `----- 2:ԃ`bv
    //    |    `----- 2:ԃ`bv
    //     `----- 1:`bv
    //

    //_TRACE_("A HomingLaserChip::onInactive() _chip_kind ="<<_chip_kind <<")");
    if (_chip_kind == 1) {

    } else if (_chip_kind == 2) {
        LaserChip* pChip_behind = _pChip_behind;
        //ԃ`bv̏ꍇ
        //g̃`bv邱ƂɂA[U[̐Ȃ\QĂ܂B
        //O̐擪ȊÕ`bv́AOɒǏ]Ă邾Ȃ̂ŁAԃ`bv Mover p[^͕sB
        //`bvVȐ擪`bvƂȂ郌[U[\̃O[v getKuroko()->behave() œp邽߂ɁA
        //VȐ擪`bv֌݂̈ړƈړx̏`BKvB
        if (pChip_behind) {
            int D = (int)(sqrt(
                              (
                                ((double)(pChip_behind->_x - _x)) * ((double)(pChip_behind->_x - _x))
                              ) + (
                                ((double)(pChip_behind->_y - _y)) * ((double)(pChip_behind->_y - _y))
                              ) + (
                                ((double)(pChip_behind->_z - _z)) * ((double)(pChip_behind->_z - _z))
                              )
                            )
                         );
            pChip_behind->getKuroko()->setMvVelo(D); //xɂȂ
            pChip_behind->getKuroko()->setMvAngTwd(this);
        } else {
            //throwGgafCriticalException("HomingLaserChip::onInactive() _chip_kind == 2 łɂւ炸A_pChip_behind݂܂");
        }
    } else if (_chip_kind == 3) {
        //Ԑ擪`bv̏ꍇ
        //wǂ̏ꍇA擪珇ɏĂ͂łB
        //sƂ͒ԃ`bv̏ꍇƓŁA`bv֏`BKvB
        //[`bv Mover p[^̈ړƈړx̏Rs[邱ƂOK
        //vZx҂
        if (_pChip_behind && _pChip_front) {
            GgafDxKuroko* const pChip_behind_pKuroko = _pChip_behind->getKuroko();
            GgafDxKuroko* const pChip_front_pKuroko = _pChip_front->getKuroko();
            pChip_behind_pKuroko->_vX = pChip_front_pKuroko->_vX;
            pChip_behind_pKuroko->_vY = pChip_front_pKuroko->_vY;
            pChip_behind_pKuroko->_vZ = pChip_front_pKuroko->_vZ;
            pChip_behind_pKuroko->_ang_rz_mv = pChip_front_pKuroko->_ang_rz_mv;
            pChip_behind_pKuroko->_ang_ry_mv = pChip_front_pKuroko->_ang_ry_mv;
            pChip_behind_pKuroko->_velo_mv =  pChip_front_pKuroko->_velo_mv;
        } else {
            //throwGgafCriticalException("HomingLaserChip::onInactive() _chip_kind == 2 łɂւ炸A_pChip_front  _pChip_behind ݂܂");
        }
    } else if (_chip_kind == 4) {
        if (_pChip_behind) {
            GgafDxKuroko* const pChip_behind_pKuroko = _pChip_behind->getKuroko();
            GgafDxKuroko* pKuroko = getKuroko();
            pChip_behind_pKuroko->_vX = pKuroko->_vX;
            pChip_behind_pKuroko->_vY = pKuroko->_vY;
            pChip_behind_pKuroko->_vZ = pKuroko->_vZ;
            pChip_behind_pKuroko->_ang_rz_mv = pKuroko->_ang_rz_mv;
            pChip_behind_pKuroko->_ang_ry_mv = pKuroko->_ang_ry_mv;
            pChip_behind_pKuroko->_velo_mv  = pKuroko->_velo_mv;
        } else {
            //throwGgafCriticalException("HomingLaserChip::onInactive() _chip_kind == 4 łɂւ炸A_pChip_behind ݂܂");
        }
    }
    LaserChip::onInactive(); //Ȃؒf
}

void HomingLaserChip::processBehavior() {
    //Ǝݒ肵ꍇApĕʃNX쐬AI[o[ChĂB
    //̍ ́A{NX processBehavior() \bhĂяoĂB
    //Wɔf
    HomingLaserChip* pChip_front =  (HomingLaserChip*)_pChip_front;
    if (getActiveFrame() > 1) {
        //GgafActorDepository::dispatch() 
        //擾łꍇA|C^ԂƋɁÃAN^[̓AN^[҂̃TüԌɈړB
        //āA[U[̐擪珇ԂprocessBehavior() Ă΂邽߁Aȉ̂悤ɂ
        //qɂȂB
        if (pChip_front == nullptr) {
            //{̐擪`bvA͂ɂ킩擪`bv̏ꍇ̋ʏ
            _prev_x  = _x;
            _prev_y  = _y;
            _prev_z  = _z;
            _prev_rx = _rx;
            _prev_ry = _ry;
            _prev_rz = _rz;
            processBehaviorHeadChip(); //擪`bv݈̂ړ
        } else {
            _prev_x  = _x;
            _prev_y  = _y;
            _prev_z  = _z;
            _prev_rx = _rx;
            _prev_ry = _ry;
            _prev_rz = _rz;
            _x  = pChip_front->_prev_x;
            _y  = pChip_front->_prev_y;
            _z  = pChip_front->_prev_z;
            _rx = pChip_front->_prev_rx;
            _ry = pChip_front->_prev_ry;
            _rz = pChip_front->_prev_rz;
        }
    }
}

void HomingLaserChip::processSettlementBehavior() {
    if (_was_paused_flg) {
        GgafDxGeometricActor::processSettlementBehavior();
    } else {
        LaserChip::processSettlementBehavior();
    }
}

HomingLaserChip::~HomingLaserChip() {
}

