#ifndef GGAFLIB_LASERCHIP_H_
#define GGAFLIB_LASERCHIP_H_
#include "GgafLibCommonHeader.h"
#include "jp/ggaf/dxcore/actor/GgafDxMeshSetActor.h"

namespace GgafLib {

/**
 * |C[U[̃`bv̊NX .
 * Ӂ
 * processSettlementBehavior()̏ɂA
 * setHitAble(false); ͈ӖȂ܂B
 * 蔻sȂꍇA
 * registerHitAreaCube_AutoGenMidColli() ̓蔻莩̂쐬ȂŉB
 * @version 1.00
 * @since 2008/11/24
 * @author Masatoshi Tsuge
 */
class LaserChip : public GgafDxCore::GgafDxMeshSetActor {
    friend class WateringLaserChip;
    friend class HomingLaserChip;
    friend class RefractionLaserChip;
    friend class StraightLaserChip;
    friend class LaserChipDepository;

private:
    D3DXHANDLE _ah_kind[11];
    D3DXHANDLE _ah_force_alpha[11];
    D3DXHANDLE _ah_matWorld_front[11];
    //D3DXHANDLE _h_cnt_vertec;

    /** onAcive() ŃZbgU镑t[ */
    frame _frame_of_behaving_from_onActive;

    /** gǗĂAN^[ */
    LaserChipDepository* _pDepo;
    /** registerHitAreaCube_AutoGenMidColli() \bhɂo^̓蔻藧̂̂Pӂ̒ */
    int _hitarea_edge_length;
    int _hitarea_edge_length_3;
    /** registerHitAreaCube_AutoGenMidColli() \bhɂo^̓蔻藧̂̂Pӂ̒̔ */
    int _harf_hitarea_edge_length;

    /** Õ[U[`bv */
    LaserChip* _pChip_front;
    /** ̃[U[`bv */
    LaserChip* _pChip_behind;

public:
    CollisionChecker3D* _pColliChecker;

    /** [U[eNX`  1: 2: 3:擪QԖڂŐ擪̃eNX` i擪͖Dj 4:{̐擪(A`łȂ) */
    int _chip_kind;
    /** [r]n`qbg`bv(101) */
    bool _can_chikei_hit;
    /** [r]g[`bv */
    LaserChip* _pLeader;
    /** [r]㏑At@lBio͉łĂ\邽) */
    float _force_alpha;
    /** [r]trueȂ΁AO`bvƗꂷꍇɒԓ蔻莩 */
    bool _middle_colli_able;

public:
    LaserChip(const char* prm_name, const char* prm_model, GgafCore::GgafStatus* prm_pStat=nullptr);

    virtual void executeHitChk_MeAnd(GgafActor* prm_pOtherActor) override;

    virtual void onActive() override;
    /**
     * lXȎO .
     * Ӂ
     * setHitAble(true);
     * ŎsĂ܂̂ŁA
     * setHitAble(false);
     * ͖ӖłB
     */
    virtual void processSettlementBehavior() override;

    virtual void processPreDraw() override;

    virtual void processDraw() override;

    virtual void onInactive() override;

    virtual void drawHitArea() override;

    /**
     * [U[`bvp蔻藧̂Zbg .
     * [U[`bvԂ̋A蔻̂蔲h~邽߁A<BR>
     * ʏ̓蔻ɉAڑꂽO`bvƂ̋ꂽꍇɂ̂݁A<BR>
     * IɒԂɓ蔻@\t^B<BR>
     * 蔻vf͂QɂȂB
     * yӁz<BR>
     * \߃[U[`bvԂ̋JA蔲NȂƂ킩Ăꍇ́A<BR>
     * {\bhŐݒ肹Aʏ getCollisionChecker()->makeCollision(1);<BR>
     * sقptH[}XǂB<BR>
     * @param prm_edge_length
     */
    virtual void registerHitAreaCube_AutoGenMidColli(int prm_edge_length);


    /**
     * ݒ.
     * @param prm_alpha
     */
    virtual void setAlpha(float prm_alpha) override;

    /**
     * Z .
     * @param prm_alpha
     */
    virtual void addAlpha(float prm_alpha) override;

    inline CollisionChecker3D* getCollisionChecker() {
        return _pColliChecker;
    }

    /**
     * g̈Õ[U[`bv擾 .
     * 擾łꍇ́AgƘAĂ邱ƂƂȂB
     * 擾łȂꍇ(߂l=nullptr)Ag͐擪`bvłB
     * @return Õ[U[`bvA nullptr
     */
    inline LaserChip* getFrontChip() {
        return _pChip_front;
    }

    /**
     * g̈̃[U[`bv擾 .
     * 擾łꍇ́AgƘAĂ邱ƂƂȂB
     * 擾łȂꍇ(߂l=nullptr)Ag͖`bvłB
     * @return ̃[U[`bvA nullptr
     */
    inline LaserChip* getBehindChip() {
        return _pChip_behind;
    }

    virtual ~LaserChip();

};

}
#endif /*GGAFLIB_LASERCHIP_H_*/

