#ifndef GGAFDXCORE_GGAFDXUNIVERSE_H_
#define GGAFDXCORE_GGAFDXUNIVERSE_H_
#include "jp/ggaf/core/scene/GgafUniverse.h"

#include "jp/ggaf/dxcore/GgafDxGod.h"
#include "jp/ggaf/dxcore/actor/GgafDxCamera.h"

#ifdef P_GOD
    #undef P_UNIVERSE
    #define P_UNIVERSE ((GgafDxCore::GgafDxUniverse*)(P_GOD->_pUniverse))
    #undef P_CAM
    #define P_CAM (P_UNIVERSE->_pCamera)
#else
    #undef P_UNIVERSE
    #undef P_CAM
#endif

namespace GgafDxCore {

/**
 * GgafDxCoreOԂ̂̐NX.
 * GgafDxCoreOԓł́ÃNX̂̐NXƂ܂B<BR>
 * (GgafDxWorldBound)
 * @version 1.00
 * @since 2008/07/30
 * @author Masatoshi Tsuge
 */
class GgafDxUniverse : public GgafCore::GgafUniverse {

private:
    /**
     * t[̕`揈 .
     * iK_OsȂ void GgafElement<T>::draw() I[o[ChB<BR>
     * {NX(GgafUniverse)͒_̃V[ł邽߁Ȃ̃AN^[V[̑SẮA<BR>
     * void GgafElement<T>::draw() Ă΂邱Ƃł傤B<BR>
     */
    virtual void draw() override;

public:
    class SeArray {
    public:
        int _p;
        GgafDxSe* _apSe[64];
        int _volume[64];
        float _pan[64];
        float _rate_frequency[64];
        GgafDxGeometricActor* _apActor[64];
        SeArray();

        void add(GgafDxSe* prm_pSe, int prm_volume, float prm_pan, float prm_rate_frequency, GgafDxGeometricActor* prm_pActor);

        void play(int index);
    };
    GgafCore::GgafLinkedListRing<SeArray>* _pRing_pSeArray;

public:
    /** J */
    GgafDxCamera* _pCamera;

    /** _Ozɓo^ĂeAN^[Xg̐擪̃AN^[̔z */
    static GgafDxDrawableActor* _apAlphaActorFirstList_DrawDepthLevel[];
    /** _Ozɓo^ĂeAN^[Xg̖̃AN^[̔z */
    static GgafDxDrawableActor* _apAlphaActorLastList_DrawDepthLevel[];

    /** `AN^[̃J[\ */
    static GgafDxDrawableActor* _pActor_DrawActive;

    /** [r]AvP[V̈AXW̍ŏl */
    static coord _x_gone_left;
    /** [r]AvP[V̈AXW̍ől */
    static coord _x_gone_right;
    /** [r]AvP[V̈AYW̍ől */
    static coord _y_gone_top;
    /** [r]AvP[V̈AYW̍ŏl */
    static coord _y_gone_bottom;
    /** [r]AvP[V̈AZW̍ől */
    static coord _z_gone_far;
    /** [r]AvP[V̈AZW̍ŏl */
    static coord _z_gone_near;
    static std::string _seqkey_se_delay;

//    D3DCOLORVALUE _colFog;


public:
    GgafDxUniverse(const char* prm_name, GgafDxCamera* prm_pCamera);

    virtual void processSettlementBehavior() override;

    virtual ~GgafDxUniverse();


    /**
     * `惌xijo^ .
     * Ȃǔ͂ɓo^AxO֌W\B
     * @param prm_draw_depth_level x
     * @param prm_pActor AN^[
     */
    static int setDrawDepthLevel(int prm_draw_depth_level, GgafDxDrawableActor* prm_pActor);

    void registerSe(GgafDxSe* prm_pSe,
                    int prm_volume,
                    float prm_pan,
                    float prm_rate_frequency,
                    int prm_delay,
                    GgafDxGeometricActor* prm_pActor);

};

}
#endif /*GGAFDXCORE_GGAFDXUNIVERSE_H_*/
