#ifndef GGAFDXCORE_GGAFDXMODELMANAGER_H_
#define GGAFDXCORE_GGAFDXMODELMANAGER_H_

#include "jp/ggaf/core/util/GgafResourceManager.hpp"

#include "jp/ggaf/dxcore/model/GgafDxModel.h"
#include "jp/ggaf/dxcore/util/XFile/framework/Frm_Mesh.h"
#include "jp/ggaf/dxcore/util/XFile/ToolBox/IOModel_X.h"

//#define Obj_GgafDxDynaD3DXMeshModel      (0x1U)            //0b 00000000 00000000 00000000 00000001
#define Obj_GgafDxD3DXAniMeshModel       (0x2U)            //0b 00000000 00000000 00000000 00000010
#define Obj_GgafDxD3DXMeshModel          (0x4U)            //0b 00000000 00000000 00000000 00000100
#define Obj_GgafDxSpriteModel            (0x8U)            //0b 00000000 00000000 00000000 00001000
#define Obj_GgafDxSpriteSetModel         (0x10U)           //0b 00000000 00000000 00000000 00010000
#define Obj_GgafDxBoardModel             (0x20U)           //0b 00000000 00000000 00000000 00100000
#define Obj_GgafDxBoardSetModel          (0x40U)           //0b 00000000 00000000 00000000 01000000
#define Obj_GgafDxMeshModel              (0x80U)           //0b 00000000 00000000 00000000 10000000
#define Obj_GgafDxMeshSetModel           (0x100U)          //0b 00000000 00000000 00000001 00000000
#define Obj_GgafDxCubeMapMeshModel       (0x200U)          //0b 00000000 00000000 00000010 00000000
#define Obj_GgafDxCubeMapMeshSetModel    (0x400U)          //0b 00000000 00000000 00000100 00000000
#define Obj_GgafDxMorphMeshModel         (0x800U)          //0b 00000000 00000000 00001000 00000000
#define Obj_GgafDxCubeMapMorphMeshModel  (0x1000U)         //0b 00000000 00000000 00010000 00000000
#define Obj_GgafDxWorldBoundModel        (0x2000U)         //0b 00000000 00000000 00100000 00000000
#define Obj_GgafDxPointSpriteModel       (0x4000U)         //0b 00000000 00000000 01000000 00000000

#define connect_ModelTextureManager(X) ((GgafDxCore::GgafDxTextureConnection*)P_GOD->_pModelManager->_pModelTextureManager->connect((X), this))

namespace GgafDxCore {

/**
 * fCX^XǗ.
 * ɁAfXgɂێAfvꂽ<BR>
 * 邩A邢͐ςԂ𔻒f܂B<BR>
 * TODO:jƂNXŔ剻͂ȂAȂB
 * @version 1.00
 * @since 2009/02/01
 * @author Masatoshi Tsuge
 */
class GgafDxModelManager : public GgafCore::GgafResourceManager<GgafDxModel> {

private:
    /** JX^ev[gXt@Cǂݍݗp ID3DXFile ̃|C^ */
    ID3DXFile* _pID3DXFile_sprx;
    ID3DXFile* _pID3DXFile_psprx;
    struct XFILE_SPRITE_FMT {
        float width;
        float height;
        char texture_file[256];
        int row_texture_split;
        int col_texture_split;
    };

private:
    GgafDxD3DXMeshModel*         createD3DXMeshModel(char* prm_model_name, DWORD prm_dwOptions);
    GgafDxD3DXAniMeshModel*      createD3DXAniMeshModel(char* prm_model_name);
    GgafDxD3DXMeshModel*         createDynaMeshModel(char* prm_model_name);
    GgafDxSpriteModel*           createSpriteModel(char* prm_model_name);
    GgafDxSpriteSetModel*        createSpriteSetModel(char* prm_model_name);
    GgafDxBoardModel*            createBoardModel(char* prm_model_name);
    GgafDxBoardSetModel*         createBoardSetModel(char* prm_model_name);
    GgafDxMeshModel*             createMeshModel(char* prm_model_name);
    GgafDxMeshSetModel*          createMeshSetModel(char* prm_model_name);
    GgafDxCubeMapMeshModel*      createCubeMapMeshModel(char* prm_model_name);
    GgafDxCubeMapMeshSetModel*   createCubeMapMeshSetModel(char* prm_model_name);
    GgafDxMorphMeshModel*        createMorphMeshModel(char* prm_model_name);
    GgafDxCubeMapMorphMeshModel* createCubeMapMorphMeshModel(char* prm_model_name);
    GgafDxWorldBoundModel*       createWorldBoundModel(char* prm_model_name);
    GgafDxPointSpriteModel*      createPointSpriteModel(char* prm_model_name);
    void setMaterial(Frm::Mesh* in_pMeshesFront,
                     int* pOut_material_num,
                     D3DMATERIAL9**                pOut_paMaterial,
                     GgafDxTextureConnection***    pOut_papTextureConnection);
    void setDefaultMaterial(D3DMATERIAL9* out_pD3DMATERIAL9);

    /**
     * Ԃ3_v0 v1 v2 A v0v1  v1v2 ̐p(pv1)߂
     * @param v0
     * @param v1
     * @param v2
     * @return p(fBA)
     */
    float getRadv1_v0v1v2(Frm::Vertex& v0, Frm::Vertex& v1, Frm::Vertex& v2);

    /**
     * 3D_obt@FrameTransformMatrixϊƖ@ݒB
     * @param prm_paVtxBuffer
     * @param prm_size_of_vtx_unit
     * @param model_pModel3D
     * @param paNumVertices _AO̒_TuZbg̔z
     *        ifTuZbgPʂŌʊiʒuA]AgjێĂꍇj
     */
    void prepareVtx(void* prm_paVtxBuffer, UINT prm_size_of_vtx_unit,
                    Frm::Model3D* model_pModel3D,
                    uint16_t* paNumVertices,
                    GgafDxModel* prm_pModel = nullptr);

    /**
     * ID3DXFileDatãf[^|C^AiXt@CtH[}bgʂɁjXvCgoB
     * @param pSpriteFmt_out
     * @param pLockedData ID3DXFileData->lock() ̃f[^|C^
     * @return
     */
    char* obtainSpriteFmtX(XFILE_SPRITE_FMT* pSpriteFmt_out, char* pLockedData);

    static std::string getMeshFileName(std::string prm_model_name);
    static std::string getSpriteFileName(std::string prm_model_name);
    static std::string getPointSpriteFileName(std::string prm_model_name);

    static void calcTangentAndBinormal(
            D3DXVECTOR3* p0, D3DXVECTOR2* uv0,
            D3DXVECTOR3* p1, D3DXVECTOR2* uv1,
            D3DXVECTOR3* p2, D3DXVECTOR2* uv2,
            D3DXVECTOR3* outTangent, D3DXVECTOR3* outBinormal);
public:
    GgafDxTextureManager* _pModelTextureManager;

public:
    /**
     * RXgN^
     * @param prm_manager_name }l[W(eK{)
     */
    GgafDxModelManager(const char* prm_manager_name);

    /**
     * fIDɂAfIuWFNg𐶐 .
     * <pre>
     * fIĎ`
     * wf^Cv  + "/" + f`xƂȂĂB
     *  "D/MyShip"   --> GgafDxD3DXMeshModel ̃fBǂݍރt@C "MyShip.x"
     *  "d/MyShip"   --> GgafDxD3DXMeshModel ̃fBǂݍރt@C "MyShip.x"iD3DXMESH_DYNAMIC IvVقȂj
     *  "A/Hone"     --> GgafDxD3DXAniMeshModel ̃fBǂݍރt@C "Hone.x"
     *  "X/Enemy"    --> GgafDxMeshModel ̃fBǂݍރt@C "Enemy.x"
     *  "x/12/Enemy"- -> GgafDxMeshSetModel ̃fBǂݍރt@C "Enemy.x"B`IuWFNg 12 Zbg
     *  "x/Enemy"    --> GgafDxMeshSetModel ̃f(Zbgȗ\L)Bǂݍރt@C "Enemy.x"BZbgȗ͍ő 15 Zbg
     *  "M/3/MyShip" --> GgafDxMorphMeshModel ̃fBǂݍރt@C "MyShip_0.x", "MyShip_1.x", "MyShip_2.x", "MyShip_3.x"BlȗsB
     *                   vC}f"MyShip_0.x"A[t^[Qbg1`3"MyShip_1.x", "MyShip_2.x", "MyShip_3.x"
     *  "S/Bomb"     --> GgafDxSpriteModel ̃fBǂݍރt@C "Bomb.sprx"B
     *  "s/5/Bomb"   --> GgafDxSpriteSetModel ̃fBǂݍރt@C "Bomb.sprx"B`IuWFNg 5 Zbg
     *  "s/Bomb"     --> GgafDxSpriteSetModel ̃f(Zbgȗ\L)Bǂݍރt@C "Bomb.sprx"BZbgȗ͍ő 18 Zbg
     *  "B/Font"     --> GgafDxBoardModel ̃fBǂݍރt@C "Font.sprx"B
     *  "b/10/Font"  --> GgafDxBoardSetModel ̃fBǂݍރt@C "Font.sprx"B`IuWFNg 10 Zbg
     *  "b/Font"     --> GgafDxBoardSetModel ̃fBǂݍރt@C "Font.sprx"BZbgȗ͍ő 28 Zbg
     *  "P/Star"     --> GgafDxPointSpriteModel ̃fBǂݍރt@C "Star.psprx"B`Zbg8
     *  "C"          --> GgafDxD3DXMeshModel ̃fBǂݍރt@C "cube.x"
     *  </pre>
     * @param prm_idstr fID
     * @param prm_p Rp[^Aݖgp
     * @return fIuWFNg
     */
    GgafDxModel* processCreateResource(char* prm_idstr, void* prm_pConnector) override;

    /**
     * GgafDxD3DXMeshModel IuWFNgč\zB .
     * @param prm_pD3DXMeshModel č\zGgafDxD3DXMeshModel
     */
    void restoreD3DXMeshModel(GgafDxD3DXMeshModel* prm_pD3DXMeshModel);

    void restoreD3DXAniMeshModel(GgafDxD3DXAniMeshModel* prm_pD3DXAniMeshModel);
    void getDrawFrameList(std::list<D3DXFRAME_WORLD*>* pList, D3DXFRAME_WORLD* frame);
    /**
     * GgafDxSpriteModel IuWFNgč\zB .
     * @param prm_pSpriteModel č\zGgafDxSpriteModel
     */
    void restoreSpriteModel(GgafDxSpriteModel* prm_pSpriteModel);

    void restoreSpriteSetModel(GgafDxSpriteSetModel* prm_pSpriteSetModel);


    /**
     * GgafDxBoardModel IuWFNgč\zB .
     * @param prm_pBoardModel č\zGgafDxBoardModel
     */
    void restoreBoardModel(GgafDxBoardModel* prm_pBoardModel);

    void restoreBoardSetModel(GgafDxBoardSetModel* prm_pBoardSetModel);

    void restoreMeshModel(GgafDxMeshModel* prm_pD3DXMeshModel);

    void restoreMeshSetModel(GgafDxMeshSetModel* prm_pD3DXMeshSetModel);

    void restoreMorphMeshModel(GgafDxMorphMeshModel* prm_pModel);

    void restorePointSpriteModel(GgafDxPointSpriteModel* prm_pPointSpriteModel);

    /**
     * I[o[Ch
     */
    GgafCore::GgafResourceConnection<GgafDxModel>* processCreateConnection(char* prm_idstr, GgafDxModel* prm_pResource) override;

    /**
     * fIuWFNgXg̊eCX^X̓eč\zB .
     * foCXXg̕AɌĂяo<BR>
     */
    void restoreAll();

    void onDeviceLostAll();

    void releaseAll();


    /** ݃fID */
    static int _id_max;

    /** fID擾 */
    static int getNextId() {
        _id_max++;
        return _id_max;
    }
    /** O`Model */
    static GgafDxModel* _pModelLastDraw;

    /**
     * f}l[W[Ǘ郂fXg̐擪擾
     * @return 擪̃f
     */
    GgafDxModelConnection* getFirstConnection() {
        return (GgafDxModelConnection*)_pConn_first;
    }

    virtual ~GgafDxModelManager();
};

}
#endif /*GGAFDXCORE_GGAFDXMODELMANAGER_H_*/
