#ifndef GGAFDXCORE_GGAFDXALLOCHIERARCHY_H_
#define GGAFDXCORE_GGAFDXALLOCHIERARCHY_H_

#include <list>
#include <d3dx9.h>

namespace GgafDxCore {

/**
 * ID3DXAllocateHierarchyNX .
 */
class GgafDxAllocHierarchy : public ID3DXAllocateHierarchy
{
protected:
    class DeleterBase {
    public:
        virtual ~DeleterBase() {}
    };

    template< class T >
    class Deleter : public DeleterBase {
    public:
        T* pObj;
        bool isAry;

        Deleter( T* deletePtr, bool is_Ary = false ) : pObj(deletePtr), isAry( is_Ary ) {};
        virtual ~Deleter(){
            if ( isAry ) {
                T* pa = (T*)pObj;
                GGAF_DELETEARR(pa);
            } else {
                T* p = (T*)pObj;
                GGAF_DELETE(p);
            }
        }
    };

protected:
    std::list<DeleterBase*> m_DelList;   // Xg
    std::list<IUnknown*> m_ReleaseList;   // [XXg

public:
    GgafDxAllocHierarchy(void);
    virtual ~GgafDxAllocHierarchy(void);

    // t[𐶐
    STDMETHOD(CreateFrame)(THIS_
        LPCSTR Name,
        LPD3DXFRAME *ppNewFrame
    ) override;

    // Rei𐶐
    STDMETHOD(CreateMeshContainer)(THIS_
        LPCSTR Name,
        CONST D3DXMESHDATA *pMeshData,
        CONST D3DXMATERIAL *pMaterials,
        CONST D3DXEFFECTINSTANCE *pEffectInstances,
        DWORD NumMaterials,
        CONST DWORD *pAdjacency,
        LPD3DXSKININFO pSkinInfo,
        LPD3DXMESHCONTAINER *ppNewMeshContainer
    ) override;

    // t[폜
    STDMETHOD(DestroyFrame)(THIS_
        LPD3DXFRAME pFrameToFree
    ) override;

    // Rei폜
    STDMETHOD(DestroyMeshContainer)(THIS_
        LPD3DXMESHCONTAINER pMeshContainerToFree
    ) override;


protected:
    // Xgɓo^
    virtual void addDelList( DeleterBase* ptr, bool isAry = false );

    // Rs[
    virtual LPSTR copyStr(LPCSTR name);

    // t[\̂𐶐
    virtual D3DXFRAME* createNewFrame();

    // bVRei\̂𐶐
    virtual D3DXMESHCONTAINER* createNewMeshContainer();

    // bVf[^o^
    virtual void registerMeshData(CONST D3DXMESHDATA *pSrc, D3DXMESHDATA *pDest);

    // [XXgɓo^
    virtual void addReleaseList( IUnknown *comptr);

    // }eAo^
    virtual void registerMaterial(CONST D3DXMATERIAL *pSrc, DWORD num, D3DXMATERIAL **pDest);

    // GtFNgo^
    virtual void registerEffect(CONST D3DXEFFECTINSTANCE *pSrc, D3DXEFFECTINSTANCE **ppDest);

    // אڃ|So^
    virtual void registerAdjacency(CONST DWORD *Src, DWORD polynum, DWORD **Dest);

    // XLo^
    virtual void registerSkin( CONST LPD3DXSKININFO Src, LPD3DXSKININFO *Dest);
};

}

#endif /*GGAFDXCORE_GGAFDXALLOCHIERARCHY_H_*/
