#include "stdafx.h"
#include "MenuBoard.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoA.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/gecchi/VioletVreath/God.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

MenuBoard::MenuBoard(const char* prm_name, const char* prm_model) :
        StringBoardMenu(prm_name, prm_model) {
    _class_name = "MenuBoard";
    slide_from_offset_X_ = 0;
    slide_from_offset_Y_ = 0;
    target_X_ = _X;
    target_Y_ = _Y;
    _pSeTx->set(SE_ON_RISEN      , "WAVE_MENU_ON_RISEN"      );
    _pSeTx->set(SE_MOVE_CURSOR   , "WAVE_MENU_MOVE_CURSOR"   );
    _pSeTx->set(SE_DECIDED_CANCEL, "WAVE_MENU_DECIDED_CANCEL");
}

void MenuBoard::setTransition(frame prm_menu_fade_frames,
                              coord prm_slide_from_offset_X, coord prm_slide_from_offset_Y) {
    setFadeFrames(prm_menu_fade_frames);
    slide_from_offset_X_ = prm_slide_from_offset_X;
    slide_from_offset_Y_ = prm_slide_from_offset_Y;
}

bool MenuBoard::condDecision() {
    if (VB->isPushedDown(VB_UI_EXECUTE)) {
        //uj[ACeFCӁvŁAVB_UI_EXECUTE {^̏ꍇ
        //̃ACeuvƂB(O)
        return true;
    } else if (VB->isPushedDown(VB_UI_CANCEL) &&
               _lstItems.getRelation(ITEM_RELATION_TO_CANCEL) != nullptr &&
               _lstItems.getCurrent() == _lstItems.getRelation(ITEM_RELATION_TO_CANCEL)) {
        //ʂɁuj[ACeFLZvɃJ[\ꍇłAVB_UI_CANCEL {^̏ꍇ́A
        //uj[ACeFLZvuvƂɂB
        //J[\uj[ACeFLZvɂ邩ǂ̔f́A
        //relateAllItemCancel() Œ`ꂽACẽCfbNXǂŔfB
        _pSeTx->play(SE_DECIDED_CANCEL);
        return true;
    } else {
        return false;
    }
}

bool MenuBoard::condCancel() {
    if (VB->isPushedDown(VB_UI_CANCEL)) {
        //uj[ACeFCӁvŁAVB_UI_CANCEL {^̏ꍇ
        //̃ACeuLZvƂB(O)
        _pSeTx->play(SE_DECIDED_CANCEL);
        return true;
    } else {
        return false;
    }
}

bool MenuBoard::condSelectNext() {
    return VB->isAutoRepeat(VB_UI_DOWN);
}

bool MenuBoard::condSelectPrev() {
    return VB->isAutoRepeat(VB_UI_UP);
}

bool MenuBoard::condSelectExNext() {
    return VB->isAutoRepeat(VB_UI_RIGHT);
}

bool MenuBoard::condSelectrExPrev() {
    return VB->isAutoRepeat(VB_UI_LEFT);
}

bool MenuBoard::condSelectCancel() {
    return isJustCancelled();
}

void MenuBoard::riseMe() {
    target_X_ = _X;
    target_Y_ = _Y;
    StringBoardMenu::riseMe();
}

void MenuBoard::rise(coord prm_target_X, coord prm_target_Y) {
    target_X_ = prm_target_X;
    target_Y_ = prm_target_Y;
    StringBoardMenu::riseMe();
}

void MenuBoard::riseSubMenu(int prm_index, coord prm_target_X, coord prm_target_Y) {
    StringBoardMenu::getSubMenu(prm_index)->position(prm_target_X, prm_target_Y); //ɂvoid MenuBoard::riseMe() ɗɃ^[Qbgݒ肳
    StringBoardMenu::riseSubMenu(prm_index);
}

void MenuBoard::moveCursor(bool prm_smooth) {
    StringBoardMenu::moveCursor(prm_smooth);
    if (prm_smooth) { //X[YړtrueȂ킿AԁB
        _pSeTx->play(SE_MOVE_CURSOR);
    }
}

void MenuBoard::onMoveCursor(int prm_from, int prm_to) {
}

void MenuBoard::onSelect(int prm_from, int prm_to) {
}

void MenuBoard::initialize() {
}

void MenuBoard::onRise() {
    //XChCgWV
    position(target_X_ + slide_from_offset_X_,
             target_Y_ + slide_from_offset_Y_);
    _pKurokoA->setMvAngTwd(target_X_, target_Y_);
    _pKurokoA->slideMvByDT(0, UTIL::getDistance(_X, _Y, target_X_, target_Y_),
                           _fade_frames, 0.2, 0.3 );
    _pSeTx->play(SE_ON_RISEN);
}

void MenuBoard::processBehavior() {
    if (_pKurokoA->isSlidingMv()) {
        //XCh
    } else {
        //XChIAړI̍W֕␳
        position(target_X_, target_Y_);
    }

    _pKurokoA->behave();
    StringBoardMenu::processBehavior();
    //j[IACeA\ACeAJ[\́A
    //{[hWɂĂ邽߁Ag̍Wm
    // processBehavior() R[قǂB
}

void MenuBoard::processJudgement() {
}

void MenuBoard::onSink() {
    //XChAEggWV
    _pKurokoA->setMvAngTwd(target_X_ + slide_from_offset_X_,
                           target_Y_ + slide_from_offset_Y_);
    _pKurokoA->slideMvByDT(0, UTIL::getDistance(
                                _X, _Y,
                                target_X_+slide_from_offset_X_, target_Y_+slide_from_offset_Y_
                              ),
                           _fade_frames, 0.2, 0.3 );
}

MenuBoard::~MenuBoard() {
}
