#include "stdafx.h"
#include "EnemyEresShot001.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoA.h"
#include "jp/ggaf/lib/util/CollisionChecker3D.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Universe/World/GameScene/MyShipScene.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

EnemyEresShot001::EnemyEresShot001(const char* prm_name) :
        DefaultMeshSetActor(prm_name, "myvic", STATUS(EnemyEresShot001)) {
    _class_name = "EnemyEresShot001";
    inactivateTree();

    /** ȍ */
    velo1st_ = 13000;
    /** ỏxiŒxȂj */
    iMoveAcce_1st_ = -150;
    /** goĂA@̕ɕ]Jnt[ */
    frame_TurnBegin_ = 60;
    /** ړx */
    veloTop_ = 30000;
    /** Œۏ؈ړx */
    veloBottom_ = 0;
    /** ]ɔ₷Ƃłt[ */
    frame_TurnInterval_ = 400;
    /** ]̊pxAOl(̒l) */
    angVelo_Turn_ = 7000;
    /** ]Jniframe_TurnBegin_jĐݒ肳x */
    iMoveAcce_2nd_ = 100;
    _pSeTx->set(ERESSHOT001_SE_EXPLOSION, "WAVE_EXPLOSION_002");
}

void EnemyEresShot001::initialize() {
    _pKurokoA->forceMvVeloRange(veloTop_, veloBottom_);
    _pKurokoA->relateMvFaceAng(true);

    _pColliChecker->makeCollision(1);
    _pColliChecker->setColliAAB(0, -30000, -30000, 30000, 30000);
    setHitAble(true);
}

void EnemyEresShot001::onActive() {
    _pStatus->reset();

    //o
    _pKurokoA->setMvVelo(velo1st_);
    _pKurokoA->setMvAcce(iMoveAcce_1st_);

    setHitAble(true);
}

void EnemyEresShot001::processBehavior() {
    //ZN|Cg
    _pStatus->mul(STAT_AddRankPoint, _pStatus->getDouble(STAT_AddRankPoint_Reduction));

    //]Jn
    if (getActiveFrame() == frame_TurnBegin_) {

        _pKurokoA->turnMvAngTwd(P_MYSHIP,
                                angVelo_Turn_, 0,
                                TURN_CLOSE_TO,true);
        _pKurokoA->setMvAcce(iMoveAcce_2nd_);
    }

    //]I
    if (getActiveFrame() == frame_TurnBegin_ + frame_TurnInterval_) {
        _pKurokoA->setRzRyMvAngVelo(0);
        _pKurokoA->_mv_ang_ry_target_flg = false;
        _pKurokoA->_mv_ang_rz_target_flg = false;
    }

    //behaveUvFlip();
    //Wɔf
    _pKurokoA->behave();
    //_pSeTx->behave();
}

void EnemyEresShot001::processJudgement() {
    if (isOutOfUniverse()) {
        sayonara();
    }
}

void EnemyEresShot001::onHit(GgafActor* prm_pOtherActor) {
    GgafDxGeometricActor* pOther = (GgafDxGeometricActor*)prm_pOtherActor;
    //ɃqbgGtFNg
    if (UTIL::calcEnemyStamina(this, pOther) <= 0) {
        setHitAble(false);
        //
        UTIL::activateExplosionEffectOf(this);
        _pSeTx->play3D(ERESSHOT001_SE_EXPLOSION);

        sayonara();
    }
}

void EnemyEresShot001::onInactive() {
    sayonara();
}

EnemyEresShot001::~EnemyEresShot001() {
}
