#include "stdafx.h"
#include "FormationAllas002.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoA.h"
#include "jp/ggaf/lib/util/spline/SplineKurokoLeader.h"
#include "jp/gecchi/VioletVreath/actor/enemy/Allas/EnemyAllas.h"
#include "jp/gecchi/VioletVreath/GameGlobal.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Universe/World/GameScene/MyShipScene.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

FormationAllas002::FormationAllas002(const char* prm_name) :
        TreeFormation(prm_name) {
    _class_name = "FormationAllas002";
    num_Allas_      = RF_FormationAllas002_Num(G_RANK);  //ґ
    interval_frames_ = RF_FormationAllas002_LaunchInterval(G_RANK);  //AX̊Ԋu(frame)
    velo_mv_         = RF_FormationAllas002_MvVelo(G_RANK); //x
    //AXґ쐬
    pSplManufConnection_ = connect_SplineManufactureManager("Allas02");
//    pSplLineConnection_     = connect_SplineLineManager("Spl_Allas01"); //XvC`
    //pDepoConnection_ = connect_DepositoryManager("Shot002");
    pDepoConnection_ = nullptr;
    papAllas_ = NEW EnemyAllas*[num_Allas_];
    for (int i = 0; i < num_Allas_; i++) {
        papAllas_[i] = NEW EnemyAllas("Allas01");
        //XvCړvOݒ
        SplineKurokoLeader* pProgram = pSplManufConnection_->peek()->createKurokoLeader(papAllas_[i]->_pKurokoA); //ړxŒ
        papAllas_[i]->config(pProgram, nullptr, nullptr);
        //papAllas_[i]->setDepository_Shot(pDepoConnection_->peek()); //eݒ
        papAllas_[i]->inactivateImmed();
        addFormationMember(papAllas_[i]);
    }
}

void FormationAllas002::onActive() {
    for (int i = 0; i < num_Allas_; i++) {
        papAllas_[i]->position(MyShip::lim_X_behaind_ *2 , P_MYSHIP->_Y+300000,  P_MYSHIP->_Z);
        papAllas_[i]->_pKurokoA->setMvVelo(velo_mv_);
        papAllas_[i]->activateDelay(i*interval_frames_ + 1);//interval_frames_ԊuActiveɂB
    }
}

void FormationAllas002::onDestroyAll(GgafActor* prm_pActor_last_destroyed) {
    UTIL::proceedFormationDestroyAll((GgafDxDrawableActor*)prm_pActor_last_destroyed);
}

FormationAllas002::~FormationAllas002() {
    pSplManufConnection_->close();
    if (pDepoConnection_) {
        pDepoConnection_->close();
    }
    GGAF_DELETEARR(papAllas_);
}
