#include "stdafx.h"
#include "EnemyAllas.h"

#include "jp/ggaf/core/actor/ex/GgafActorDepository.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoA.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/dxcore/model/GgafDxModel.h"
#include "jp/ggaf/lib/util/CollisionChecker3D.h"
#include "jp/ggaf/lib/util/spline/SplineKurokoLeader.h"
#include "jp/gecchi/VioletVreath/GameGlobal.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"
#include "jp/gecchi/VioletVreath/scene/Universe/World/GameScene/MyShipScene.h"
#include "jp/gecchi/VioletVreath/God.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

EnemyAllas::EnemyAllas(const char* prm_name) :
        DefaultMeshSetActor(prm_name, "Allas", STATUS(EnemyAllas)) {
    _class_name = "EnemyAllas";
    iMovePatternNo_ = 0;
    pKurokoLeader_ = nullptr;
    pDepo_Shot_ = nullptr;
    pDepo_ShotEffect_ = nullptr;
    _pSeTx->set(SE_EXPLOSION, "WAVE_EXPLOSION_001");     //
    useProgress(10);
}

void EnemyAllas::onCreateModel() {
    _pModel->setSpecular(5.0, 1.0);
}

void EnemyAllas::initialize() {
    setHitAble(true);
    _pKurokoA->setFaceAngVelo(AXIS_Z, -7000);
    _pKurokoA->relateMvFaceAng(true);
    _pColliChecker->makeCollision(1);
    _pColliChecker->setColliAAB_Cube(0, 40000);
}

void EnemyAllas::onActive() {
    if (pKurokoLeader_ == nullptr) {
        throwGgafCriticalException("EnemyAllas̓XvCK{łconfigĉ");
    }

    _pStatus->reset();
   iMovePatternNo_ = 0; //sp^[Zbg
    _pProg->change(1);
}

void EnemyAllas::processBehavior() {
    //ZN|Cg
    _pStatus->mul(STAT_AddRankPoint, _pStatus->getDouble(STAT_AddRankPoint_Reduction));

    //yp^[1FXvCړz
    if (_pProg->isJustChangedTo(1)) {
        pKurokoLeader_->start(SplineKurokoLeader::ABSOLUTE_COORD); //XvCړJn(1:W)
    }
    if (_pProg->get() == 1) {
        //XvCړI҂
        if (pKurokoLeader_->isFinished()) {
            _pProg->changeNext(); //̃p^[
        }
    }

    switch (iMovePatternNo_) {
        case 0:  //yp^[OFXvCړJnz
            if (pKurokoLeader_) {
                pKurokoLeader_->start(SplineKurokoLeader::ABSOLUTE_COORD); //XvCړJn(1:W)
            }
            iMovePatternNo_++; //̍sp^[
            break;

        case 1:  //yp^[PFXvCړI҂z
            if (pKurokoLeader_) {
                //XvCړL
                if (pKurokoLeader_->isFinished()) {
                    iMovePatternNo_++; //XvCړI玟̍sp^[
                }
            } else {
                //XvCړ
                iMovePatternNo_++; //Ɏ̍sp^[
            }
            break;

        case 2:  //yp^[QFˏVbg˂Ǝ@֕]z
            if (pDepo_Shot_) {
                //ˏVbg
                int way = RF_EnemyAllas_ShotWay(G_RANK); //VbgWAY
                angle* paAng_way = NEW angle[way];
                UTIL::getRadialAngle2D(0, way, paAng_way);
                GgafDxDrawableActor* pActor_Shot;
                for (int i = 0; i < way; i++) {
                    pActor_Shot = (GgafDxDrawableActor*)pDepo_Shot_->dispatch();
                    if (pActor_Shot) {
                        pActor_Shot->positionAs(this);
                        pActor_Shot->_pKurokoA->setRzRyMvAng(paAng_way[i], D90ANG);
                        pActor_Shot->activate();
                    }
                }
                GGAF_DELETEARR(paAng_way);
                //Vbg˃GtFNg
                if (pDepo_ShotEffect_) {
                    GgafDxDrawableActor* pTestActor_Shot = (GgafDxDrawableActor*)pDepo_ShotEffect_->dispatch();
                    if (pTestActor_Shot) {
                        pTestActor_Shot->positionAs(this);
                    }
                }
            }
//            //@֕]
            _pKurokoA->turnMvAngTwd(P_MYSHIP->_X, _Y, P_MYSHIP->_Z,
                                    2000, 0,
                                    TURN_CLOSE_TO, true);
            iMovePatternNo_++; //̍sp^[
            break;

        case 3:  //ysp^[Rz

            break;
        default:
            break;
    }

    if (pKurokoLeader_) {
        pKurokoLeader_->behave(); //XvCړU镑
    }
    _pKurokoA->behave();
    //_pSeTx->behave();
}

void EnemyAllas::processJudgement() {
    if (isOutOfUniverse()) {
        sayonara();
    }
}

void EnemyAllas::onHit(GgafActor* prm_pOtherActor) {
    bool was_destroyed = UTIL::proceedEnemyHit(this, (GgafDxGeometricActor*)prm_pOtherActor);
    if (was_destroyed) {
        //j
        _pSeTx->play3D(SE_EXPLOSION);
    } else {
        //j
    }
}

void EnemyAllas::onInactive() {
    sayonara();
}

EnemyAllas::~EnemyAllas() {
    GGAF_DELETE_NULLABLE(pKurokoLeader_);
}
