#include "jp/ggaf/core/util/GgafLinearOctreeElem.h"

#include "jp/ggaf/core/util/GgafLinearOctreeOctant.h"
#include "jp/ggaf/core/util/GgafLinearOctree.h"

using namespace GgafCore;

GgafLinearOctreeElem::GgafLinearOctreeElem(GgafLinearOctree* prm_pLinearOctree, GgafObject* prm_pObject, uint32_t prm_kindbit) : GgafObject() ,
    _pLinearOctree(prm_pLinearOctree),
    _pObject(prm_pObject)
{
    _kindbit = prm_kindbit;
    _pOctant_current = nullptr;
    _pNext = nullptr;
    _pPrev = nullptr;
    _pRegLinkNext = nullptr;
}

void GgafLinearOctreeElem::clear() {
    if(_pOctant_current == nullptr) {
        //_TRACE_("GgafLinearOctreeElem::extract() ł܂BӐ}Ă܂H");
        return;
    }
    //񃊃Zbg
    uint32_t index = _pOctant_current->_my_index;
    GgafLinearOctreeOctant* paOctant = _pLinearOctree->_paOctant;
    while (true) {
        if (paOctant[index]._kindinfobit == 0 ) {
            break;
        } else {
            paOctant[index]._kindinfobit = 0;
            paOctant[index]._pElem_first = nullptr;
            paOctant[index]._pElem_last = nullptr;
        }

        if (index == 0) {
            break;
        }
        // eԗvfԍŌJԂ
        index = (index-1)>>3;
    }
    _pNext = nullptr;
    _pPrev = nullptr;
    _pOctant_current = nullptr;

//vf͊eԂɃXgɂԂ牺Ă邽߁Aclear() ̋@\{YɎȂ΁A
//Ԃ _kindinfobit  XOR ȂǂărbgAZbgA
//_pElem_firstA_pElem_last ̃|C^̍iXgj؂藣ׂłB
//Aǂ clear() gp̂́ASԑSvfNAƂł̂ŁA
//_kindinfobit ́Al 0 ݒB _pElem_first  _pElem_last ȂnullptrŃNAB
//P clear() ƂƁAԏ͕邱Ƃ𒍈ӁAAvP[VWbN clear() ͎gpȂƁB
//{c[́Ao^ƁANÂݍsƂ݌v
}

void GgafLinearOctreeElem::belongTo(GgafLinearOctreeOctant* const prm_pOctant_target) {
    if (_pOctant_current == prm_pOctant_target) {
        //_TRACE_("belongToł");
        return;
    } else {
        if (prm_pOctant_target->_pElem_first == nullptr) {
            //PԖڂɒǉ̏ꍇ
            prm_pOctant_target->_pElem_first = this;
            prm_pOctant_target->_pElem_last = this;
//nullptrclearݒς݁BȗĂvȂ͂B
//            _pNext = nullptr;
//            _pPrev = nullptr;
            _pOctant_current = prm_pOctant_target;
        } else {
            //ɒǉ̏ꍇ
            prm_pOctant_target->_pElem_last->_pNext = this;
            _pPrev = prm_pOctant_target->_pElem_last;
//nullptrclearݒς݁BȗĂvȂ͂B
//            _pNext = nullptr;
            prm_pOctant_target->_pElem_last = this;
            _pOctant_current = prm_pOctant_target;
        }
    }
    //̗vfԍ
    uint32_t index = prm_pOctant_target->_my_index;
    GgafLinearOctreeOctant* const paOctant = _pLinearOctree->_paOctant;
    const uint32_t this_kindbit = this->_kindbit;
    //eԂׂĂɗvfʏ𗬂
    while (true) {
        if (paOctant[index]._kindinfobit & this_kindbit) {
            //ʏ񂪐ݒς݂Ȃ΁Aȏ̐eݒςׁ݂̈A
            break;
        } else {
            //ԂɎʏ񂪖ݒȂΐݒ
            paOctant[index]._kindinfobit |= this_kindbit;
        }
        if (index == 0) {
            break;
        }
        //̐eԗvfԍŌJԂ
        index = (index-1)>>3;
    }
}

void GgafLinearOctreeElem::dump() {
    _TRACE_N_("o");
}

GgafLinearOctreeElem::~GgafLinearOctreeElem() {
}
