#include "jp/ggaf/core/GgafGod.h"

#include "jp/ggaf/core/exception/GgafCriticalException.h"
#include "jp/ggaf/core/GgafFactory.h"
#include "jp/ggaf/core/GgafGarbageBox.h"
#include "jp/ggaf/core/GgafProperties.h"
#include "jp/ggaf/core/scene/GgafSpacetime.h"
#include "jp/ggaf/core/scene/GgafDisusedScene.h"
#include "jp/ggaf/core/actor/GgafDisusedActor.h"

#include <process.h>

using namespace GgafCore;

GgafCriticalException* GgafGod::_pException_factory = nullptr;

CRITICAL_SECTION GgafGod::CS1;
CRITICAL_SECTION GgafGod::CS2;

int GgafGod::_num_actor_drawing = 0;
GgafGod* GgafGod::_pGod = nullptr;
DWORD GgafGod::_aaTime_offset_of_next_view[3][60] = {
        {17,17,16,17,17,16,17,17,16,17,17,16,17,17,16,17,17,16,17,17,16,17,17,16,17,17,16,17,17,16,17,17,16,17,17,16,17,17,16,17,17,16,17,17,16,17,17,16,17,17,16,17,17,16,17,17,16,17,17,16},
        {25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25},
        {33,33,34,33,33,34,33,33,34,33,33,34,33,33,34,33,33,34,33,33,34,33,33,34,33,33,34,33,33,34,33,33,34,33,33,34,33,33,34,33,33,34,33,33,34,33,33,34,33,33,34,33,33,34,33,33,34,33,33,34}
};

GgafGod::GgafGod() : GgafObject(),
  _pSpacetime(nullptr),
  _fps(0) {
    timeBeginPeriod(1);
    _frame_of_God = 0;
    _handleFactory01 = (HANDLE)_beginthreadex(nullptr, 0, GgafCore::GgafFactory::work, nullptr, CREATE_SUSPENDED, &_thID01);

    if (_handleFactory01 == 0) {
        throwGgafCriticalException("GgafGod::GgafGod() Error! Xbh쐬sI");
    }
    ::InitializeCriticalSection(&(GgafGod::CS1));
    ::InitializeCriticalSection(&(GgafGod::CS2));
    ::ResumeThread(_handleFactory01);
    ::SetThreadPriority(_handleFactory01, THREAD_PRIORITY_IDLE);
    GgafGod::_pGod = this;
    _time_at_beginning_frame = timeGetTime();
    _time_of_next_view = (frame)(_time_at_beginning_frame);
    _time_calc_fps_next = _time_at_beginning_frame + 1;
    _visualize_frames = 0;
    _prev_visualize_frames = 0;
    _is_behaved_flg = false;
    _is_materialized_flg = false;
    GgafGarbageBox::_pGarbageBox = NEW GgafGarbageBox();
    _was_cleaned = false;
    _skip_count_of_frame = 0;
    _max_skip_frames = (int)PROPERTY::MAX_SKIP_FRAME;
    _slowdown_mode = SLOWDOWN_MODE_DEFAULT;
    _sync_frame_time = false;
    _cnt_frame = 0;
}

void GgafGod::be() {

    // yz
    // PTCNiPt[j͈̏ȉ̗lɑ傫TɕAɎŝƂB
    //
    // @Mo = presentSpacetimeMoment();      CEK{
    // AJu = executeSpacetimeJudge();       菈EK{
    // BMa = makeSpacetimeMaterialize();    `揈(d)EXLbv
    // CVi = presentSpacetimeVisualize();   `tbvEXLbv(ABƇC̓Zbg)
    // DFi = finalizeSpacetime();           ŏIEK{
    //
    // ōsȂƂ́włACVi  1/60 bɈ肵Ďs邱ƁxƂB
    // ŁA̗lȐ݌vsB
    // E悸 CVi s^C~O\ߌ肷B́A@ɏdȂ낤ƂςȂB
    //    _time_of_next_view = _time_of_next_view + (1/60b)
    //   ƂB
    // EAJu s_ŁABMaACVi s邩ǂc_time_of_next_view ܂ł̎ԂŔfB
    //   Ԃɗ]TLꍇAAJu s㑦 BMa sǍ _time_of_next_view ܂ő҂ CVi sB
    //    AJu sAt[ɂ߂荞łꍇ BMaACVi ̓XLbvB
    // EL{[ƂA_max_skip_frames t[ɂP͕K BMaACVi sB
    //   ͂ǂȂɏdȂ낤ƂAvOĂ邱Ƃo邽߁B
    //
    //
    //y莞̗z}z
    //        _time_of_next_view                                              _time_of_next_view
    //                 |              3frame begin                                      |              4frame begin
    //                 |                   |                                            |                   |
    //                 v                   v                                            v                   v
    // ==================================================================================================================================================> 
    //  <--- wait ---> |(2f-CVi)| 2f-DFi | 3f-@Mo | 3f-AJu |(3f-BMa)|<--- wait --->|(3f-CVi)| 3f-DFi | 4f-@Mo | 4f-AJu |(4f-BMa)|<--- wait -
    //                 |                   |                                            |                   |
    // -- 2frame ------------------------->|<-------------------------- 3frame ---------------------------->|<----------------  4frame ---------
    //                 |                                                                |
    //                 |<----------------------- 1/60 sec ----------------------------->|
    //                 |                                                 |
    //                 |<--- I΁AOl߂ɂł ------>|
    //                       ̕wait肷B
    //
    // Ӂ
    // E܂ CVi  1/60 bDŖڎwdg݂łāA
    //   t[JE^ 1/60 bɃJEgAbvƂdg݂ł͖ilĂȂjB
    //   _time_of_next_view `  _time_of_next_view ͏ɌŒ莞(1/60 sec)ł邪A
    //   ႦΏ}ł 3frame begin  ` 4frame begin Ԃ̎Ԃ͑OɂϓB
    //

    if (_pSpacetime == nullptr) {
        //̐܂ꍇ́A悸̐쐬B
        _pSpacetime = createSpacetime();
#ifdef MY_DEBUG
        if (_pSpacetime == nullptr) {
            throwGgafCriticalException("GgafGod::be() Error! ̐ĉI");
        }
#endif
        _pSpacetime->_pGod = this;
        _time_at_beginning_frame = timeGetTime();
        _time_of_next_view = (frame)(_time_at_beginning_frame+100); //0.1bJn
        _time_calc_fps_next = _time_at_beginning_frame + 1;
    }
#ifdef MY_DEBUG
    //HiʃXbhjO`FbN
    if (_pException_factory) {
        throw *_pException_factory;
    }
#endif

    if (_is_behaved_flg == false) {
        _is_behaved_flg = true;
        BEGIN_SYNCHRONIZED1; // ----->rJn
        _frame_of_God++;
        presentSpacetimeMoment(); //@
        executeSpacetimeJudge();  //A
        _time_of_next_view += _aaTime_offset_of_next_view[_slowdown_mode][_cnt_frame];
        _cnt_frame++;
        if (_cnt_frame == 60) { _cnt_frame = 0; }
        if (timeGetTime() >= _time_of_next_view) { //`^C~Ot[ɂȂA͉߂Ăꍇ
            //makeSpacetimeMaterialize ̓pX
            _is_materialized_flg = false;
        } else {
            //`^C~Ot[ɂȂĂȂB]TB
             _is_materialized_flg = true;
            makeSpacetimeMaterialize(); //B
            //A makeSpacetimeMaterialize() ɂI[o[邩ȂB
        }
        END_SYNCHRONIZED1;  // <-----rI
    }

    _time_at_beginning_frame = timeGetTime();

    if (_time_at_beginning_frame >= _time_of_next_view) {
        //`^C~Ot[ɂȂA͉߂Ăꍇ
        BEGIN_SYNCHRONIZED1;  // ----->rJn
        if (_is_materialized_flg) { // B makeSpacetimeMaterialize() sς݂̏ꍇ
            //`LiXLbvȂj
            presentSpacetimeVisualize(); _visualize_frames++; //C
            finalizeSpacetime(); //D
        } else {                   // B makeSpacetimeMaterialize() sĂȂꍇ
            //`斳iXLbvj
            if (_sync_frame_time) { //[h
                //ŕ`ȂB
                finalizeSpacetime(); //D
            } else {   //[hł͂Ȃꍇ͒ʏXLbv
                _skip_count_of_frame++;
                //AAXLbvƂĂ MAX_SKIP_FRAME t[ɂP͕`͂B
                if (_skip_count_of_frame >= _max_skip_frames) {
                    makeSpacetimeMaterialize(); //B
                    presentSpacetimeVisualize(); _visualize_frames++; //C
                    finalizeSpacetime();        //D
                    _skip_count_of_frame = 0;
                } else {
                    finalizeSpacetime(); //D
                }
            }
        }
        _is_behaved_flg = false;
        END_SYNCHRONIZED1;    // <-----rI

        //fpsvZ
        if (_time_at_beginning_frame >= _time_calc_fps_next) {
            const int d_visualize_frames = _visualize_frames - _prev_visualize_frames;
            if (d_visualize_frames == 0) {
                _fps = 0;
            } else {
                _fps = (float)(d_visualize_frames) * (1000.0f / 100);
            }
            _time_calc_fps_next += 100;
            _prev_visualize_frames = _visualize_frames;
        }

     } else { //`^C~Ot[ɂȂĂȂ(]T)
         _sync_frame_time = false;
         Sleep(1); //<--- wait --->  ЂƂƂ
     }
    return;
}

void GgafGod::presentSpacetimeMoment() {
    _pSpacetime->nextFrame();
    _pSpacetime->behave();
}

void GgafGod::executeSpacetimeJudge() {
    _pSpacetime->settleBehavior();
    _pSpacetime->judge();
}

void GgafGod::makeSpacetimeMaterialize() {
    if (_num_actor_drawing > PROPERTY::DRAWNUM_TO_SLOWDOWN2) {
        _slowdown_mode = SLOWDOWN_MODE_30FPS;
    } else if (_num_actor_drawing > PROPERTY::DRAWNUM_TO_SLOWDOWN1) {
        _slowdown_mode = SLOWDOWN_MODE_40FPS;
    } else {
        _slowdown_mode = SLOWDOWN_MODE_DEFAULT;
    }
    _num_actor_drawing = 0;
    GgafSpacetime* pSpacetime = _pSpacetime;
    pSpacetime->preDraw();
    pSpacetime->draw();
    pSpacetime->afterDraw();
}

void GgafGod::presentSpacetimeVisualize() {
    _pSpacetime->dump();
}

void GgafGod::finalizeSpacetime() {
    _pSpacetime->doFinally();
}

void GgafGod::clean() {
    if (!_was_cleaned) {
        _TRACE_("GgafGod::clean() start");
        if (_pSpacetime) {
            _TRACE_("_pSpacetime != nullptr");
            //H~߂
            Sleep(10);
            GgafFactory::_is_working_flg = false;
            _TRACE_("GgafGod::~GgafGod() Hꂪ܂ő҂EEE");
            for (int i = 0; GgafFactory::_was_finished_flg == false; i++) {
                Sleep(10); //Hꂪ܂ő҂
                if (i > 10*100*60) {
                    _TRACE_("GgafGod::~GgafGod() 10ҋ@܂AHꂩ甽܂Bbreak܂Bv");
                    break;
                }
            }
            _TRACE_("GgafGod::~GgafGod() Hꂪ܂");
            //r̉AXbhI܂ő҂
            _TRACE_("GgafGod::~GgafGod()  WaitForSingleObject(_handleFactory01, 120*1000) .....");
            DWORD r = WaitForSingleObject(_handleFactory01, 120*1000);  //DeleteCriticalSections߂ɕKv
            if (r == WAIT_TIMEOUT) {
                throwGgafCriticalException("GgafGod::~GgafGod() Hꂪɂ炸AQĂXbhcĂ܂B");
            }
            _TRACE_("GgafGod::~GgafGod()  CloseHandle(_handleFactory01) .....");
            CloseHandle(_handleFactory01);
            _TRACE_("GgafGod::~GgafGod()  DeleteCriticalSection(&(GgafGod::CS1)); .....");
            DeleteCriticalSection(&(GgafGod::CS1));
            _handleFactory01 = nullptr;
            _TRACE_("GgafGod::~GgafGod() ɍHXbhIBNeBJZNV");

#ifdef MY_DEBUG
            //c[\\
            _TRACE_("Dumping _pSpacetime ...");
            _pSpacetime->dump();
#endif

            //H|
            _TRACE_("GgafFactory::clean()");
            GgafFactory::clean();
            //S~
#ifdef MY_DEBUG
            _TRACE_("Dumping GgafGarbageBox::_pGarbageBox->_pDisusedScene ...");
            GgafGarbageBox::_pGarbageBox->_pDisusedScene->dump();
            _TRACE_("GgafGarbageBox::_pGarbageBox->_pDisusedActor ...");
            GgafGarbageBox::_pGarbageBox->_pDisusedActor->dump();
#endif
            _TRACE_("GGAF_DELETE(GgafGarbageBox::_pGarbageBox);");
            GGAF_DELETE(GgafGarbageBox::_pGarbageBox);
            //̐ŐĂ镨|
            Sleep(20);
            _TRACE_("GGAF_DELETE(_pSpacetime);");
            GGAF_DELETE(_pSpacetime);
            _TRACE_("GgafGod::~GgafGod()  DeleteCriticalSection(&(GgafGod::CS2)); .....");
            DeleteCriticalSection(&(GgafGod::CS2));
        }

        //HO _pException_factory NĂ邩ȂB
        _TRACE_("GGAF_DELETE_NULLABLE(_pException_factory);");
        GGAF_DELETE_NULLABLE(_pException_factory);
        _TRACE_("GgafGod::clean() end");
    }
}


GgafGod::~GgafGod() {
    timeEndPeriod(1);
    clean();
    _was_cleaned = true;
}
