#ifndef GGAFCORE_GGAFACTORDEPOSITORY_H_
#define GGAFCORE_GGAFACTORDEPOSITORY_H_
#include "GgafCommonHeader.h"
#include "jp/ggaf/core/actor/ex/GgafDestructActor.h"

namespace GgafCore {

/**
 * AN^[ۊǏilރoNjNX .
 * AN^[̃Tuɗ\ߊAN^[o^(addSubLast)ăXgbNB<BR>
 * dispatch() \bhĂяoƁAf|Wg̊ĂȂAN^[TĒ񋟂B<BR>
 * AN^[͎gIinactivate()ƁAXgbNɖ߂ƂɂȂB<BR>
 * eȂǉxg܂킵AN^[AoꍇɗLƂȂnYłB<BR>
 * A dispatch() ̏ꍇAdispatch()̃AN^[Kc[̗דmƂȂĂƂ@B<BR>
 * ́Adispatch() AN^[́AXgbNт̈ԍŌɉ񂳂邽߁B<BR>
 * |Ci[U[ĵЂƓZ܂̒PʂƂĎgpł邩ȂAƖژ_ށB<BR>
 * (RotationActor)
 * @version 1.00
 * @since 2008/08/11
 * @author Masatoshi Tsuge
 */
class GgafActorDepository : public GgafDestructActor {
private:
    //gps
    void addSubLast(GgafActor* prm_pSub) override {
    }

public:
    /**
     * RXgN^ .
     * @param prm_name
     * @param prm_pStat
     */
    GgafActorDepository(const char* prm_name, GgafStatus* prm_pStat = nullptr);

    /**
     * ݏoo[(GgafActor)ǉo^܂.
     * XgbN̒ǉIȃC[WłB<BR>
     * GgafNode<T>::addSubLast() sOɁAAN^[ʂ̂ps܂B
     * ŏɓo^AN^[̎ʂA{f|Wg̎ʂƂȂ܂B
     * ȍ~͓ʂ̃AN^[o^鐧܂B<BR>
     * ܂ÃAN^[ɂ inactivateImmed() sAo[͔񊈓Ԃɋ܂B<BR>
     * @param prm_pSub ݏoo[AN^[
     */
    virtual void put(GgafActor* prm_pSub);

    /**
     * activaten͎qAN^[ւ͉eȂ悤ɂ .
     * qAN^[i݂oo[j́Adispatch() ł̂݊Ԃɂ邽߁B
     */
    virtual void activateTree() override {
        activate();
    }

    /**
     * activaten͎qAN^[ւ͉eȂ .
     * qAN^[i݂oo[j́Adispatch() ł̂݊Ԃɂ邽߁B
     */
    virtual void activateTreeDelay(frame prm_offset_frames) override {
        activateDelay(prm_offset_frames);
    }

    /**
     * o[؂݁A؂łΎ擾ԂɂB .
     * ɂȃo[iactiveA܂active\񂳂ĂȂj݂΁A
     * 擾AԂɂixݒjB<BR>
     * ɂȃo[Ȃꍇ nullptr Ԃ܂B<BR>
     * 擾łꍇAAN^[ activate()sA|C^ԂƋɁA
     * ̃AN^[̓AN^[҂̃TüԌɈړ܂B<BR>
     * ꎞIɃLh悤ȃC[W<BR>
     * gp၄
     * <pre><code>
     * GgafMainActor* pActor = pDepository->dispatch();
     * if (pActor) {
     *     //AN^[̏
     *     //EEE
     *
     * }
     * </code></pre>
     *
     * @param prm_offset_frames Ԃɂxt[
     * @return AN^[҂̉ɂȃo[AN^[̃|C^
     */
    virtual GgafCore::GgafMainActor* dispatch(int prm_offset_frames = 1) {
#ifdef MY_DEBUG
        if (_pSubFirst == nullptr) {
            throwGgafCriticalException("GgafActorDepository::dispatch() this="<<NODE_INFO<<" ̎q܂");
        }
        if (_is_active_flg || _frame_of_life+1 == _frame_of_life_when_activation) {
            //tOĂ遨薳
            //邢́At[ŊtO\聨f|Wg̓t[̂ߋ
        } else {
            //RRɗꍇŁAzp^[͎̂悤ȏꍇ
            //@ [U[`bṽZbg؂ŁAGgafActorDepositoryStore::dispatch() sA`bṽZbg̃f|Wg𓾂AɎgpPt[ȏقƂA
            //   f|WgA`bvdispatch()悤ƂꍇB
            //      ̏ꍇAȉ̌xbZ[WAŕ\邱ƂɂȂ̂ŏCȂ΂ȂȂB
            throwGgafCriticalException("GgafActorDepository::dispatch() this="<<NODE_INFO<<" 񊈓ȃf|Wgdispatch()͋CłB");
        }
#endif
        frame offset_frames = (prm_offset_frames < 1 ? 1 : prm_offset_frames);
        GgafMainActor* pActor = (GgafMainActor*)_pSubFirst;
        while (true) {
            if (pActor->_is_active_flg == false && pActor->willActivateAfter() == false) {
                //擾I
                pActor->moveLast(); //Kɉ
                pActor->activateDelay(offset_frames); //activatesB
                break;
            } else {   //ÁAt[\̏ꍇ͌
                if (pActor->_is_last_flg) {
                    pActor = nullptr;
                    break;
                } else {
                    pActor = (GgafMainActor*)(pActor->_pNext);
                    continue;
                }
            }
        }
        return pActor;
    }

    /**
     * IɃAN^[o .
     * AN^[҂̉ɂȃTuo[iactiveA܂active\񂳂ĂȂj
     * Ȃꍇ́Ão[𖳗艡肵Ď擾B<BR>
     * dispatch() ݂ĎoȂꍇAIɃo[B̐擪o[Ԃ܂B<BR>
     * <b>Ӂ</b><BR>
     * oAAN^[ active() sĂÃAN^[ɊԂ̉\A܂
     * isActiveInTheTree()  true ̏Ԃ肤邽߁AonActive() R[obN͌Ă΂Ȃ\B<BR>
     * onInctive(); onActive(); R[obNĂяoꍇɎ̂悤ȃR[h
     * Ȃ΂ȂmȂB<BR>
     * <pre><code>
     * GgafMainActor* pActor = pDepository->dispatchForce();
     * if (pActor->isActiveInTheTree()) {
     *     pActor->onInctive();
     *     pActor->_frame_of_behaving_since_onActive = 1;
     *     pActor->onActive();
     * }
     * pActor->active();
     * </code></pre>
     *
     * @param prm_offset_frames Ԃɂxt[
     * @return
     */
    virtual GgafMainActor* dispatchForce() {
        GgafMainActor* pActor = dispatch(1);
        if (pActor == nullptr) {
            pActor = (GgafMainActor*)getSubFirst();
            pActor->moveLast(); //Kɉ
        }
        return pActor;
    }

    /**
     * Zbg̏ .
     * o[SinactivateImmed()܂B
     */
    virtual void onReset() override;

    virtual void end(frame prm_offset_frames = 1) override;

    virtual ~GgafActorDepository() {
    }
};

}
#endif /*GGAFCORE_GGAFACTORDEPOSITORY_H_*/
