#ifndef GGAFCORE_GGAFCURTAIN_H_
#define GGAFCORE_GGAFCURTAIN_H_
#include "jp/ggaf/core/GgafObject.h"

namespace GgafCore {

enum GgafCurtainState {
    OPEN,
    OPENING,
    OPENED,
    CLOSE,
    CLOSING,
    CLOSED
};

/**
 * V[̃J[e .
 * J[eJA̊Ǘ܂B<BR>
 * @version 1.00
 * @since 2010/04/21
 * @author Masatoshi Tsuge
 */
class GgafCurtain : public GgafObject {

public:
    /** [r]݂̃J[ȅ */
    GgafCurtainState _state;
    /** [r/w]J[e̒ */
    float _curtain_length;
    /** [r]݂̃J[e̒(J) */
    float _now_curtain_length;
    /** [r]J[eJۂ̑x */
    float _opening_velocity;
    /** [r]J[e߂ۂ̑x */
    float _closing_velocity;

public:
    /**
     * RXgN^ .
     * J[e̒̓ftHg 1.0 ɐݒ肳܂B<BR>
     * ܂AԂ̓J[e͊JĂ܂B<BR>
     * @param prm_curtain_length J[e̒(ftHg 1.0)
     */
    GgafCurtain(float prm_curtain_length = 1.0f);

    /**
     * J[eXɊJ .
     * {\bhsƁAbehave() Ăяo邲Ƃ
     * prm_opening_velocity ÂJ[eJ܂iZȂ܂jB
     * J[ê͒ 0.0 ܂łB 0.0  ɒBƁAprocessCloseDone() 
     * R[obN open ͏I܂B
     * @param prm_opening_velocity J[eJ鑬x
     */
    virtual void open(float prm_opening_velocity);

    /**
     * J[e𑦍ɍőɊJ .
     * {\bhs J[e̒ 0.0 ɂȂ܂B
     * processOpenDone() PR[obN܂B
     */
    virtual void open();

    /**
     * J[eXɕ߂ .
     * {\bhsƁAbehave() Ăяo邲Ƃ
     * prm_closing_velocity ÂJ[eĂ䂫܂iȂ܂jB<BR>
     * J[e̒̍ő̓ftHg 1.0 łB
     * ftHgł͒ 1.0 ɒBƁAprocessCloseDone() P
     * R[obNAclose ͏I܂B
     * @param prm_closing_velocity J[e߂鑬x
     */
    virtual void close(float prm_closing_velocity);

    /**
     * J[e𑦍ɕ߂ .
     * {\bhs J[e̒ 1.0 ɂȂ܂B
     * processOpenDone() PR[obN܂B
     */
    virtual void close();

    /**
     * J[e𓮂 .
     * {NX@\ɂɂ́At[̃\bhsĂB
     * t[ behave() 邱ƂŎ̃\bhKXĂяo悤ɂȂ܂B
     * <code>
     * processOpenBegin()
     * processOpening()
     * processOpenDone()
     * processCloseBegin()
     * processClosing()
     * processCloseDone()
     * </code>
     */
    virtual void behave();

    /**
     * J[eJn߂uԂ̏ .
     * open() ɂPxĂяo܂B <BR>
     * ʂŎۂ̏ĂB<BR>
     */
    virtual void processOpenBegin() = 0;

    /**
     * J[eJĂȑ .
     * ʂŎۂ̏ĂB<BR>
     */
    virtual void processOpening() = 0;

    /**
     * J[eJ̏ .
     * _now_curtain_length  0.0 ɂȂۂPxĂяo܂B <BR>
     * ʂŎۂ̏ĂB<BR>
     */
    virtual void processOpenDone() = 0;

    /**
     * J[e܂n߂uԂ̏ .
     * close() ɂPxĂяo܂B <BR>
     * ʂŎۂ̏ĂB<BR>
     */
    virtual void processCloseBegin() = 0;

    /**
     * J[e܂Ăȑ .
     * ʂŎۂ̏ĂB<BR>
     */
    virtual void processClosing() = 0;

    /**
     * J[e܂̏ .
     * _now_curtain_length  _curtain_length ɂȂۂPxĂяo܂B <BR>
     * ʂŎۂ̏ĂB<BR>
     */
    virtual void processCloseDone() = 0;


    virtual ~GgafCurtain();
};

}
#endif /*GGAFCORE_GGAFCURTAIN_H_*/
