﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Threading.Tasks;
using System.IO;
using Windows.UI.Core;
using Windows.Storage.Pickers;
using Windows.Storage;
using Windows.ApplicationModel.DataTransfer;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.System;
using FooEditEngine.Metro;

// 基本ページのアイテム テンプレートについては、http://go.microsoft.com/fwlink/?LinkId=234237 を参照してください

namespace FooEditor
{
    /// <summary>
    /// 多くのアプリケーションに共通の特性を指定する基本ページ。
    /// </summary>
    public sealed partial class DocumentPage : FooEditor.Common.LayoutAwarePage
    {
        DocumentControl document;
        Page rootPage;

        public DocumentPage()
        {
            this.InitializeComponent();
            this.DataContext = this;

            Window.Current.CoreWindow.KeyUp += this.DocumentPage_KeyUp;
        }

        /// <summary>
        /// このページには、移動中に渡されるコンテンツを設定します。前のセッションからページを
        /// 再作成する場合は、保存状態も指定されます。
        /// </summary>
        /// <param name="navigationParameter">このページが最初に要求されたときに
        /// <see cref="Frame.Navigate(Type, Object)"/> に渡されたパラメーター値。
        /// </param>
        /// <param name="pageState">前のセッションでこのページによって保存された状態の
        /// ディクショナリ。ページに初めてアクセスするとき、状態は null になります。</param>
        protected override void LoadState(Object navigationParameter, Dictionary<String, Object> pageState)
        {
            DataTransferManager.GetForCurrentView().DataRequested += DocumentPage_DataRequested;

            DocumentPageParam param = (DocumentPageParam)navigationParameter;
            
            this.document = param.Document;
            this.rootPage = param.RootPage;

            if (this.document != null)
            {
                this.Content = this.document;
            }
        }

        /// <summary>
        /// アプリケーションが中断される場合、またはページがナビゲーション キャッシュから破棄される場合、
        /// このページに関連付けられた状態を保存します。値は、
        /// <see cref="SuspensionManager.SessionState"/> のシリアル化の要件に準拠する必要があります。
        /// </summary>
        /// <param name="pageState">シリアル化可能な状態で作成される空のディクショナリ。</param>
        protected override void SaveState(Dictionary<String, Object> pageState)
        {
            DataTransferManager.GetForCurrentView().DataRequested -= DocumentPage_DataRequested;
            this.Content = null;
        }

        void DocumentPage_DataRequested(DataTransferManager sender, DataRequestedEventArgs args)
        {
            this.document.GetData(args);
        }

        void DocumentPage_KeyUp(object sender, KeyEventArgs e)
        {
            if (WindowUtils.IsModiferKeyPressed(VirtualKey.Control))
            {
                switch (e.VirtualKey)
                {
                    case VirtualKey.F:
                        this.SearchButton_Click(this, null);
                        break;
                    case VirtualKey.G:
                        this.GoToButton_Click(this, null);
                        break;
                    case VirtualKey.S:
                        this.SaveButton_Click(this, null);
                        break;
                }
            }
        }

        private async void SaveButton_Click(object sender, RoutedEventArgs e)
        {
            FileSavePicker savePicker = new FileSavePicker();
            savePicker.SuggestedStartLocation = PickerLocationId.DocumentsLibrary;
            ObservableCollection<FileType> collection = AppSettings.Current.FileTypeCollection;
            foreach (FileType type in collection)
                savePicker.FileTypeChoices.Add(type.DocumentTypeName, type.ExtensionCollection);
            savePicker.SuggestedStartLocation = PickerLocationId.DocumentsLibrary;
            StorageFile file = await savePicker.PickSaveFileAsync();
            if (file != null)
            {
                await this.document.SaveFile(file);
            }
        }

        private void SearchButton_Click(object sender, RoutedEventArgs e)
        {
            var popup = this.document.CreatePopup(typeof(FindFlyout));
            popup.IsOpen = true;
            CloseAllAppBar();
        }

        private void GoToButton_Click(object sender, RoutedEventArgs e)
        {
            var popup = this.document.CreatePopup(typeof(GoToFlyout));
            popup.IsOpen = true;
            CloseAllAppBar();
        }

        private void PropertyButton_Click(object sender, RoutedEventArgs e)
        {
            var flyout = new PropertyFlyout();
            flyout.DocumentType = this.document.DocumentType;
            flyout.PropertyChanged += async (s, args) =>
            {
                await this.document.SetDocumentType(flyout.DocumentType);
            };
            var popup = FlyoutUtils.CreateFlyoutUnderTopAppBar(flyout);
            popup.IsOpen = true;
            CloseAllAppBar();
        }

        private void CloseAllAppBar()
        {
            this.rootPage.TopAppBar.IsOpen = false;
            this.BottomAppBar.IsOpen = false;
        }

        private void UndoButton_Click(object sender, RoutedEventArgs e)
        {
            this.document.Undo();
        }

        private void RedoButton_Click(object sender, RoutedEventArgs e)
        {
            this.document.Redo();
        }
    }
    struct DocumentPageParam
    {
        public Page RootPage;
        public DocumentControl Document;
        public DocumentPageParam(Page root, DocumentControl info)
        {
            this.RootPage = root;
            this.Document = info;
        }
    }
}
