﻿using System.Collections.ObjectModel;
using System.ComponentModel;
using Windows.UI.Xaml.Controls;
using System.Runtime.CompilerServices;

// ユーザー コントロールのアイテム テンプレートについては、http://go.microsoft.com/fwlink/?LinkId=234236 を参照してください

namespace FooEditor
{
    public sealed partial class PropertyFlyout : Page,INotifyPropertyChanged
    {
        FileType _FileType;
        public PropertyFlyout()
        {
            this.InitializeComponent();
            this.FlyoutContent.DataContext = this;
        }

        public event PropertyChangedEventHandler PropertyChanged;

        public FileType DocumentType
        {
            get
            {
                return this._FileType;
            }
            set
            {
                this._FileType = value;
                this.OnPropertyChanged();
            }
        }

        public ObservableCollection<FileType> FileTypeCollection
        {
            get
            {
                return AppSettings.Current.FileTypeCollection;
            }
        }

        void OnPropertyChanged([CallerMemberName] string propertyName = null)
        {
            var eventHandler = this.PropertyChanged;
            if (eventHandler != null)
            {
                eventHandler(this, new PropertyChangedEventArgs(propertyName));
            }
        }
    }
}
