﻿using System;
using System.ComponentModel;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using System.Runtime.CompilerServices;
using FooEditEngine.Metro;

// ユーザー コントロールのアイテム テンプレートについては、http://go.microsoft.com/fwlink/?LinkId=234236 を参照してください

namespace FooEditor
{
    public sealed partial class GoToFlyout : UserControl, INotifyPropertyChanged
    {
        GoToFlyoutModel model;
        int _ToRow, _MaxLineNumber;
        public GoToFlyout()
        {
            this.InitializeComponent();
            this.DataContext = this;
        }

        public GoToFlyout(FooTextBox textbox)
            :this()
        {
            this.model = new GoToFlyoutModel(textbox);
            this.ToRow = textbox.CaretPostion.row;
            this.LineCount = textbox.LayoutLineCollection.Count - 1;
        }

        public event PropertyChangedEventHandler PropertyChanged;

        public string Result
        {
            get { return (string)GetValue(ResultProperty); }
            set { SetValue(ResultProperty, value); }
        }

        // Using a DependencyProperty as the backing store for Result.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty ResultProperty =
            DependencyProperty.Register("Result", typeof(string), typeof(GoToFlyout), new PropertyMetadata(string.Empty));

        public int ToRow
        {
            get
            {
                return this._ToRow;
            }
            set
            {
                this._ToRow = value;
                this.OnPropertyChanged();
            }
        }

        public int LineCount
        {
            get
            {
                return this._MaxLineNumber;
            }
            private set
            {
                this._MaxLineNumber = value;
                this.OnPropertyChanged();
            }
        }

        void OnPropertyChanged([CallerMemberName] string propertyName = null)
        {
            var eventHandler = this.PropertyChanged;
            if (eventHandler != null)
            {
                eventHandler(this, new PropertyChangedEventArgs(propertyName));
            }
        }

        private void Button_Click(object sender, Windows.UI.Xaml.RoutedEventArgs e)
        {
            this.Result = string.Empty;
            var loader = new Windows.ApplicationModel.Resources.ResourceLoader();
            if (this.model.IsInvaildRow(this._ToRow))
            {
                this.Result = string.Format(loader.GetString("LineNumberOutOutOfRange"), this._MaxLineNumber);
                return;
            }
            this.model.JumpToRow(this._ToRow);
            Popup parent = this.Parent as Popup;
            if (parent != null)
                parent.IsOpen = false;
        }
    }
    class GoToFlyoutModel
    {
        FooTextBox TextBox;
        public GoToFlyoutModel(FooTextBox textbox)
        {
            this.TextBox = textbox;
        }
        public bool IsInvaildRow(int row)
        {
            return row < 0 || row > this.TextBox.LayoutLineCollection.Count - 1;
        }
        public void JumpToRow(int row)
        {
            this.TextBox.JumpCaret(row,0);
            this.TextBox.Refresh();
        }
    }
}
