﻿using System;
using Windows.UI.Xaml.Data;
using FooEditEngine;
using Windows.ApplicationModel.Resources;

namespace FooEditor
{
    public class TextPointConverter : IValueConverter
    {
        ResourceLoader loader = new ResourceLoader();
        public object Convert(object value, System.Type targetType, object parameter, string language)
        {
            TextPoint tp = (TextPoint)value;
            return string.Format(loader.GetString("TextPointFormat"), tp.row + 1, tp.col + 1);
        }

        public object ConvertBack(object value, System.Type targetType, object parameter, string language)
        {
            throw new NotImplementedException();
        }
    }

    public class RateConverter : IValueConverter
    {
        ResourceLoader loader = new ResourceLoader();
        public object Convert(object value, System.Type targetType, object parameter, string language)
        {
            double v = (double)value;
            return string.Format(loader.GetString("MagnificationPowerFormat"), (int)(v * 100));
        }

        public object ConvertBack(object value, System.Type targetType, object parameter, string language)
        {
            throw new NotImplementedException();
        }
    }

    public class LineBreakMethodConverter : IValueConverter
    {
        ResourceLoader loader = new ResourceLoader();

        public object Convert(object value, Type targetType, object parameter, string language)
        {
            LineBreakMethod method = (LineBreakMethod)value;
            switch (method)
            {
                case LineBreakMethod.None:
                    return loader.GetString("LineBreakMethodNone");
                case LineBreakMethod.CharUnit:
                    return loader.GetString("LineBreakMethodCharUnit");
                case LineBreakMethod.PageBound:
                    return loader.GetString("LineBreakMethodPageBound");
            }
            throw new ArgumentOutOfRangeException();
        }

        public object ConvertBack(object value, Type targetType, object parameter, string language)
        {
            string name = (string)value;
            if (name == loader.GetString("LineBreakMethodNone"))
                return LineBreakMethod.None;
            if (name == loader.GetString("LineBreakMethodCharUnit"))
                return LineBreakMethod.CharUnit;
            if (name == loader.GetString("LineBreakMethodPageBound"))
                return LineBreakMethod.PageBound;
            throw new ArgumentOutOfRangeException();
        }
    }
}
